/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.boss.enderdragon;

import com.google.common.collect.Lists;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.MathHelper;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityExperienceOrb;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.targeting.PathfinderTargetCondition;
import net.minecraft.world.entity.boss.EntityComplexPart;
import net.minecraft.world.entity.boss.enderdragon.EntityEnderCrystal;
import net.minecraft.world.entity.boss.enderdragon.phases.DragonControllerManager;
import net.minecraft.world.entity.boss.enderdragon.phases.DragonControllerPhase;
import net.minecraft.world.entity.boss.enderdragon.phases.IDragonController;
import net.minecraft.world.entity.monster.IMonster;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.dimension.end.EnderDragonBattle;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.feature.WorldGenEndTrophy;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.level.pathfinder.PathEntity;
import net.minecraft.world.level.pathfinder.PathPoint;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import org.slf4j.Logger;

public class EntityEnderDragon
extends EntityInsentient
implements IMonster {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final DataWatcherObject<Integer> DATA_PHASE = DataWatcher.defineId(EntityEnderDragon.class, DataWatcherRegistry.INT);
    private static final PathfinderTargetCondition CRYSTAL_DESTROY_TARGETING = PathfinderTargetCondition.forCombat().range(64.0);
    private static final int GROWL_INTERVAL_MIN = 200;
    private static final int GROWL_INTERVAL_MAX = 400;
    private static final float SITTING_ALLOWED_DAMAGE_PERCENTAGE = 0.25f;
    private static final String DRAGON_DEATH_TIME_KEY = "DragonDeathTime";
    private static final String DRAGON_PHASE_KEY = "DragonPhase";
    public final double[][] positions = new double[64][3];
    public int posPointer = -1;
    public final EntityComplexPart[] subEntities;
    public final EntityComplexPart head;
    private final EntityComplexPart neck;
    private final EntityComplexPart body;
    private final EntityComplexPart tail1;
    private final EntityComplexPart tail2;
    private final EntityComplexPart tail3;
    private final EntityComplexPart wing1;
    private final EntityComplexPart wing2;
    public float oFlapTime;
    public float flapTime;
    public boolean inWall;
    public int dragonDeathTime;
    public float yRotA;
    @Nullable
    public EntityEnderCrystal nearestCrystal;
    @Nullable
    private EnderDragonBattle dragonFight;
    private BlockPosition fightOrigin = BlockPosition.ZERO;
    private final DragonControllerManager phaseManager;
    private int growlTime = 100;
    private float sittingDamageReceived;
    private final PathPoint[] nodes = new PathPoint[24];
    private final int[] nodeAdjacency = new int[24];
    private final Path openSet = new Path();

    public EntityEnderDragon(EntityTypes<? extends EntityEnderDragon> var0, World var1) {
        super((EntityTypes<? extends EntityInsentient>)EntityTypes.ENDER_DRAGON, var1);
        this.head = new EntityComplexPart(this, "head", 1.0f, 1.0f);
        this.neck = new EntityComplexPart(this, "neck", 3.0f, 3.0f);
        this.body = new EntityComplexPart(this, "body", 5.0f, 3.0f);
        this.tail1 = new EntityComplexPart(this, "tail", 2.0f, 2.0f);
        this.tail2 = new EntityComplexPart(this, "tail", 2.0f, 2.0f);
        this.tail3 = new EntityComplexPart(this, "tail", 2.0f, 2.0f);
        this.wing1 = new EntityComplexPart(this, "wing", 4.0f, 2.0f);
        this.wing2 = new EntityComplexPart(this, "wing", 4.0f, 2.0f);
        this.subEntities = new EntityComplexPart[]{this.head, this.neck, this.body, this.tail1, this.tail2, this.tail3, this.wing1, this.wing2};
        this.setHealth(this.getMaxHealth());
        this.noPhysics = true;
        this.noCulling = true;
        this.phaseManager = new DragonControllerManager(this);
    }

    public void setDragonFight(EnderDragonBattle var0) {
        this.dragonFight = var0;
    }

    public void setFightOrigin(BlockPosition var0) {
        this.fightOrigin = var0;
    }

    public BlockPosition getFightOrigin() {
        return this.fightOrigin;
    }

    public static AttributeProvider.Builder createAttributes() {
        return EntityInsentient.createMobAttributes().add(GenericAttributes.MAX_HEALTH, 200.0);
    }

    @Override
    public boolean isFlapping() {
        float var0 = MathHelper.cos(this.flapTime * ((float)Math.PI * 2));
        float var1 = MathHelper.cos(this.oFlapTime * ((float)Math.PI * 2));
        return var1 <= -0.3f && var0 >= -0.3f;
    }

    @Override
    public void onFlap() {
        if (this.level().isClientSide && !this.isSilent()) {
            this.level().playLocalSound(this.getX(), this.getY(), this.getZ(), SoundEffects.ENDER_DRAGON_FLAP, this.getSoundSource(), 5.0f, 0.8f + this.random.nextFloat() * 0.3f, false);
        }
    }

    @Override
    protected void defineSynchedData() {
        super.defineSynchedData();
        this.getEntityData().define(DATA_PHASE, DragonControllerPhase.HOVERING.getId());
    }

    public double[] getLatencyPos(int var0, float var1) {
        if (this.isDeadOrDying()) {
            var1 = 0.0f;
        }
        var1 = 1.0f - var1;
        int var2 = this.posPointer - var0 & 0x3F;
        int var3 = this.posPointer - var0 - 1 & 0x3F;
        double[] var4 = new double[3];
        double var5 = this.positions[var2][0];
        double var7 = MathHelper.wrapDegrees(this.positions[var3][0] - var5);
        var4[0] = var5 + var7 * (double)var1;
        var5 = this.positions[var2][1];
        var7 = this.positions[var3][1] - var5;
        var4[1] = var5 + var7 * (double)var1;
        var4[2] = MathHelper.lerp((double)var1, this.positions[var2][2], this.positions[var3][2]);
        return var4;
    }

    @Override
    public void aiStep() {
        int var13;
        float var19;
        float var18;
        float var17;
        Object var15;
        Object var0;
        EnderDragonBattle var1;
        World world;
        this.processFlappingMovement();
        if (this.level().isClientSide) {
            this.setHealth(this.getHealth());
            if (!this.isSilent() && !this.phaseManager.getCurrentPhase().isSitting() && --this.growlTime < 0) {
                this.level().playLocalSound(this.getX(), this.getY(), this.getZ(), SoundEffects.ENDER_DRAGON_GROWL, this.getSoundSource(), 2.5f, 0.8f + this.random.nextFloat() * 0.3f, false);
                this.growlTime = 200 + this.random.nextInt(200);
            }
        }
        if (this.dragonFight == null && (world = this.level()) instanceof WorldServer && (var1 = ((WorldServer)(var0 = (WorldServer)world)).getDragonFight()) != null && this.getUUID().equals(var1.getDragonUUID())) {
            this.dragonFight = var1;
        }
        this.oFlapTime = this.flapTime;
        if (this.isDeadOrDying()) {
            float var02 = (this.random.nextFloat() - 0.5f) * 8.0f;
            float var12 = (this.random.nextFloat() - 0.5f) * 4.0f;
            float var2 = (this.random.nextFloat() - 0.5f) * 8.0f;
            this.level().addParticle(Particles.EXPLOSION, this.getX() + (double)var02, this.getY() + 2.0 + (double)var12, this.getZ() + (double)var2, 0.0, 0.0, 0.0);
            return;
        }
        this.checkCrystals();
        var0 = this.getDeltaMovement();
        float var14 = 0.2f / ((float)((Vec3D)var0).horizontalDistance() * 10.0f + 1.0f);
        this.flapTime = this.phaseManager.getCurrentPhase().isSitting() ? (this.flapTime += 0.1f) : (this.inWall ? (this.flapTime += var14 * 0.5f) : (this.flapTime += (var14 *= (float)Math.pow(2.0, ((Vec3D)var0).y))));
        this.setYRot(MathHelper.wrapDegrees(this.getYRot()));
        if (this.isNoAi()) {
            this.flapTime = 0.5f;
            return;
        }
        if (this.posPointer < 0) {
            for (int var2 = 0; var2 < this.positions.length; ++var2) {
                this.positions[var2][0] = this.getYRot();
                this.positions[var2][1] = this.getY();
            }
        }
        if (++this.posPointer == this.positions.length) {
            this.posPointer = 0;
        }
        this.positions[this.posPointer][0] = this.getYRot();
        this.positions[this.posPointer][1] = this.getY();
        if (this.level().isClientSide) {
            if (this.lerpSteps > 0) {
                double var2 = this.getX() + (this.lerpX - this.getX()) / (double)this.lerpSteps;
                var4 = this.getY() + (this.lerpY - this.getY()) / (double)this.lerpSteps;
                var6 = this.getZ() + (this.lerpZ - this.getZ()) / (double)this.lerpSteps;
                var8 = MathHelper.wrapDegrees(this.lerpYRot - (double)this.getYRot());
                this.setYRot(this.getYRot() + (float)var8 / (float)this.lerpSteps);
                this.setXRot(this.getXRot() + (float)(this.lerpXRot - (double)this.getXRot()) / (float)this.lerpSteps);
                --this.lerpSteps;
                this.setPos(var2, var4, var6);
                this.setRot(this.getYRot(), this.getXRot());
            }
            this.phaseManager.getCurrentPhase().doClientTick();
        } else {
            Vec3D var3;
            IDragonController var2 = this.phaseManager.getCurrentPhase();
            var2.doServerTick();
            if (this.phaseManager.getCurrentPhase() != var2) {
                var2 = this.phaseManager.getCurrentPhase();
                var2.doServerTick();
            }
            if ((var3 = var2.getFlyTargetLocation()) != null) {
                var4 = var3.x - this.getX();
                var6 = var3.y - this.getY();
                var8 = var3.z - this.getZ();
                double var10 = var4 * var4 + var6 * var6 + var8 * var8;
                float var12 = var2.getFlySpeed();
                double var132 = Math.sqrt(var4 * var4 + var8 * var8);
                if (var132 > 0.0) {
                    var6 = MathHelper.clamp(var6 / var132, (double)(-var12), (double)var12);
                }
                this.setDeltaMovement(this.getDeltaMovement().add(0.0, var6 * 0.01, 0.0));
                this.setYRot(MathHelper.wrapDegrees(this.getYRot()));
                var15 = var3.subtract(this.getX(), this.getY(), this.getZ()).normalize();
                Vec3D var16 = new Vec3D(MathHelper.sin(this.getYRot() * ((float)Math.PI / 180)), this.getDeltaMovement().y, -MathHelper.cos(this.getYRot() * ((float)Math.PI / 180))).normalize();
                var17 = Math.max(((float)var16.dot((Vec3D)var15) + 0.5f) / 1.5f, 0.0f);
                if (Math.abs(var4) > (double)1.0E-5f || Math.abs(var8) > (double)1.0E-5f) {
                    var18 = MathHelper.clamp(MathHelper.wrapDegrees(180.0f - (float)MathHelper.atan2(var4, var8) * 57.295776f - this.getYRot()), -50.0f, 50.0f);
                    this.yRotA *= 0.8f;
                    this.yRotA += var18 * var2.getTurnSpeed();
                    this.setYRot(this.getYRot() + this.yRotA * 0.1f);
                }
                var18 = (float)(2.0 / (var10 + 1.0));
                var19 = 0.06f;
                this.moveRelative(0.06f * (var17 * var18 + (1.0f - var18)), new Vec3D(0.0, 0.0, -1.0));
                if (this.inWall) {
                    this.move(EnumMoveType.SELF, this.getDeltaMovement().scale(0.8f));
                } else {
                    this.move(EnumMoveType.SELF, this.getDeltaMovement());
                }
                Vec3D var20 = this.getDeltaMovement().normalize();
                double var21 = 0.8 + 0.15 * (var20.dot(var16) + 1.0) / 2.0;
                this.setDeltaMovement(this.getDeltaMovement().multiply(var21, 0.91f, var21));
            }
        }
        this.yBodyRot = this.getYRot();
        Vec3D[] var2 = new Vec3D[this.subEntities.length];
        for (int var3 = 0; var3 < this.subEntities.length; ++var3) {
            var2[var3] = new Vec3D(this.subEntities[var3].getX(), this.subEntities[var3].getY(), this.subEntities[var3].getZ());
        }
        float var3 = (float)(this.getLatencyPos(5, 1.0f)[1] - this.getLatencyPos(10, 1.0f)[1]) * 10.0f * ((float)Math.PI / 180);
        float var4 = MathHelper.cos(var3);
        float var5 = MathHelper.sin(var3);
        float var6 = this.getYRot() * ((float)Math.PI / 180);
        float var7 = MathHelper.sin(var6);
        float var8 = MathHelper.cos(var6);
        this.tickPart(this.body, var7 * 0.5f, 0.0, -var8 * 0.5f);
        this.tickPart(this.wing1, var8 * 4.5f, 2.0, var7 * 4.5f);
        this.tickPart(this.wing2, var8 * -4.5f, 2.0, var7 * -4.5f);
        if (!this.level().isClientSide && this.hurtTime == 0) {
            this.knockBack(this.level().getEntities(this, this.wing1.getBoundingBox().inflate(4.0, 2.0, 4.0).move(0.0, -2.0, 0.0), IEntitySelector.NO_CREATIVE_OR_SPECTATOR));
            this.knockBack(this.level().getEntities(this, this.wing2.getBoundingBox().inflate(4.0, 2.0, 4.0).move(0.0, -2.0, 0.0), IEntitySelector.NO_CREATIVE_OR_SPECTATOR));
            this.hurt(this.level().getEntities(this, this.head.getBoundingBox().inflate(1.0), IEntitySelector.NO_CREATIVE_OR_SPECTATOR));
            this.hurt(this.level().getEntities(this, this.neck.getBoundingBox().inflate(1.0), IEntitySelector.NO_CREATIVE_OR_SPECTATOR));
        }
        float var9 = MathHelper.sin(this.getYRot() * ((float)Math.PI / 180) - this.yRotA * 0.01f);
        float var10 = MathHelper.cos(this.getYRot() * ((float)Math.PI / 180) - this.yRotA * 0.01f);
        float var11 = this.getHeadYOffset();
        this.tickPart(this.head, var9 * 6.5f * var4, var11 + var5 * 6.5f, -var10 * 6.5f * var4);
        this.tickPart(this.neck, var9 * 5.5f * var4, var11 + var5 * 5.5f, -var10 * 5.5f * var4);
        double[] var12 = this.getLatencyPos(5, 1.0f);
        for (var13 = 0; var13 < 3; ++var13) {
            EntityComplexPart var142 = null;
            if (var13 == 0) {
                var142 = this.tail1;
            }
            if (var13 == 1) {
                var142 = this.tail2;
            }
            if (var13 == 2) {
                var142 = this.tail3;
            }
            var15 = this.getLatencyPos(12 + var13 * 2, 1.0f);
            float var16 = this.getYRot() * ((float)Math.PI / 180) + this.rotWrap((double)(var15[0] - var12[0])) * ((float)Math.PI / 180);
            var17 = MathHelper.sin(var16);
            var18 = MathHelper.cos(var16);
            var19 = 1.5f;
            float var20 = (float)(var13 + 1) * 2.0f;
            this.tickPart(var142, -(var7 * 1.5f + var17 * var20) * var4, (double)(var15[1] - var12[1] - (double)((var20 + 1.5f) * var5) + 1.5), (var8 * 1.5f + var18 * var20) * var4);
        }
        if (!this.level().isClientSide) {
            this.inWall = this.checkWalls(this.head.getBoundingBox()) | this.checkWalls(this.neck.getBoundingBox()) | this.checkWalls(this.body.getBoundingBox());
            if (this.dragonFight != null) {
                this.dragonFight.updateDragon(this);
            }
        }
        for (var13 = 0; var13 < this.subEntities.length; ++var13) {
            this.subEntities[var13].xo = var2[var13].x;
            this.subEntities[var13].yo = var2[var13].y;
            this.subEntities[var13].zo = var2[var13].z;
            this.subEntities[var13].xOld = var2[var13].x;
            this.subEntities[var13].yOld = var2[var13].y;
            this.subEntities[var13].zOld = var2[var13].z;
        }
    }

    private void tickPart(EntityComplexPart var0, double var1, double var3, double var5) {
        var0.setPos(this.getX() + var1, this.getY() + var3, this.getZ() + var5);
    }

    private float getHeadYOffset() {
        if (this.phaseManager.getCurrentPhase().isSitting()) {
            return -1.0f;
        }
        double[] var0 = this.getLatencyPos(5, 1.0f);
        double[] var1 = this.getLatencyPos(0, 1.0f);
        return (float)(var0[1] - var1[1]);
    }

    private void checkCrystals() {
        if (this.nearestCrystal != null) {
            if (this.nearestCrystal.isRemoved()) {
                this.nearestCrystal = null;
            } else if (this.tickCount % 10 == 0 && this.getHealth() < this.getMaxHealth()) {
                this.setHealth(this.getHealth() + 1.0f);
            }
        }
        if (this.random.nextInt(10) == 0) {
            List<EntityEnderCrystal> var0 = this.level().getEntitiesOfClass(EntityEnderCrystal.class, this.getBoundingBox().inflate(32.0));
            EntityEnderCrystal var1 = null;
            double var2 = Double.MAX_VALUE;
            for (EntityEnderCrystal var5 : var0) {
                double var6 = var5.distanceToSqr(this);
                if (!(var6 < var2)) continue;
                var2 = var6;
                var1 = var5;
            }
            this.nearestCrystal = var1;
        }
    }

    private void knockBack(List<Entity> var0) {
        double var1 = (this.body.getBoundingBox().minX + this.body.getBoundingBox().maxX) / 2.0;
        double var3 = (this.body.getBoundingBox().minZ + this.body.getBoundingBox().maxZ) / 2.0;
        for (Entity var6 : var0) {
            if (!(var6 instanceof EntityLiving)) continue;
            double var7 = var6.getX() - var1;
            double var9 = var6.getZ() - var3;
            double var11 = Math.max(var7 * var7 + var9 * var9, 0.1);
            var6.push(var7 / var11 * 4.0, 0.2f, var9 / var11 * 4.0);
            if (this.phaseManager.getCurrentPhase().isSitting() || ((EntityLiving)var6).getLastHurtByMobTimestamp() >= var6.tickCount - 2) continue;
            var6.hurt(this.damageSources().mobAttack(this), 5.0f);
            this.doEnchantDamageEffects(this, var6);
        }
    }

    private void hurt(List<Entity> var0) {
        for (Entity var2 : var0) {
            if (!(var2 instanceof EntityLiving)) continue;
            var2.hurt(this.damageSources().mobAttack(this), 10.0f);
            this.doEnchantDamageEffects(this, var2);
        }
    }

    private float rotWrap(double var0) {
        return (float)MathHelper.wrapDegrees(var0);
    }

    private boolean checkWalls(AxisAlignedBB var0) {
        int var1 = MathHelper.floor(var0.minX);
        int var2 = MathHelper.floor(var0.minY);
        int var3 = MathHelper.floor(var0.minZ);
        int var4 = MathHelper.floor(var0.maxX);
        int var5 = MathHelper.floor(var0.maxY);
        int var6 = MathHelper.floor(var0.maxZ);
        boolean var7 = false;
        boolean var8 = false;
        for (int var9 = var1; var9 <= var4; ++var9) {
            for (int var10 = var2; var10 <= var5; ++var10) {
                for (int var11 = var3; var11 <= var6; ++var11) {
                    BlockPosition var12 = new BlockPosition(var9, var10, var11);
                    IBlockData var13 = this.level().getBlockState(var12);
                    if (var13.isAir() || var13.is(TagsBlock.DRAGON_TRANSPARENT)) continue;
                    if (!this.level().getGameRules().getBoolean(GameRules.RULE_MOBGRIEFING) || var13.is(TagsBlock.DRAGON_IMMUNE)) {
                        var7 = true;
                        continue;
                    }
                    var8 = this.level().removeBlock(var12, false) || var8;
                }
            }
        }
        if (var8) {
            BlockPosition var9 = new BlockPosition(var1 + this.random.nextInt(var4 - var1 + 1), var2 + this.random.nextInt(var5 - var2 + 1), var3 + this.random.nextInt(var6 - var3 + 1));
            this.level().levelEvent(2008, var9, 0);
        }
        return var7;
    }

    public boolean hurt(EntityComplexPart var0, DamageSource var1, float var2) {
        if (this.phaseManager.getCurrentPhase().getPhase() == DragonControllerPhase.DYING) {
            return false;
        }
        var2 = this.phaseManager.getCurrentPhase().onHurt(var1, var2);
        if (var0 != this.head) {
            var2 = var2 / 4.0f + Math.min(var2, 1.0f);
        }
        if (var2 < 0.01f) {
            return false;
        }
        if (var1.getEntity() instanceof EntityHuman || var1.is(DamageTypeTags.ALWAYS_HURTS_ENDER_DRAGONS)) {
            float var3 = this.getHealth();
            this.reallyHurt(var1, var2);
            if (this.isDeadOrDying() && !this.phaseManager.getCurrentPhase().isSitting()) {
                this.setHealth(1.0f);
                this.phaseManager.setPhase(DragonControllerPhase.DYING);
            }
            if (this.phaseManager.getCurrentPhase().isSitting()) {
                this.sittingDamageReceived = this.sittingDamageReceived + var3 - this.getHealth();
                if (this.sittingDamageReceived > 0.25f * this.getMaxHealth()) {
                    this.sittingDamageReceived = 0.0f;
                    this.phaseManager.setPhase(DragonControllerPhase.TAKEOFF);
                }
            }
        }
        return true;
    }

    @Override
    public boolean hurt(DamageSource var0, float var1) {
        if (!this.level().isClientSide) {
            return this.hurt(this.body, var0, var1);
        }
        return false;
    }

    protected boolean reallyHurt(DamageSource var0, float var1) {
        return super.hurt(var0, var1);
    }

    @Override
    public void kill() {
        this.remove(Entity.RemovalReason.KILLED);
        this.gameEvent(GameEvent.ENTITY_DIE);
        if (this.dragonFight != null) {
            this.dragonFight.updateDragon(this);
            this.dragonFight.setDragonKilled(this);
        }
    }

    @Override
    protected void tickDeath() {
        if (this.dragonFight != null) {
            this.dragonFight.updateDragon(this);
        }
        ++this.dragonDeathTime;
        if (this.dragonDeathTime >= 180 && this.dragonDeathTime <= 200) {
            float var0 = (this.random.nextFloat() - 0.5f) * 8.0f;
            float var1 = (this.random.nextFloat() - 0.5f) * 4.0f;
            float var2 = (this.random.nextFloat() - 0.5f) * 8.0f;
            this.level().addParticle(Particles.EXPLOSION_EMITTER, this.getX() + (double)var0, this.getY() + 2.0 + (double)var1, this.getZ() + (double)var2, 0.0, 0.0, 0.0);
        }
        boolean var0 = this.level().getGameRules().getBoolean(GameRules.RULE_DOMOBLOOT);
        int var1 = 500;
        if (this.dragonFight != null && !this.dragonFight.hasPreviouslyKilledDragon()) {
            var1 = 12000;
        }
        if (this.level() instanceof WorldServer) {
            if (this.dragonDeathTime > 150 && this.dragonDeathTime % 5 == 0 && var0) {
                EntityExperienceOrb.award((WorldServer)this.level(), this.position(), MathHelper.floor((float)var1 * 0.08f));
            }
            if (this.dragonDeathTime == 1 && !this.isSilent()) {
                this.level().globalLevelEvent(1028, this.blockPosition(), 0);
            }
        }
        this.move(EnumMoveType.SELF, new Vec3D(0.0, 0.1f, 0.0));
        if (this.dragonDeathTime == 200 && this.level() instanceof WorldServer) {
            if (var0) {
                EntityExperienceOrb.award((WorldServer)this.level(), this.position(), MathHelper.floor((float)var1 * 0.2f));
            }
            if (this.dragonFight != null) {
                this.dragonFight.setDragonKilled(this);
            }
            this.remove(Entity.RemovalReason.KILLED);
            this.gameEvent(GameEvent.ENTITY_DIE);
        }
    }

    public int findClosestNode() {
        if (this.nodes[0] == null) {
            for (int var0 = 0; var0 < 24; ++var0) {
                int var4;
                int var3;
                int var1 = 5;
                int var2 = var0;
                if (var0 < 12) {
                    var3 = MathHelper.floor(60.0f * MathHelper.cos(2.0f * ((float)(-Math.PI) + 0.2617994f * (float)var2)));
                    var4 = MathHelper.floor(60.0f * MathHelper.sin(2.0f * ((float)(-Math.PI) + 0.2617994f * (float)var2)));
                } else if (var0 < 20) {
                    var3 = MathHelper.floor(40.0f * MathHelper.cos(2.0f * ((float)(-Math.PI) + 0.3926991f * (float)(var2 -= 12))));
                    var4 = MathHelper.floor(40.0f * MathHelper.sin(2.0f * ((float)(-Math.PI) + 0.3926991f * (float)var2)));
                    var1 += 10;
                } else {
                    var3 = MathHelper.floor(20.0f * MathHelper.cos(2.0f * ((float)(-Math.PI) + 0.7853982f * (float)(var2 -= 20))));
                    var4 = MathHelper.floor(20.0f * MathHelper.sin(2.0f * ((float)(-Math.PI) + 0.7853982f * (float)var2)));
                }
                int var5 = Math.max(this.level().getSeaLevel() + 10, this.level().getHeightmapPos(HeightMap.Type.MOTION_BLOCKING_NO_LEAVES, new BlockPosition(var3, 0, var4)).getY() + var1);
                this.nodes[var0] = new PathPoint(var3, var5, var4);
            }
            this.nodeAdjacency[0] = 6146;
            this.nodeAdjacency[1] = 8197;
            this.nodeAdjacency[2] = 8202;
            this.nodeAdjacency[3] = 16404;
            this.nodeAdjacency[4] = 32808;
            this.nodeAdjacency[5] = 32848;
            this.nodeAdjacency[6] = 65696;
            this.nodeAdjacency[7] = 131392;
            this.nodeAdjacency[8] = 131712;
            this.nodeAdjacency[9] = 263424;
            this.nodeAdjacency[10] = 526848;
            this.nodeAdjacency[11] = 525313;
            this.nodeAdjacency[12] = 1581057;
            this.nodeAdjacency[13] = 3166214;
            this.nodeAdjacency[14] = 2138120;
            this.nodeAdjacency[15] = 6373424;
            this.nodeAdjacency[16] = 4358208;
            this.nodeAdjacency[17] = 12910976;
            this.nodeAdjacency[18] = 9044480;
            this.nodeAdjacency[19] = 9706496;
            this.nodeAdjacency[20] = 15216640;
            this.nodeAdjacency[21] = 0xD0E000;
            this.nodeAdjacency[22] = 11763712;
            this.nodeAdjacency[23] = 0x7E0000;
        }
        return this.findClosestNode(this.getX(), this.getY(), this.getZ());
    }

    public int findClosestNode(double var0, double var2, double var4) {
        float var6 = 10000.0f;
        int var7 = 0;
        PathPoint var8 = new PathPoint(MathHelper.floor(var0), MathHelper.floor(var2), MathHelper.floor(var4));
        int var9 = 0;
        if (this.dragonFight == null || this.dragonFight.getCrystalsAlive() == 0) {
            var9 = 12;
        }
        for (int var10 = var9; var10 < 24; ++var10) {
            float var11;
            if (this.nodes[var10] == null || !((var11 = this.nodes[var10].distanceToSqr(var8)) < var6)) continue;
            var6 = var11;
            var7 = var10;
        }
        return var7;
    }

    @Nullable
    public PathEntity findPath(int var0, int var1, @Nullable PathPoint var2) {
        PathPoint var4;
        for (int var3 = 0; var3 < 24; ++var3) {
            var4 = this.nodes[var3];
            var4.closed = false;
            var4.f = 0.0f;
            var4.g = 0.0f;
            var4.h = 0.0f;
            var4.cameFrom = null;
            var4.heapIdx = -1;
        }
        PathPoint var3 = this.nodes[var0];
        var4 = this.nodes[var1];
        var3.g = 0.0f;
        var3.f = var3.h = var3.distanceTo(var4);
        this.openSet.clear();
        this.openSet.insert(var3);
        PathPoint var5 = var3;
        int var6 = 0;
        if (this.dragonFight == null || this.dragonFight.getCrystalsAlive() == 0) {
            var6 = 12;
        }
        while (!this.openSet.isEmpty()) {
            int var9;
            PathPoint var7 = this.openSet.pop();
            if (var7.equals(var4)) {
                if (var2 != null) {
                    var2.cameFrom = var4;
                    var4 = var2;
                }
                return this.reconstructPath(var3, var4);
            }
            if (var7.distanceTo(var4) < var5.distanceTo(var4)) {
                var5 = var7;
            }
            var7.closed = true;
            int var8 = 0;
            for (var9 = 0; var9 < 24; ++var9) {
                if (this.nodes[var9] != var7) continue;
                var8 = var9;
                break;
            }
            for (var9 = var6; var9 < 24; ++var9) {
                if ((this.nodeAdjacency[var8] & 1 << var9) <= 0) continue;
                PathPoint var10 = this.nodes[var9];
                if (var10.closed) continue;
                float var11 = var7.g + var7.distanceTo(var10);
                if (var10.inOpenSet() && !(var11 < var10.g)) continue;
                var10.cameFrom = var7;
                var10.g = var11;
                var10.h = var10.distanceTo(var4);
                if (var10.inOpenSet()) {
                    this.openSet.changeCost(var10, var10.g + var10.h);
                    continue;
                }
                var10.f = var10.g + var10.h;
                this.openSet.insert(var10);
            }
        }
        if (var5 == var3) {
            return null;
        }
        LOGGER.debug("Failed to find path from {} to {}", (Object)var0, (Object)var1);
        if (var2 != null) {
            var2.cameFrom = var5;
            var5 = var2;
        }
        return this.reconstructPath(var3, var5);
    }

    private PathEntity reconstructPath(PathPoint var0, PathPoint var1) {
        ArrayList var2 = Lists.newArrayList();
        PathPoint var3 = var1;
        var2.add(0, var3);
        while (var3.cameFrom != null) {
            var3 = var3.cameFrom;
            var2.add(0, var3);
        }
        return new PathEntity(var2, new BlockPosition(var1.x, var1.y, var1.z), true);
    }

    @Override
    public void addAdditionalSaveData(NBTTagCompound var0) {
        super.addAdditionalSaveData(var0);
        var0.putInt(DRAGON_PHASE_KEY, this.phaseManager.getCurrentPhase().getPhase().getId());
        var0.putInt(DRAGON_DEATH_TIME_KEY, this.dragonDeathTime);
    }

    @Override
    public void readAdditionalSaveData(NBTTagCompound var0) {
        super.readAdditionalSaveData(var0);
        if (var0.contains(DRAGON_PHASE_KEY)) {
            this.phaseManager.setPhase(DragonControllerPhase.getById(var0.getInt(DRAGON_PHASE_KEY)));
        }
        if (var0.contains(DRAGON_DEATH_TIME_KEY)) {
            this.dragonDeathTime = var0.getInt(DRAGON_DEATH_TIME_KEY);
        }
    }

    @Override
    public void checkDespawn() {
    }

    public EntityComplexPart[] getSubEntities() {
        return this.subEntities;
    }

    @Override
    public boolean isPickable() {
        return false;
    }

    @Override
    public SoundCategory getSoundSource() {
        return SoundCategory.HOSTILE;
    }

    @Override
    protected SoundEffect getAmbientSound() {
        return SoundEffects.ENDER_DRAGON_AMBIENT;
    }

    @Override
    protected SoundEffect getHurtSound(DamageSource var0) {
        return SoundEffects.ENDER_DRAGON_HURT;
    }

    @Override
    protected float getSoundVolume() {
        return 5.0f;
    }

    public float getHeadPartYOffset(int var0, double[] var1, double[] var2) {
        double var5;
        IDragonController var3 = this.phaseManager.getCurrentPhase();
        DragonControllerPhase<? extends IDragonController> var4 = var3.getPhase();
        if (var4 == DragonControllerPhase.LANDING || var4 == DragonControllerPhase.TAKEOFF) {
            BlockPosition var7 = this.level().getHeightmapPos(HeightMap.Type.MOTION_BLOCKING_NO_LEAVES, WorldGenEndTrophy.getLocation(this.fightOrigin));
            double var8 = Math.max(Math.sqrt(var7.distToCenterSqr(this.position())) / 4.0, 1.0);
            var5 = (double)var0 / var8;
        } else {
            var5 = var3.isSitting() ? (double)var0 : (var0 == 6 ? 0.0 : var2[1] - var1[1]);
        }
        return (float)var5;
    }

    public Vec3D getHeadLookVector(float var0) {
        Vec3D var3;
        IDragonController var1 = this.phaseManager.getCurrentPhase();
        DragonControllerPhase<? extends IDragonController> var2 = var1.getPhase();
        if (var2 == DragonControllerPhase.LANDING || var2 == DragonControllerPhase.TAKEOFF) {
            BlockPosition var4 = this.level().getHeightmapPos(HeightMap.Type.MOTION_BLOCKING_NO_LEAVES, WorldGenEndTrophy.getLocation(this.fightOrigin));
            float var5 = Math.max((float)Math.sqrt(var4.distToCenterSqr(this.position())) / 4.0f, 1.0f);
            float var6 = 6.0f / var5;
            float var7 = this.getXRot();
            float var8 = 1.5f;
            this.setXRot(-var6 * 1.5f * 5.0f);
            var3 = this.getViewVector(var0);
            this.setXRot(var7);
        } else if (var1.isSitting()) {
            float var4 = this.getXRot();
            float var5 = 1.5f;
            this.setXRot(-45.0f);
            var3 = this.getViewVector(var0);
            this.setXRot(var4);
        } else {
            var3 = this.getViewVector(var0);
        }
        return var3;
    }

    public void onCrystalDestroyed(EntityEnderCrystal var0, BlockPosition var1, DamageSource var2) {
        EntityHuman var3 = var2.getEntity() instanceof EntityHuman ? (EntityHuman)var2.getEntity() : this.level().getNearestPlayer(CRYSTAL_DESTROY_TARGETING, var1.getX(), var1.getY(), var1.getZ());
        if (var0 == this.nearestCrystal) {
            this.hurt(this.head, this.damageSources().explosion(var0, var3), 10.0f);
        }
        this.phaseManager.getCurrentPhase().onCrystalDestroyed(var0, var1, var2, var3);
    }

    @Override
    public void onSyncedDataUpdated(DataWatcherObject<?> var0) {
        if (DATA_PHASE.equals(var0) && this.level().isClientSide) {
            this.phaseManager.setPhase(DragonControllerPhase.getById(this.getEntityData().get(DATA_PHASE)));
        }
        super.onSyncedDataUpdated(var0);
    }

    public DragonControllerManager getPhaseManager() {
        return this.phaseManager;
    }

    @Nullable
    public EnderDragonBattle getDragonFight() {
        return this.dragonFight;
    }

    @Override
    public boolean addEffect(MobEffect var0, @Nullable Entity var1) {
        return false;
    }

    @Override
    protected boolean canRide(Entity var0) {
        return false;
    }

    @Override
    public boolean canChangeDimensions() {
        return false;
    }

    @Override
    public void recreateFromPacket(PacketPlayOutSpawnEntity var0) {
        super.recreateFromPacket(var0);
        EntityComplexPart[] var1 = this.getSubEntities();
        for (int var2 = 0; var2 < var1.length; ++var2) {
            var1[var2].setId(var2 + var0.getId());
        }
    }

    @Override
    public boolean canAttack(EntityLiving var0) {
        return var0.canBeSeenAsEnemy();
    }

    @Override
    public double getPassengersRidingOffset() {
        return this.body.getBbHeight();
    }
}

