/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal.allay;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.GlobalPos;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.behavior.AnimalPanic;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.behavior.BehaviorFindAdmirableItem;
import net.minecraft.world.entity.ai.behavior.BehaviorGateSingle;
import net.minecraft.world.entity.ai.behavior.BehaviorLook;
import net.minecraft.world.entity.ai.behavior.BehaviorLookWalk;
import net.minecraft.world.entity.ai.behavior.BehaviorNop;
import net.minecraft.world.entity.ai.behavior.BehaviorPosition;
import net.minecraft.world.entity.ai.behavior.BehaviorPositionEntity;
import net.minecraft.world.entity.ai.behavior.BehaviorStrollRandomUnconstrained;
import net.minecraft.world.entity.ai.behavior.BehaviorSwim;
import net.minecraft.world.entity.ai.behavior.BehaviorTarget;
import net.minecraft.world.entity.ai.behavior.BehavorMove;
import net.minecraft.world.entity.ai.behavior.CountDownCooldownTicks;
import net.minecraft.world.entity.ai.behavior.GoAndGiveItemsToTarget;
import net.minecraft.world.entity.ai.behavior.SetEntityLookTargetSometimes;
import net.minecraft.world.entity.ai.behavior.StayCloseToTarget;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.animal.allay.Allay;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Blocks;

public class AllayAi {
    private static final float SPEED_MULTIPLIER_WHEN_IDLING = 1.0f;
    private static final float SPEED_MULTIPLIER_WHEN_FOLLOWING_DEPOSIT_TARGET = 2.25f;
    private static final float SPEED_MULTIPLIER_WHEN_RETRIEVING_ITEM = 1.75f;
    private static final float SPEED_MULTIPLIER_WHEN_PANICKING = 2.5f;
    private static final int CLOSE_ENOUGH_TO_TARGET = 4;
    private static final int TOO_FAR_FROM_TARGET = 16;
    private static final int MAX_LOOK_DISTANCE = 6;
    private static final int MIN_WAIT_DURATION = 30;
    private static final int MAX_WAIT_DURATION = 60;
    private static final int TIME_TO_FORGET_NOTEBLOCK = 600;
    private static final int DISTANCE_TO_WANTED_ITEM = 32;
    private static final int GIVE_ITEM_TIMEOUT_DURATION = 20;

    protected static BehaviorController<?> makeBrain(BehaviorController<Allay> var0) {
        AllayAi.initCoreActivity(var0);
        AllayAi.initIdleActivity(var0);
        var0.setCoreActivities((Set<Activity>)ImmutableSet.of((Object)Activity.CORE));
        var0.setDefaultActivity(Activity.IDLE);
        var0.useDefaultActivity();
        return var0;
    }

    private static void initCoreActivity(BehaviorController<Allay> var0) {
        var0.addActivity(Activity.CORE, 0, (ImmutableList<BehaviorControl<Allay>>)ImmutableList.of((Object)new BehaviorSwim(0.8f), (Object)new AnimalPanic(2.5f), (Object)new BehaviorLook(45, 90), (Object)new BehavorMove(), (Object)new CountDownCooldownTicks(MemoryModuleType.LIKED_NOTEBLOCK_COOLDOWN_TICKS), (Object)new CountDownCooldownTicks(MemoryModuleType.ITEM_PICKUP_COOLDOWN_TICKS)));
    }

    private static void initIdleActivity(BehaviorController<Allay> var02) {
        var02.addActivityWithConditions(Activity.IDLE, (ImmutableList<Pair<Integer, BehaviorControl<Allay>>>)ImmutableList.of((Object)Pair.of((Object)0, BehaviorFindAdmirableItem.create(var0 -> true, 1.75f, true, 32)), (Object)Pair.of((Object)1, new GoAndGiveItemsToTarget(AllayAi::getItemDepositPosition, 2.25f, 20)), (Object)Pair.of((Object)2, StayCloseToTarget.create(AllayAi::getItemDepositPosition, Predicate.not(AllayAi::hasWantedItem), 4, 16, 2.25f)), (Object)Pair.of((Object)3, SetEntityLookTargetSometimes.create(6.0f, UniformInt.of(30, 60))), (Object)Pair.of((Object)4, new BehaviorGateSingle(ImmutableList.of((Object)Pair.of(BehaviorStrollRandomUnconstrained.fly(1.0f), (Object)2), (Object)Pair.of(BehaviorLookWalk.create(1.0f, 3), (Object)2), (Object)Pair.of((Object)new BehaviorNop(30, 60), (Object)1))))), (Set<Pair<MemoryModuleType<?>, MemoryStatus>>)ImmutableSet.of());
    }

    public static void updateActivity(Allay var0) {
        var0.getBrain().setActiveActivityToFirstValid((List<Activity>)ImmutableList.of((Object)Activity.IDLE));
    }

    public static void hearNoteblock(EntityLiving var0, BlockPosition var1) {
        BehaviorController<?> var2 = var0.getBrain();
        GlobalPos var3 = GlobalPos.of(var0.level().dimension(), var1);
        Optional<GlobalPos> var4 = var2.getMemory(MemoryModuleType.LIKED_NOTEBLOCK_POSITION);
        if (var4.isEmpty()) {
            var2.setMemory(MemoryModuleType.LIKED_NOTEBLOCK_POSITION, var3);
            var2.setMemory(MemoryModuleType.LIKED_NOTEBLOCK_COOLDOWN_TICKS, 600);
        } else if (var4.get().equals(var3)) {
            var2.setMemory(MemoryModuleType.LIKED_NOTEBLOCK_COOLDOWN_TICKS, 600);
        }
    }

    private static Optional<BehaviorPosition> getItemDepositPosition(EntityLiving var0) {
        BehaviorController<?> var1 = var0.getBrain();
        Optional<GlobalPos> var2 = var1.getMemory(MemoryModuleType.LIKED_NOTEBLOCK_POSITION);
        if (var2.isPresent()) {
            GlobalPos var3 = var2.get();
            if (AllayAi.shouldDepositItemsAtLikedNoteblock(var0, var1, var3)) {
                return Optional.of(new BehaviorTarget(var3.pos().above()));
            }
            var1.eraseMemory(MemoryModuleType.LIKED_NOTEBLOCK_POSITION);
        }
        return AllayAi.getLikedPlayerPositionTracker(var0);
    }

    private static boolean hasWantedItem(EntityLiving var0) {
        BehaviorController<EntityItem> var1 = var0.getBrain();
        return var1.hasMemoryValue(MemoryModuleType.NEAREST_VISIBLE_WANTED_ITEM);
    }

    private static boolean shouldDepositItemsAtLikedNoteblock(EntityLiving var0, BehaviorController<?> var1, GlobalPos var2) {
        Optional<Integer> var3 = var1.getMemory(MemoryModuleType.LIKED_NOTEBLOCK_COOLDOWN_TICKS);
        World var4 = var0.level();
        return var4.dimension() == var2.dimension() && var4.getBlockState(var2.pos()).is(Blocks.NOTE_BLOCK) && var3.isPresent();
    }

    private static Optional<BehaviorPosition> getLikedPlayerPositionTracker(EntityLiving var02) {
        return AllayAi.getLikedPlayer(var02).map(var0 -> new BehaviorPositionEntity((Entity)var0, true));
    }

    public static Optional<EntityPlayer> getLikedPlayer(EntityLiving var0) {
        World var1 = var0.level();
        if (!var1.isClientSide() && var1 instanceof WorldServer) {
            WorldServer var2 = (WorldServer)var1;
            Optional<UUID> var3 = var0.getBrain().getMemory(MemoryModuleType.LIKED_PLAYER);
            if (var3.isPresent()) {
                Entity var4 = var2.getEntity(var3.get());
                if (var4 instanceof EntityPlayer) {
                    EntityPlayer var5 = (EntityPlayer)var4;
                    if ((var5.gameMode.isSurvival() || var5.gameMode.isCreative()) && var5.closerThan(var0, 64.0)) {
                        return Optional.of(var5);
                    }
                }
                return Optional.empty();
            }
        }
        return Optional.empty();
    }
}

