/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.goal;

import java.util.EnumSet;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.entity.animal.horse.EntityHorseAbstract;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.World;
import net.minecraft.world.phys.Vec3D;

public class PathfinderGoalTame
extends PathfinderGoal {
    private final EntityHorseAbstract horse;
    private final double speedModifier;
    private double posX;
    private double posY;
    private double posZ;

    public PathfinderGoalTame(EntityHorseAbstract var0, double var1) {
        this.horse = var0;
        this.speedModifier = var1;
        this.setFlags(EnumSet.of(PathfinderGoal.Type.MOVE));
    }

    @Override
    public boolean canUse() {
        if (this.horse.isTamed() || !this.horse.isVehicle()) {
            return false;
        }
        Vec3D var0 = DefaultRandomPos.getPos(this.horse, 5, 4);
        if (var0 == null) {
            return false;
        }
        this.posX = var0.x;
        this.posY = var0.y;
        this.posZ = var0.z;
        return true;
    }

    @Override
    public void start() {
        this.horse.getNavigation().moveTo(this.posX, this.posY, this.posZ, this.speedModifier);
    }

    @Override
    public boolean canContinueToUse() {
        return !this.horse.isTamed() && !this.horse.getNavigation().isDone() && this.horse.isVehicle();
    }

    @Override
    public void tick() {
        if (!this.horse.isTamed() && this.horse.getRandom().nextInt(this.adjustedTickDelay(50)) == 0) {
            Entity var0 = this.horse.getPassengers().get(0);
            if (var0 == null) {
                return;
            }
            if (var0 instanceof EntityHuman) {
                int var1 = this.horse.getTemper();
                int var2 = this.horse.getMaxTemper();
                if (var2 > 0 && this.horse.getRandom().nextInt(var2) < var1) {
                    this.horse.tameWithName((EntityHuman)var0);
                    return;
                }
                this.horse.modifyTemper(5);
            }
            this.horse.ejectPassengers();
            this.horse.makeMad();
            ((World)this.horse.level()).broadcastEntityEvent(this.horse, (byte)6);
        }
    }
}

