/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorUtil;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.npc.EntityVillager;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.LootTables;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameterSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;

public class BehaviorVillageHeroGift
extends Behavior<EntityVillager> {
    private static final int THROW_GIFT_AT_DISTANCE = 5;
    private static final int MIN_TIME_BETWEEN_GIFTS = 600;
    private static final int MAX_TIME_BETWEEN_GIFTS = 6600;
    private static final int TIME_TO_DELAY_FOR_HEAD_TO_FINISH_TURNING = 20;
    private static final Map<VillagerProfession, MinecraftKey> GIFTS = SystemUtils.make(Maps.newHashMap(), var0 -> {
        var0.put(VillagerProfession.ARMORER, LootTables.ARMORER_GIFT);
        var0.put(VillagerProfession.BUTCHER, LootTables.BUTCHER_GIFT);
        var0.put(VillagerProfession.CARTOGRAPHER, LootTables.CARTOGRAPHER_GIFT);
        var0.put(VillagerProfession.CLERIC, LootTables.CLERIC_GIFT);
        var0.put(VillagerProfession.FARMER, LootTables.FARMER_GIFT);
        var0.put(VillagerProfession.FISHERMAN, LootTables.FISHERMAN_GIFT);
        var0.put(VillagerProfession.FLETCHER, LootTables.FLETCHER_GIFT);
        var0.put(VillagerProfession.LEATHERWORKER, LootTables.LEATHERWORKER_GIFT);
        var0.put(VillagerProfession.LIBRARIAN, LootTables.LIBRARIAN_GIFT);
        var0.put(VillagerProfession.MASON, LootTables.MASON_GIFT);
        var0.put(VillagerProfession.SHEPHERD, LootTables.SHEPHERD_GIFT);
        var0.put(VillagerProfession.TOOLSMITH, LootTables.TOOLSMITH_GIFT);
        var0.put(VillagerProfession.WEAPONSMITH, LootTables.WEAPONSMITH_GIFT);
    });
    private static final float SPEED_MODIFIER = 0.5f;
    private int timeUntilNextGift = 600;
    private boolean giftGivenDuringThisRun;
    private long timeSinceStart;

    public BehaviorVillageHeroGift(int var0) {
        super((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of(MemoryModuleType.WALK_TARGET, (Object)((Object)MemoryStatus.REGISTERED), MemoryModuleType.LOOK_TARGET, (Object)((Object)MemoryStatus.REGISTERED), MemoryModuleType.INTERACTION_TARGET, (Object)((Object)MemoryStatus.REGISTERED), MemoryModuleType.NEAREST_VISIBLE_PLAYER, (Object)((Object)MemoryStatus.VALUE_PRESENT)), var0);
    }

    @Override
    protected boolean checkExtraStartConditions(WorldServer var0, EntityVillager var1) {
        if (!this.isHeroVisible(var1)) {
            return false;
        }
        if (this.timeUntilNextGift > 0) {
            --this.timeUntilNextGift;
            return false;
        }
        return true;
    }

    @Override
    protected void start(WorldServer var0, EntityVillager var1, long var2) {
        this.giftGivenDuringThisRun = false;
        this.timeSinceStart = var2;
        EntityHuman var4 = this.getNearestTargetableHero(var1).get();
        var1.getBrain().setMemory(MemoryModuleType.INTERACTION_TARGET, var4);
        BehaviorUtil.lookAtEntity(var1, var4);
    }

    @Override
    protected boolean canStillUse(WorldServer var0, EntityVillager var1, long var2) {
        return this.isHeroVisible(var1) && !this.giftGivenDuringThisRun;
    }

    @Override
    protected void tick(WorldServer var0, EntityVillager var1, long var2) {
        EntityHuman var4 = this.getNearestTargetableHero(var1).get();
        BehaviorUtil.lookAtEntity(var1, var4);
        if (this.isWithinThrowingDistance(var1, var4)) {
            if (var2 - this.timeSinceStart > 20L) {
                this.throwGift(var1, var4);
                this.giftGivenDuringThisRun = true;
            }
        } else {
            BehaviorUtil.setWalkAndLookTargetMemories((EntityLiving)var1, var4, 0.5f, 5);
        }
    }

    @Override
    protected void stop(WorldServer var0, EntityVillager var1, long var2) {
        this.timeUntilNextGift = BehaviorVillageHeroGift.calculateTimeUntilNextGift(var0);
        var1.getBrain().eraseMemory(MemoryModuleType.INTERACTION_TARGET);
        var1.getBrain().eraseMemory(MemoryModuleType.WALK_TARGET);
        var1.getBrain().eraseMemory(MemoryModuleType.LOOK_TARGET);
    }

    private void throwGift(EntityVillager var0, EntityLiving var1) {
        List<ItemStack> var2 = this.getItemToThrow(var0);
        for (ItemStack var4 : var2) {
            BehaviorUtil.throwItem(var0, var4, var1.position());
        }
    }

    private List<ItemStack> getItemToThrow(EntityVillager var0) {
        if (var0.isBaby()) {
            return ImmutableList.of((Object)new ItemStack(Items.POPPY));
        }
        VillagerProfession var1 = var0.getVillagerData().getProfession();
        if (GIFTS.containsKey(var1)) {
            LootTable var2 = var0.level().getServer().getLootData().getLootTable(GIFTS.get(var1));
            LootParams var3 = new LootParams.a((WorldServer)var0.level()).withParameter(LootContextParameters.ORIGIN, var0.position()).withParameter(LootContextParameters.THIS_ENTITY, var0).create(LootContextParameterSets.GIFT);
            return var2.getRandomItems(var3);
        }
        return ImmutableList.of((Object)new ItemStack(Items.WHEAT_SEEDS));
    }

    private boolean isHeroVisible(EntityVillager var0) {
        return this.getNearestTargetableHero(var0).isPresent();
    }

    private Optional<EntityHuman> getNearestTargetableHero(EntityVillager var0) {
        return var0.getBrain().getMemory(MemoryModuleType.NEAREST_VISIBLE_PLAYER).filter(this::isHero);
    }

    private boolean isHero(EntityHuman var0) {
        return var0.hasEffect(MobEffects.HERO_OF_THE_VILLAGE);
    }

    private boolean isWithinThrowingDistance(EntityVillager var0, EntityHuman var1) {
        BlockPosition var2 = var1.blockPosition();
        BlockPosition var3 = var0.blockPosition();
        return var3.closerThan(var2, 5.0);
    }

    private static int calculateTimeUntilNextGift(WorldServer var0) {
        return 600 + var0.random.nextInt(6001);
    }

    @Override
    protected /* synthetic */ boolean canStillUse(WorldServer worldServer, EntityLiving entityLiving, long l2) {
        return this.canStillUse(worldServer, (EntityVillager)entityLiving, l2);
    }

    @Override
    protected /* synthetic */ void stop(WorldServer worldServer, EntityLiving entityLiving, long l2) {
        this.stop(worldServer, (EntityVillager)entityLiving, l2);
    }

    @Override
    protected /* synthetic */ void start(WorldServer worldServer, EntityLiving entityLiving, long l2) {
        this.start(worldServer, (EntityVillager)entityLiving, l2);
    }
}

