/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagsFluid;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;

public class BehaviorSwim
extends Behavior<EntityInsentient> {
    private final float chance;

    public BehaviorSwim(float var0) {
        super((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of());
        this.chance = var0;
    }

    @Override
    protected boolean checkExtraStartConditions(WorldServer var0, EntityInsentient var1) {
        return var1.isInWater() && var1.getFluidHeight(TagsFluid.WATER) > var1.getFluidJumpThreshold() || var1.isInLava();
    }

    @Override
    protected boolean canStillUse(WorldServer var0, EntityInsentient var1, long var2) {
        return this.checkExtraStartConditions(var0, var1);
    }

    @Override
    protected void tick(WorldServer var0, EntityInsentient var1, long var2) {
        if (var1.getRandom().nextFloat() < this.chance) {
            var1.getJumpControl().jump();
        }
    }

    @Override
    protected /* synthetic */ void tick(WorldServer worldServer, EntityLiving entityLiving, long l2) {
        this.tick(worldServer, (EntityInsentient)entityLiving, l2);
    }
}

