/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorUtil;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.animal.EntityAnimal;

public class BehaviorMakeLoveAnimal
extends Behavior<EntityAnimal> {
    private static final int BREED_RANGE = 3;
    private static final int MIN_DURATION = 60;
    private static final int MAX_DURATION = 110;
    private final EntityTypes<? extends EntityAnimal> partnerType;
    private final float speedModifier;
    private long spawnChildAtTime;

    public BehaviorMakeLoveAnimal(EntityTypes<? extends EntityAnimal> var0, float var1) {
        super((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of(MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES, (Object)((Object)MemoryStatus.VALUE_PRESENT), MemoryModuleType.BREED_TARGET, (Object)((Object)MemoryStatus.VALUE_ABSENT), MemoryModuleType.WALK_TARGET, (Object)((Object)MemoryStatus.REGISTERED), MemoryModuleType.LOOK_TARGET, (Object)((Object)MemoryStatus.REGISTERED)), 110);
        this.partnerType = var0;
        this.speedModifier = var1;
    }

    @Override
    protected boolean checkExtraStartConditions(WorldServer var0, EntityAnimal var1) {
        return var1.isInLove() && this.findValidBreedPartner(var1).isPresent();
    }

    @Override
    protected void start(WorldServer var0, EntityAnimal var1, long var2) {
        EntityAnimal var4 = this.findValidBreedPartner(var1).get();
        var1.getBrain().setMemory(MemoryModuleType.BREED_TARGET, var4);
        var4.getBrain().setMemory(MemoryModuleType.BREED_TARGET, var1);
        BehaviorUtil.lockGazeAndWalkToEachOther(var1, var4, this.speedModifier);
        int var5 = 60 + var1.getRandom().nextInt(50);
        this.spawnChildAtTime = var2 + (long)var5;
    }

    @Override
    protected boolean canStillUse(WorldServer var0, EntityAnimal var1, long var2) {
        if (!this.hasBreedTargetOfRightType(var1)) {
            return false;
        }
        EntityAnimal var4 = this.getBreedTarget(var1);
        return var4.isAlive() && var1.canMate(var4) && BehaviorUtil.entityIsVisible(var1.getBrain(), var4) && var2 <= this.spawnChildAtTime;
    }

    @Override
    protected void tick(WorldServer var0, EntityAnimal var1, long var2) {
        EntityAnimal var4 = this.getBreedTarget(var1);
        BehaviorUtil.lockGazeAndWalkToEachOther(var1, var4, this.speedModifier);
        if (!var1.closerThan(var4, 3.0)) {
            return;
        }
        if (var2 >= this.spawnChildAtTime) {
            var1.spawnChildFromBreeding(var0, var4);
            var1.getBrain().eraseMemory(MemoryModuleType.BREED_TARGET);
            var4.getBrain().eraseMemory(MemoryModuleType.BREED_TARGET);
        }
    }

    @Override
    protected void stop(WorldServer var0, EntityAnimal var1, long var2) {
        var1.getBrain().eraseMemory(MemoryModuleType.BREED_TARGET);
        var1.getBrain().eraseMemory(MemoryModuleType.WALK_TARGET);
        var1.getBrain().eraseMemory(MemoryModuleType.LOOK_TARGET);
        this.spawnChildAtTime = 0L;
    }

    private EntityAnimal getBreedTarget(EntityAnimal var0) {
        return (EntityAnimal)var0.getBrain().getMemory(MemoryModuleType.BREED_TARGET).get();
    }

    private boolean hasBreedTargetOfRightType(EntityAnimal var0) {
        BehaviorController<EntityAgeable> var1 = var0.getBrain();
        return var1.hasMemoryValue(MemoryModuleType.BREED_TARGET) && var1.getMemory(MemoryModuleType.BREED_TARGET).get().getType() == this.partnerType;
    }

    private Optional<? extends EntityAnimal> findValidBreedPartner(EntityAnimal var0) {
        return var0.getBrain().getMemory(MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES).get().findClosest(var1 -> {
            EntityAnimal var2;
            return var1.getType() == this.partnerType && var1 instanceof EntityAnimal && var0.canMate(var2 = (EntityAnimal)var1);
        }).map(EntityAnimal.class::cast);
    }

    @Override
    protected /* synthetic */ boolean canStillUse(WorldServer worldServer, EntityLiving entityLiving, long l2) {
        return this.canStillUse(worldServer, (EntityAnimal)entityLiving, l2);
    }

    @Override
    protected /* synthetic */ void stop(WorldServer worldServer, EntityLiving entityLiving, long l2) {
        this.stop(worldServer, (EntityAnimal)entityLiving, l2);
    }

    @Override
    protected /* synthetic */ void start(WorldServer worldServer, EntityLiving entityLiving, long l2) {
        this.start(worldServer, (EntityAnimal)entityLiving, l2);
    }
}

