/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs.resources;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.packs.IResourcePack;
import net.minecraft.server.packs.resources.IResource;
import net.minecraft.server.packs.resources.ResourceProvider;

public interface IResourceManager
extends ResourceProvider {
    public Set<String> getNamespaces();

    public List<IResource> getResourceStack(MinecraftKey var1);

    public Map<MinecraftKey, IResource> listResources(String var1, Predicate<MinecraftKey> var2);

    public Map<MinecraftKey, List<IResource>> listResourceStacks(String var1, Predicate<MinecraftKey> var2);

    public Stream<IResourcePack> listPacks();

    public static final class Empty
    extends Enum<Empty>
    implements IResourceManager {
        public static final /* enum */ Empty INSTANCE = new Empty();
        private static final /* synthetic */ Empty[] b;

        public static Empty[] values() {
            return (Empty[])b.clone();
        }

        public static Empty valueOf(String var0) {
            return Enum.valueOf(Empty.class, var0);
        }

        @Override
        public Set<String> getNamespaces() {
            return Set.of();
        }

        @Override
        public Optional<IResource> getResource(MinecraftKey var0) {
            return Optional.empty();
        }

        @Override
        public List<IResource> getResourceStack(MinecraftKey var0) {
            return List.of();
        }

        @Override
        public Map<MinecraftKey, IResource> listResources(String var0, Predicate<MinecraftKey> var1) {
            return Map.of();
        }

        @Override
        public Map<MinecraftKey, List<IResource>> listResourceStacks(String var0, Predicate<MinecraftKey> var1) {
            return Map.of();
        }

        @Override
        public Stream<IResourcePack> listPacks() {
            return Stream.of(new IResourcePack[0]);
        }

        private static /* synthetic */ Empty[] c() {
            return new Empty[]{INSTANCE};
        }

        static {
            b = Empty.c();
        }
    }
}

