/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.shorts.ShortOpenHashSet;
import it.unimi.dsi.fastutil.shorts.ShortSet;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.function.IntConsumer;
import java.util.function.IntSupplier;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.SectionPosition;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.network.protocol.game.PacketPlayOutBlockChange;
import net.minecraft.network.protocol.game.PacketPlayOutLightUpdate;
import net.minecraft.network.protocol.game.PacketPlayOutMultiBlockChange;
import net.minecraft.server.level.ChunkLevel;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.FullChunkStatus;
import net.minecraft.server.level.PlayerChunkMap;
import net.minecraft.util.DebugBuffer;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.EnumSkyBlock;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.Chunk;
import net.minecraft.world.level.chunk.ChunkSection;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.chunk.ProtoChunk;
import net.minecraft.world.level.chunk.ProtoChunkExtension;
import net.minecraft.world.level.lighting.LevelLightEngine;

public class PlayerChunk {
    public static final Either<IChunkAccess, Failure> UNLOADED_CHUNK = Either.right((Object)Failure.UNLOADED);
    public static final CompletableFuture<Either<IChunkAccess, Failure>> UNLOADED_CHUNK_FUTURE = CompletableFuture.completedFuture(UNLOADED_CHUNK);
    public static final Either<Chunk, Failure> UNLOADED_LEVEL_CHUNK = Either.right((Object)Failure.UNLOADED);
    private static final Either<IChunkAccess, Failure> NOT_DONE_YET = Either.right((Object)Failure.UNLOADED);
    private static final CompletableFuture<Either<Chunk, Failure>> UNLOADED_LEVEL_CHUNK_FUTURE = CompletableFuture.completedFuture(UNLOADED_LEVEL_CHUNK);
    private static final List<ChunkStatus> CHUNK_STATUSES = ChunkStatus.getStatusList();
    private final AtomicReferenceArray<CompletableFuture<Either<IChunkAccess, Failure>>> futures = new AtomicReferenceArray(CHUNK_STATUSES.size());
    private final LevelHeightAccessor levelHeightAccessor;
    private volatile CompletableFuture<Either<Chunk, Failure>> fullChunkFuture = UNLOADED_LEVEL_CHUNK_FUTURE;
    private volatile CompletableFuture<Either<Chunk, Failure>> tickingChunkFuture = UNLOADED_LEVEL_CHUNK_FUTURE;
    private volatile CompletableFuture<Either<Chunk, Failure>> entityTickingChunkFuture = UNLOADED_LEVEL_CHUNK_FUTURE;
    private CompletableFuture<IChunkAccess> chunkToSave = CompletableFuture.completedFuture(null);
    @Nullable
    private final DebugBuffer<b> chunkToSaveHistory = null;
    public int oldTicketLevel;
    private int ticketLevel;
    private int queueLevel;
    final ChunkCoordIntPair pos;
    private boolean hasChangedSections;
    private final ShortSet[] changedBlocksPerSection;
    private final BitSet blockChangedLightSectionFilter = new BitSet();
    private final BitSet skyChangedLightSectionFilter = new BitSet();
    private final LevelLightEngine lightEngine;
    private final c onLevelChange;
    public final d playerProvider;
    private boolean wasAccessibleSinceLastSave;
    private CompletableFuture<Void> pendingFullStateConfirmation = CompletableFuture.completedFuture(null);

    public PlayerChunk(ChunkCoordIntPair var0, int var1, LevelHeightAccessor var2, LevelLightEngine var3, c var4, d var5) {
        this.pos = var0;
        this.levelHeightAccessor = var2;
        this.lightEngine = var3;
        this.onLevelChange = var4;
        this.playerProvider = var5;
        this.ticketLevel = this.oldTicketLevel = ChunkLevel.MAX_LEVEL + 1;
        this.queueLevel = this.oldTicketLevel;
        this.setTicketLevel(var1);
        this.changedBlocksPerSection = new ShortSet[var2.getSectionsCount()];
    }

    public CompletableFuture<Either<IChunkAccess, Failure>> getFutureIfPresentUnchecked(ChunkStatus var0) {
        CompletableFuture<Either<IChunkAccess, Failure>> var1 = this.futures.get(var0.getIndex());
        return var1 == null ? UNLOADED_CHUNK_FUTURE : var1;
    }

    public CompletableFuture<Either<IChunkAccess, Failure>> getFutureIfPresent(ChunkStatus var0) {
        if (ChunkLevel.generationStatus(this.ticketLevel).isOrAfter(var0)) {
            return this.getFutureIfPresentUnchecked(var0);
        }
        return UNLOADED_CHUNK_FUTURE;
    }

    public CompletableFuture<Either<Chunk, Failure>> getTickingChunkFuture() {
        return this.tickingChunkFuture;
    }

    public CompletableFuture<Either<Chunk, Failure>> getEntityTickingChunkFuture() {
        return this.entityTickingChunkFuture;
    }

    public CompletableFuture<Either<Chunk, Failure>> getFullChunkFuture() {
        return this.fullChunkFuture;
    }

    @Nullable
    public Chunk getTickingChunk() {
        CompletableFuture<Either<Chunk, Failure>> var0 = this.getTickingChunkFuture();
        Either var1 = var0.getNow(null);
        if (var1 == null) {
            return null;
        }
        return var1.left().orElse(null);
    }

    @Nullable
    public Chunk getFullChunk() {
        CompletableFuture<Either<Chunk, Failure>> var0 = this.getFullChunkFuture();
        Either var1 = var0.getNow(null);
        if (var1 == null) {
            return null;
        }
        return var1.left().orElse(null);
    }

    @Nullable
    public ChunkStatus getLastAvailableStatus() {
        for (int var0 = CHUNK_STATUSES.size() - 1; var0 >= 0; --var0) {
            ChunkStatus var1 = CHUNK_STATUSES.get(var0);
            CompletableFuture<Either<IChunkAccess, Failure>> var2 = this.getFutureIfPresentUnchecked(var1);
            if (!var2.getNow(UNLOADED_CHUNK).left().isPresent()) continue;
            return var1;
        }
        return null;
    }

    @Nullable
    public IChunkAccess getLastAvailable() {
        for (int var0 = CHUNK_STATUSES.size() - 1; var0 >= 0; --var0) {
            Optional var3;
            ChunkStatus var1 = CHUNK_STATUSES.get(var0);
            CompletableFuture<Either<IChunkAccess, Failure>> var2 = this.getFutureIfPresentUnchecked(var1);
            if (var2.isCompletedExceptionally() || !(var3 = var2.getNow(UNLOADED_CHUNK).left()).isPresent()) continue;
            return (IChunkAccess)var3.get();
        }
        return null;
    }

    public CompletableFuture<IChunkAccess> getChunkToSave() {
        return this.chunkToSave;
    }

    public void blockChanged(BlockPosition var0) {
        Chunk var1 = this.getTickingChunk();
        if (var1 == null) {
            return;
        }
        int var2 = this.levelHeightAccessor.getSectionIndex(var0.getY());
        if (this.changedBlocksPerSection[var2] == null) {
            this.hasChangedSections = true;
            this.changedBlocksPerSection[var2] = new ShortOpenHashSet();
        }
        this.changedBlocksPerSection[var2].add(SectionPosition.sectionRelativePos(var0));
    }

    public void sectionLightChanged(EnumSkyBlock var0, int var1) {
        Either var2 = this.getFutureIfPresent(ChunkStatus.INITIALIZE_LIGHT).getNow(null);
        if (var2 == null) {
            return;
        }
        IChunkAccess var3 = var2.left().orElse(null);
        if (var3 == null) {
            return;
        }
        var3.setUnsaved(true);
        Chunk var4 = this.getTickingChunk();
        if (var4 == null) {
            return;
        }
        int var5 = this.lightEngine.getMinLightSection();
        int var6 = this.lightEngine.getMaxLightSection();
        if (var1 < var5 || var1 > var6) {
            return;
        }
        int var7 = var1 - var5;
        if (var0 == EnumSkyBlock.SKY) {
            this.skyChangedLightSectionFilter.set(var7);
        } else {
            this.blockChangedLightSectionFilter.set(var7);
        }
    }

    public void broadcastChanges(Chunk var0) {
        List<EntityPlayer> var22;
        if (!this.hasChangedSections && this.skyChangedLightSectionFilter.isEmpty() && this.blockChangedLightSectionFilter.isEmpty()) {
            return;
        }
        World var1 = var0.getLevel();
        if (!this.skyChangedLightSectionFilter.isEmpty() || !this.blockChangedLightSectionFilter.isEmpty()) {
            var22 = this.playerProvider.getPlayers(this.pos, true);
            if (!var22.isEmpty()) {
                PacketPlayOutLightUpdate var32 = new PacketPlayOutLightUpdate(var0.getPos(), this.lightEngine, this.skyChangedLightSectionFilter, this.blockChangedLightSectionFilter);
                this.broadcast(var22, var32);
            }
            this.skyChangedLightSectionFilter.clear();
            this.blockChangedLightSectionFilter.clear();
        }
        if (!this.hasChangedSections) {
            return;
        }
        var22 = this.playerProvider.getPlayers(this.pos, false);
        for (int var33 = 0; var33 < this.changedBlocksPerSection.length; ++var33) {
            Object var8;
            Object var7;
            ShortSet var4 = this.changedBlocksPerSection[var33];
            if (var4 == null) continue;
            this.changedBlocksPerSection[var33] = null;
            if (var22.isEmpty()) continue;
            int var5 = this.levelHeightAccessor.getSectionYFromSectionIndex(var33);
            SectionPosition var6 = SectionPosition.of(var0.getPos(), var5);
            if (var4.size() == 1) {
                var7 = var6.relativeToBlockPos(var4.iterator().nextShort());
                var8 = var1.getBlockState((BlockPosition)var7);
                this.broadcast(var22, new PacketPlayOutBlockChange((BlockPosition)var7, (IBlockData)var8));
                this.broadcastBlockEntityIfNeeded(var22, var1, (BlockPosition)var7, (IBlockData)var8);
                continue;
            }
            var7 = var0.getSection(var33);
            var8 = new PacketPlayOutMultiBlockChange(var6, var4, (ChunkSection)var7);
            this.broadcast(var22, (Packet<?>)var8);
            ((PacketPlayOutMultiBlockChange)var8).runUpdates((var2, var3) -> this.broadcastBlockEntityIfNeeded(var22, var1, (BlockPosition)var2, (IBlockData)var3));
        }
        this.hasChangedSections = false;
    }

    private void broadcastBlockEntityIfNeeded(List<EntityPlayer> var0, World var1, BlockPosition var2, IBlockData var3) {
        if (var3.hasBlockEntity()) {
            this.broadcastBlockEntity(var0, var1, var2);
        }
    }

    private void broadcastBlockEntity(List<EntityPlayer> var0, World var1, BlockPosition var2) {
        Packet<PacketListenerPlayOut> var4;
        TileEntity var3 = var1.getBlockEntity(var2);
        if (var3 != null && (var4 = var3.getUpdatePacket()) != null) {
            this.broadcast(var0, var4);
        }
    }

    private void broadcast(List<EntityPlayer> var0, Packet<?> var12) {
        var0.forEach(var1 -> var1.connection.send(var12));
    }

    public CompletableFuture<Either<IChunkAccess, Failure>> getOrScheduleFuture(ChunkStatus var0, PlayerChunkMap var1) {
        Object var4;
        int var2 = var0.getIndex();
        CompletableFuture<Either<IChunkAccess, Failure>> var3 = this.futures.get(var2);
        if (var3 != null) {
            var4 = var3.getNow(NOT_DONE_YET);
            if (var4 == null) {
                String var5 = "value in future for status: " + var0 + " was incorrectly set to null at chunk: " + this.pos;
                throw var1.debugFuturesAndCreateReportedException(new IllegalStateException("null value previously set for chunk status"), var5);
            }
            if (var4 == NOT_DONE_YET || var4.right().isEmpty()) {
                return var3;
            }
        }
        if (ChunkLevel.generationStatus(this.ticketLevel).isOrAfter(var0)) {
            var4 = var1.schedule(this, var0);
            this.updateChunkToSave((CompletableFuture<? extends Either<? extends IChunkAccess, Failure>>)var4, "schedule " + var0);
            this.futures.set(var2, (CompletableFuture<Either<IChunkAccess, Failure>>)var4);
            return var4;
        }
        return var3 == null ? UNLOADED_CHUNK_FUTURE : var3;
    }

    protected void addSaveDependency(String var02, CompletableFuture<?> var12) {
        if (this.chunkToSaveHistory != null) {
            this.chunkToSaveHistory.push(new b(Thread.currentThread(), var12, var02));
        }
        this.chunkToSave = this.chunkToSave.thenCombine(var12, (var0, var1) -> var0);
    }

    private void updateChunkToSave(CompletableFuture<? extends Either<? extends IChunkAccess, Failure>> var0, String var1) {
        if (this.chunkToSaveHistory != null) {
            this.chunkToSaveHistory.push(new b(Thread.currentThread(), var0, var1));
        }
        this.chunkToSave = this.chunkToSave.thenCombine(var0, (var02, var12) -> (IChunkAccess)var12.map(var0 -> var0, var1 -> var02));
    }

    public FullChunkStatus getFullStatus() {
        return ChunkLevel.fullStatus(this.ticketLevel);
    }

    public ChunkCoordIntPair getPos() {
        return this.pos;
    }

    public int getTicketLevel() {
        return this.ticketLevel;
    }

    public int getQueueLevel() {
        return this.queueLevel;
    }

    private void setQueueLevel(int var0) {
        this.queueLevel = var0;
    }

    public void setTicketLevel(int var0) {
        this.ticketLevel = var0;
    }

    private void scheduleFullChunkPromotion(PlayerChunkMap var0, CompletableFuture<Either<Chunk, Failure>> var1, Executor var2, FullChunkStatus var3) {
        this.pendingFullStateConfirmation.cancel(false);
        CompletableFuture var4 = new CompletableFuture();
        var4.thenRunAsync(() -> var0.onFullChunkStatusChange(this.pos, var3), var2);
        this.pendingFullStateConfirmation = var4;
        var1.thenAccept(var12 -> var12.ifLeft(var1 -> var4.complete(null)));
    }

    private void demoteFullChunk(PlayerChunkMap var0, FullChunkStatus var1) {
        this.pendingFullStateConfirmation.cancel(false);
        var0.onFullChunkStatusChange(this.pos, var1);
    }

    protected void updateFutures(PlayerChunkMap var0, Executor var1) {
        int var9;
        ChunkStatus var2 = ChunkLevel.generationStatus(this.oldTicketLevel);
        ChunkStatus var3 = ChunkLevel.generationStatus(this.ticketLevel);
        boolean var4 = ChunkLevel.isLoaded(this.oldTicketLevel);
        boolean var5 = ChunkLevel.isLoaded(this.ticketLevel);
        FullChunkStatus var6 = ChunkLevel.fullStatus(this.oldTicketLevel);
        FullChunkStatus var7 = ChunkLevel.fullStatus(this.ticketLevel);
        if (var4) {
            Either var8 = Either.right((Object)new Failure(){

                public String toString() {
                    return "Unloaded ticket level " + PlayerChunk.this.pos;
                }
            });
            int n2 = var9 = var5 ? var3.getIndex() + 1 : 0;
            while (var9 <= var2.getIndex()) {
                CompletableFuture<Either<IChunkAccess, Failure>> var10 = this.futures.get(var9);
                if (var10 == null) {
                    this.futures.set(var9, CompletableFuture.completedFuture(var8));
                }
                ++var9;
            }
        }
        boolean var8 = var6.isOrAfter(FullChunkStatus.FULL);
        var9 = var7.isOrAfter(FullChunkStatus.FULL);
        this.wasAccessibleSinceLastSave |= var9;
        if (!var8 && var9 != 0) {
            this.fullChunkFuture = var0.prepareAccessibleChunk(this);
            this.scheduleFullChunkPromotion(var0, this.fullChunkFuture, var1, FullChunkStatus.FULL);
            this.updateChunkToSave(this.fullChunkFuture, "full");
        }
        if (var8 && var9 == 0) {
            this.fullChunkFuture.complete(UNLOADED_LEVEL_CHUNK);
            this.fullChunkFuture = UNLOADED_LEVEL_CHUNK_FUTURE;
        }
        boolean var10 = var6.isOrAfter(FullChunkStatus.BLOCK_TICKING);
        boolean var11 = var7.isOrAfter(FullChunkStatus.BLOCK_TICKING);
        if (!var10 && var11) {
            this.tickingChunkFuture = var0.prepareTickingChunk(this);
            this.scheduleFullChunkPromotion(var0, this.tickingChunkFuture, var1, FullChunkStatus.BLOCK_TICKING);
            this.updateChunkToSave(this.tickingChunkFuture, "ticking");
        }
        if (var10 && !var11) {
            this.tickingChunkFuture.complete(UNLOADED_LEVEL_CHUNK);
            this.tickingChunkFuture = UNLOADED_LEVEL_CHUNK_FUTURE;
        }
        boolean var12 = var6.isOrAfter(FullChunkStatus.ENTITY_TICKING);
        boolean var13 = var7.isOrAfter(FullChunkStatus.ENTITY_TICKING);
        if (!var12 && var13) {
            if (this.entityTickingChunkFuture != UNLOADED_LEVEL_CHUNK_FUTURE) {
                throw SystemUtils.pauseInIde(new IllegalStateException());
            }
            this.entityTickingChunkFuture = var0.prepareEntityTickingChunk(this);
            this.scheduleFullChunkPromotion(var0, this.entityTickingChunkFuture, var1, FullChunkStatus.ENTITY_TICKING);
            this.updateChunkToSave(this.entityTickingChunkFuture, "entity ticking");
        }
        if (var12 && !var13) {
            this.entityTickingChunkFuture.complete(UNLOADED_LEVEL_CHUNK);
            this.entityTickingChunkFuture = UNLOADED_LEVEL_CHUNK_FUTURE;
        }
        if (!var7.isOrAfter(var6)) {
            this.demoteFullChunk(var0, var7);
        }
        this.onLevelChange.onLevelChange(this.pos, this::getQueueLevel, this.ticketLevel, this::setQueueLevel);
        this.oldTicketLevel = this.ticketLevel;
    }

    public boolean wasAccessibleSinceLastSave() {
        return this.wasAccessibleSinceLastSave;
    }

    public void refreshAccessibility() {
        this.wasAccessibleSinceLastSave = ChunkLevel.fullStatus(this.ticketLevel).isOrAfter(FullChunkStatus.FULL);
    }

    public void replaceProtoChunk(ProtoChunkExtension var0) {
        for (int var1 = 0; var1 < this.futures.length(); ++var1) {
            Optional var3;
            CompletableFuture<Either<IChunkAccess, Failure>> var2 = this.futures.get(var1);
            if (var2 == null || (var3 = var2.getNow(UNLOADED_CHUNK).left()).isEmpty() || !(var3.get() instanceof ProtoChunk)) continue;
            this.futures.set(var1, CompletableFuture.completedFuture(Either.left((Object)var0)));
        }
        this.updateChunkToSave(CompletableFuture.completedFuture(Either.left((Object)var0.getWrapped())), "replaceProto");
    }

    public List<Pair<ChunkStatus, CompletableFuture<Either<IChunkAccess, Failure>>>> getAllFutures() {
        ArrayList<Pair<ChunkStatus, CompletableFuture<Either<IChunkAccess, Failure>>>> var0 = new ArrayList<Pair<ChunkStatus, CompletableFuture<Either<IChunkAccess, Failure>>>>();
        for (int var1 = 0; var1 < CHUNK_STATUSES.size(); ++var1) {
            var0.add((Pair<ChunkStatus, CompletableFuture<Either<IChunkAccess, Failure>>>)Pair.of((Object)CHUNK_STATUSES.get(var1), this.futures.get(var1)));
        }
        return var0;
    }

    @FunctionalInterface
    public static interface c {
        public void onLevelChange(ChunkCoordIntPair var1, IntSupplier var2, int var3, IntConsumer var4);
    }

    public static interface d {
        public List<EntityPlayer> getPlayers(ChunkCoordIntPair var1, boolean var2);
    }

    static final class b {
        private final Thread thread;
        private final CompletableFuture<?> future;
        private final String source;

        b(Thread var0, CompletableFuture<?> var1, String var2) {
            this.thread = var0;
            this.future = var1;
            this.source = var2;
        }
    }

    public static interface Failure {
        public static final Failure UNLOADED = new Failure(){

            public String toString() {
                return "UNLOADED";
            }
        };
    }
}

