/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.Collection;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.ICompletionProvider;
import net.minecraft.commands.arguments.ArgumentProfile;
import net.minecraft.network.chat.ChatComponentUtils;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.players.GameProfileBanList;

public class CommandPardon {
    private static final SimpleCommandExceptionType ERROR_NOT_BANNED = new SimpleCommandExceptionType((Message)IChatBaseComponent.translatable("commands.pardon.failed"));

    public static void register(CommandDispatcher<CommandListenerWrapper> var02) {
        var02.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.literal("pardon").requires(var0 -> var0.hasPermission(3))).then(net.minecraft.commands.CommandDispatcher.argument("targets", ArgumentProfile.gameProfile()).suggests((var0, var1) -> ICompletionProvider.suggest(((CommandListenerWrapper)var0.getSource()).getServer().getPlayerList().getBans().getUserList(), var1)).executes(var0 -> CommandPardon.pardonPlayers((CommandListenerWrapper)var0.getSource(), ArgumentProfile.getGameProfiles((CommandContext<CommandListenerWrapper>)var0, "targets")))));
    }

    private static int pardonPlayers(CommandListenerWrapper var0, Collection<GameProfile> var1) throws CommandSyntaxException {
        GameProfileBanList var2 = var0.getServer().getPlayerList().getBans();
        int var3 = 0;
        for (GameProfile var5 : var1) {
            if (!var2.isBanned(var5)) continue;
            var2.remove(var5);
            ++var3;
            var0.sendSuccess(() -> IChatBaseComponent.translatable("commands.pardon.success", ChatComponentUtils.getDisplayName(var5)), true);
        }
        if (var3 == 0) {
            throw ERROR_NOT_BANNED.create();
        }
        return var3;
    }
}

