/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.handshake;

import net.minecraft.SharedConstants;
import net.minecraft.network.EnumProtocol;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.handshake.PacketHandshakingInListener;

public class PacketHandshakingInSetProtocol
implements Packet<PacketHandshakingInListener> {
    private static final int MAX_HOST_LENGTH = 255;
    private final int protocolVersion;
    public String hostName;
    public final int port;
    private final EnumProtocol intention;

    public PacketHandshakingInSetProtocol(String var0, int var1, EnumProtocol var2) {
        this.protocolVersion = SharedConstants.getCurrentVersion().getProtocolVersion();
        this.hostName = var0;
        this.port = var1;
        this.intention = var2;
    }

    public PacketHandshakingInSetProtocol(PacketDataSerializer var0) {
        this.protocolVersion = var0.readVarInt();
        this.hostName = var0.readUtf(255);
        this.port = var0.readUnsignedShort();
        this.intention = EnumProtocol.getById(var0.readVarInt());
    }

    @Override
    public void write(PacketDataSerializer var0) {
        var0.writeVarInt(this.protocolVersion);
        var0.writeUtf(this.hostName);
        var0.writeShort(this.port);
        var0.writeVarInt(this.intention.getId());
    }

    @Override
    public void handle(PacketHandshakingInListener var0) {
        var0.handleIntention(this);
    }

    public EnumProtocol getIntention() {
        return this.intention;
    }

    public int getProtocolVersion() {
        return this.protocolVersion;
    }

    public String getHostName() {
        return this.hostName;
    }

    public int getPort() {
        return this.port;
    }
}

