/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketListenerPlayIn;
import net.minecraft.util.MathHelper;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.entity.TileEntityStructure;
import net.minecraft.world.level.block.state.properties.BlockPropertyStructureMode;

public class PacketPlayInStruct
implements Packet<PacketListenerPlayIn> {
    private static final int FLAG_IGNORE_ENTITIES = 1;
    private static final int FLAG_SHOW_AIR = 2;
    private static final int FLAG_SHOW_BOUNDING_BOX = 4;
    private final BlockPosition pos;
    private final TileEntityStructure.UpdateType updateType;
    private final BlockPropertyStructureMode mode;
    private final String name;
    private final BlockPosition offset;
    private final BaseBlockPosition size;
    private final EnumBlockMirror mirror;
    private final EnumBlockRotation rotation;
    private final String data;
    private final boolean ignoreEntities;
    private final boolean showAir;
    private final boolean showBoundingBox;
    private final float integrity;
    private final long seed;

    public PacketPlayInStruct(BlockPosition var0, TileEntityStructure.UpdateType var1, BlockPropertyStructureMode var2, String var3, BlockPosition var4, BaseBlockPosition var5, EnumBlockMirror var6, EnumBlockRotation var7, String var8, boolean var9, boolean var10, boolean var11, float var12, long var13) {
        this.pos = var0;
        this.updateType = var1;
        this.mode = var2;
        this.name = var3;
        this.offset = var4;
        this.size = var5;
        this.mirror = var6;
        this.rotation = var7;
        this.data = var8;
        this.ignoreEntities = var9;
        this.showAir = var10;
        this.showBoundingBox = var11;
        this.integrity = var12;
        this.seed = var13;
    }

    public PacketPlayInStruct(PacketDataSerializer var0) {
        this.pos = var0.readBlockPos();
        this.updateType = var0.readEnum(TileEntityStructure.UpdateType.class);
        this.mode = var0.readEnum(BlockPropertyStructureMode.class);
        this.name = var0.readUtf();
        int var1 = 48;
        this.offset = new BlockPosition(MathHelper.clamp(var0.readByte(), -48, 48), MathHelper.clamp(var0.readByte(), -48, 48), MathHelper.clamp(var0.readByte(), -48, 48));
        int var2 = 48;
        this.size = new BaseBlockPosition(MathHelper.clamp(var0.readByte(), 0, 48), MathHelper.clamp(var0.readByte(), 0, 48), MathHelper.clamp(var0.readByte(), 0, 48));
        this.mirror = var0.readEnum(EnumBlockMirror.class);
        this.rotation = var0.readEnum(EnumBlockRotation.class);
        this.data = var0.readUtf(128);
        this.integrity = MathHelper.clamp(var0.readFloat(), 0.0f, 1.0f);
        this.seed = var0.readVarLong();
        byte var3 = var0.readByte();
        this.ignoreEntities = (var3 & 1) != 0;
        this.showAir = (var3 & 2) != 0;
        this.showBoundingBox = (var3 & 4) != 0;
    }

    @Override
    public void write(PacketDataSerializer var0) {
        var0.writeBlockPos(this.pos);
        var0.writeEnum(this.updateType);
        var0.writeEnum(this.mode);
        var0.writeUtf(this.name);
        var0.writeByte(this.offset.getX());
        var0.writeByte(this.offset.getY());
        var0.writeByte(this.offset.getZ());
        var0.writeByte(this.size.getX());
        var0.writeByte(this.size.getY());
        var0.writeByte(this.size.getZ());
        var0.writeEnum(this.mirror);
        var0.writeEnum(this.rotation);
        var0.writeUtf(this.data);
        var0.writeFloat(this.integrity);
        var0.writeVarLong(this.seed);
        int var1 = 0;
        if (this.ignoreEntities) {
            var1 |= 1;
        }
        if (this.showAir) {
            var1 |= 2;
        }
        if (this.showBoundingBox) {
            var1 |= 4;
        }
        var0.writeByte(var1);
    }

    @Override
    public void handle(PacketListenerPlayIn var0) {
        var0.handleSetStructureBlock(this);
    }

    public BlockPosition getPos() {
        return this.pos;
    }

    public TileEntityStructure.UpdateType getUpdateType() {
        return this.updateType;
    }

    public BlockPropertyStructureMode getMode() {
        return this.mode;
    }

    public String getName() {
        return this.name;
    }

    public BlockPosition getOffset() {
        return this.offset;
    }

    public BaseBlockPosition getSize() {
        return this.size;
    }

    public EnumBlockMirror getMirror() {
        return this.mirror;
    }

    public EnumBlockRotation getRotation() {
        return this.rotation;
    }

    public String getData() {
        return this.data;
    }

    public boolean isIgnoreEntities() {
        return this.ignoreEntities;
    }

    public boolean isShowAir() {
        return this.showAir;
    }

    public boolean isShowBoundingBox() {
        return this.showBoundingBox;
    }

    public float getIntegrity() {
        return this.integrity;
    }

    public long getSeed() {
        return this.seed;
    }
}

