/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import net.minecraft.core.BlockPosition;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketListenerPlayIn;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.world.level.block.entity.TileEntityJigsaw;

public class PacketPlayInSetJigsaw
implements Packet<PacketListenerPlayIn> {
    private final BlockPosition pos;
    private final MinecraftKey name;
    private final MinecraftKey target;
    private final MinecraftKey pool;
    private final String finalState;
    private final TileEntityJigsaw.JointType joint;

    public PacketPlayInSetJigsaw(BlockPosition var0, MinecraftKey var1, MinecraftKey var2, MinecraftKey var3, String var4, TileEntityJigsaw.JointType var5) {
        this.pos = var0;
        this.name = var1;
        this.target = var2;
        this.pool = var3;
        this.finalState = var4;
        this.joint = var5;
    }

    public PacketPlayInSetJigsaw(PacketDataSerializer var0) {
        this.pos = var0.readBlockPos();
        this.name = var0.readResourceLocation();
        this.target = var0.readResourceLocation();
        this.pool = var0.readResourceLocation();
        this.finalState = var0.readUtf();
        this.joint = TileEntityJigsaw.JointType.byName(var0.readUtf()).orElse(TileEntityJigsaw.JointType.ALIGNED);
    }

    @Override
    public void write(PacketDataSerializer var0) {
        var0.writeBlockPos(this.pos);
        var0.writeResourceLocation(this.name);
        var0.writeResourceLocation(this.target);
        var0.writeResourceLocation(this.pool);
        var0.writeUtf(this.finalState);
        var0.writeUtf(this.joint.getSerializedName());
    }

    @Override
    public void handle(PacketListenerPlayIn var0) {
        var0.handleSetJigsawBlock(this);
    }

    public BlockPosition getPos() {
        return this.pos;
    }

    public MinecraftKey getName() {
        return this.name;
    }

    public MinecraftKey getTarget() {
        return this.target;
    }

    public MinecraftKey getPool() {
        return this.pool;
    }

    public String getFinalState() {
        return this.finalState;
    }

    public TileEntityJigsaw.JointType getJoint() {
        return this.joint;
    }
}

