/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketListenerPlayIn;
import net.minecraft.resources.MinecraftKey;

public class PacketPlayInCustomPayload
implements Packet<PacketListenerPlayIn> {
    private static final int MAX_PAYLOAD_SIZE = Short.MAX_VALUE;
    public static final MinecraftKey BRAND = new MinecraftKey("brand");
    public final MinecraftKey identifier;
    public final PacketDataSerializer data;

    public PacketPlayInCustomPayload(MinecraftKey var0, PacketDataSerializer var1) {
        this.identifier = var0;
        this.data = var1;
    }

    public PacketPlayInCustomPayload(PacketDataSerializer var0) {
        this.identifier = var0.readResourceLocation();
        int var1 = var0.readableBytes();
        if (var1 < 0 || var1 > Short.MAX_VALUE) {
            throw new IllegalArgumentException("Payload may not be larger than 32767 bytes");
        }
        this.data = new PacketDataSerializer(var0.readBytes(var1));
    }

    @Override
    public void write(PacketDataSerializer var0) {
        var0.writeResourceLocation(this.identifier);
        var0.writeBytes(this.data);
    }

    @Override
    public void handle(PacketListenerPlayIn var0) {
        var0.handleCustomPayload(this);
        this.data.release();
    }

    public MinecraftKey getIdentifier() {
        return this.identifier;
    }

    public PacketDataSerializer getData() {
        return this.data;
    }
}

