/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network;

import com.mojang.logging.LogUtils;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToByteEncoder;
import java.io.IOException;
import net.minecraft.network.EnumProtocol;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.SkipEncodeException;
import net.minecraft.network.protocol.EnumProtocolDirection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.util.profiling.jfr.JvmProfiler;
import org.slf4j.Logger;

public class PacketEncoder
extends MessageToByteEncoder<Packet<?>> {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final EnumProtocolDirection flow;

    public PacketEncoder(EnumProtocolDirection var0) {
        this.flow = var0;
    }

    protected void encode(ChannelHandlerContext var0, Packet<?> var1, ByteBuf var2) throws Exception {
        EnumProtocol var3 = (EnumProtocol)var0.channel().attr(NetworkManager.ATTRIBUTE_PROTOCOL).get();
        if (var3 == null) {
            throw new RuntimeException("ConnectionProtocol unknown: " + var1);
        }
        int var4 = var3.getPacketId(this.flow, var1);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(NetworkManager.PACKET_SENT_MARKER, "OUT: [{}:{}] {}", new Object[]{var0.channel().attr(NetworkManager.ATTRIBUTE_PROTOCOL).get(), var4, var1.getClass().getName()});
        }
        if (var4 == -1) {
            throw new IOException("Can't serialize unregistered packet");
        }
        PacketDataSerializer var5 = new PacketDataSerializer(var2);
        var5.writeVarInt(var4);
        try {
            int var6 = var5.writerIndex();
            var1.write(var5);
            int var7 = var5.writerIndex() - var6;
            if (var7 > 0x800000) {
                throw new IllegalArgumentException("Packet too big (is " + var7 + ", should be less than 8388608): " + var1);
            }
            int var8 = ((EnumProtocol)var0.channel().attr(NetworkManager.ATTRIBUTE_PROTOCOL).get()).getId();
            JvmProfiler.INSTANCE.onPacketSent(var8, var4, var0.channel().remoteAddress(), var7);
        }
        catch (Throwable var6) {
            LOGGER.error("Error receiving packet {}", (Object)var4, (Object)var6);
            if (var1.isSkippable()) {
                throw new SkipEncodeException(var6);
            }
            throw var6;
        }
    }

    protected /* synthetic */ void encode(ChannelHandlerContext channelHandlerContext, Object object, ByteBuf byteBuf) throws Exception {
        this.encode(channelHandlerContext, (Packet)object, byteBuf);
    }
}

