/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.properties.PropertyMap;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.codec.EncoderException;
import io.netty.util.ByteProcessor;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.PublicKey;
import java.time.Instant;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistry;
import net.minecraft.core.Registry;
import net.minecraft.core.SectionPosition;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTCompressedStreamTools;
import net.minecraft.nbt.NBTReadLimiter;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.ChatDeserializer;
import net.minecraft.util.CryptographyException;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MinecraftEncryption;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.World;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public class PacketDataSerializer
extends ByteBuf {
    private static final int MAX_VARINT_SIZE = 5;
    private static final int MAX_VARLONG_SIZE = 10;
    public static final int DEFAULT_NBT_QUOTA = 0x200000;
    private final ByteBuf source;
    public static final short MAX_STRING_LENGTH = Short.MAX_VALUE;
    public static final int MAX_COMPONENT_STRING_LENGTH = 262144;
    private static final int PUBLIC_KEY_SIZE = 256;
    private static final int MAX_PUBLIC_KEY_HEADER_SIZE = 256;
    private static final int MAX_PUBLIC_KEY_LENGTH = 512;
    private static final Gson GSON = new Gson();

    public PacketDataSerializer(ByteBuf var0) {
        this.source = var0;
    }

    public static int getVarIntSize(int var0) {
        for (int var1 = 1; var1 < 5; ++var1) {
            if ((var0 & -1 << var1 * 7) != 0) continue;
            return var1;
        }
        return 5;
    }

    public static int getVarLongSize(long var0) {
        for (int var2 = 1; var2 < 10; ++var2) {
            if ((var0 & -1L << var2 * 7) != 0L) continue;
            return var2;
        }
        return 10;
    }

    @Deprecated
    public <T> T readWithCodec(DynamicOps<NBTBase> var0, Codec<T> var12) {
        NBTTagCompound var2 = this.readAnySizeNbt();
        return SystemUtils.getOrThrow(var12.parse(var0, (Object)var2), var1 -> new DecoderException("Failed to decode: " + var1 + " " + var2));
    }

    @Deprecated
    public <T> void writeWithCodec(DynamicOps<NBTBase> var0, Codec<T> var12, T var2) {
        NBTBase var3 = (NBTBase)SystemUtils.getOrThrow(var12.encodeStart(var0, var2), var1 -> new EncoderException("Failed to encode: " + var1 + " " + var2));
        this.writeNbt((NBTTagCompound)var3);
    }

    public <T> T readJsonWithCodec(Codec<T> var02) {
        JsonElement var1 = ChatDeserializer.fromJson(GSON, this.readUtf(), JsonElement.class);
        DataResult var2 = var02.parse((DynamicOps)JsonOps.INSTANCE, (Object)var1);
        return SystemUtils.getOrThrow(var2, var0 -> new DecoderException("Failed to decode json: " + var0));
    }

    public <T> void writeJsonWithCodec(Codec<T> var0, T var12) {
        DataResult var2 = var0.encodeStart((DynamicOps)JsonOps.INSTANCE, var12);
        this.writeUtf(GSON.toJson((JsonElement)SystemUtils.getOrThrow(var2, var1 -> new EncoderException("Failed to encode: " + var1 + " " + var12))));
    }

    public <T> void writeId(Registry<T> var0, T var1) {
        int var2 = var0.getId(var1);
        if (var2 == -1) {
            throw new IllegalArgumentException("Can't find id for '" + var1 + "' in map " + var0);
        }
        this.writeVarInt(var2);
    }

    public <T> void writeId(Registry<Holder<T>> var0, Holder<T> var1, b<T> var2) {
        switch (var1.kind()) {
            case REFERENCE: {
                int var3 = var0.getId(var1);
                if (var3 == -1) {
                    throw new IllegalArgumentException("Can't find id for '" + var1.value() + "' in map " + var0);
                }
                this.writeVarInt(var3 + 1);
                break;
            }
            case DIRECT: {
                this.writeVarInt(0);
                var2.accept(this, var1.value());
            }
        }
    }

    @Nullable
    public <T> T readById(Registry<T> var0) {
        int var1 = this.readVarInt();
        return var0.byId(var1);
    }

    public <T> Holder<T> readById(Registry<Holder<T>> var0, a<T> var1) {
        int var2 = this.readVarInt();
        if (var2 == 0) {
            return Holder.direct(var1.apply(this));
        }
        Holder<T> var3 = var0.byId(var2 - 1);
        if (var3 == null) {
            throw new IllegalArgumentException("Can't find element with id " + var2);
        }
        return var3;
    }

    public static <T> IntFunction<T> limitValue(IntFunction<T> var0, int var1) {
        return var2 -> {
            if (var2 > var1) {
                throw new DecoderException("Value " + var2 + " is larger than limit " + var1);
            }
            return var0.apply(var2);
        };
    }

    public <T, C extends Collection<T>> C readCollection(IntFunction<C> var0, a<T> var1) {
        int var2 = this.readVarInt();
        Collection var3 = (Collection)var0.apply(var2);
        for (int var4 = 0; var4 < var2; ++var4) {
            var3.add(var1.apply(this));
        }
        return (C)var3;
    }

    public <T> void writeCollection(Collection<T> var0, b<T> var1) {
        this.writeVarInt(var0.size());
        for (T var3 : var0) {
            var1.accept(this, var3);
        }
    }

    public <T> List<T> readList(a<T> var0) {
        return this.readCollection(Lists::newArrayListWithCapacity, var0);
    }

    public IntList readIntIdList() {
        int var0 = this.readVarInt();
        IntArrayList var1 = new IntArrayList();
        for (int var2 = 0; var2 < var0; ++var2) {
            var1.add(this.readVarInt());
        }
        return var1;
    }

    public void writeIntIdList(IntList var0) {
        this.writeVarInt(var0.size());
        var0.forEach(this::writeVarInt);
    }

    public <K, V, M extends Map<K, V>> M readMap(IntFunction<M> var0, a<K> var1, a<V> var2) {
        int var3 = this.readVarInt();
        Map var4 = (Map)var0.apply(var3);
        for (int var5 = 0; var5 < var3; ++var5) {
            Object var6 = var1.apply((K)((Object)this));
            Object var7 = var2.apply((V)((Object)this));
            var4.put(var6, var7);
        }
        return (M)var4;
    }

    public <K, V> Map<K, V> readMap(a<K> var0, a<V> var1) {
        return this.readMap(Maps::newHashMapWithExpectedSize, var0, var1);
    }

    public <K, V> void writeMap(Map<K, V> var0, b<K> var1, b<V> var22) {
        this.writeVarInt(var0.size());
        var0.forEach((var2, var3) -> {
            var1.accept((Object)((Object)this), var2);
            var22.accept((Object)((Object)this), var3);
        });
    }

    public void readWithCount(Consumer<PacketDataSerializer> var0) {
        int var1 = this.readVarInt();
        for (int var2 = 0; var2 < var1; ++var2) {
            var0.accept(this);
        }
    }

    public <E extends Enum<E>> void writeEnumSet(EnumSet<E> var0, Class<E> var1) {
        Enum[] var2 = (Enum[])var1.getEnumConstants();
        BitSet var3 = new BitSet(var2.length);
        for (int var4 = 0; var4 < var2.length; ++var4) {
            var3.set(var4, var0.contains(var2[var4]));
        }
        this.writeFixedBitSet(var3, var2.length);
    }

    public <E extends Enum<E>> EnumSet<E> readEnumSet(Class<E> var0) {
        Enum[] var1 = (Enum[])var0.getEnumConstants();
        BitSet var2 = this.readFixedBitSet(var1.length);
        EnumSet<Enum> var3 = EnumSet.noneOf(var0);
        for (int var4 = 0; var4 < var1.length; ++var4) {
            if (!var2.get(var4)) continue;
            var3.add(var1[var4]);
        }
        return var3;
    }

    public <T> void writeOptional(Optional<T> var0, b<T> var1) {
        if (var0.isPresent()) {
            this.writeBoolean(true);
            var1.accept(this, var0.get());
        } else {
            this.writeBoolean(false);
        }
    }

    public <T> Optional<T> readOptional(a<T> var0) {
        if (this.readBoolean()) {
            return Optional.of(var0.apply(this));
        }
        return Optional.empty();
    }

    @Nullable
    public <T> T readNullable(a<T> var0) {
        if (this.readBoolean()) {
            return (T)var0.apply(this);
        }
        return null;
    }

    public <T> void writeNullable(@Nullable T var0, b<T> var1) {
        if (var0 != null) {
            this.writeBoolean(true);
            var1.accept(this, var0);
        } else {
            this.writeBoolean(false);
        }
    }

    public <L, R> void writeEither(Either<L, R> var0, b<L> var12, b<R> var2) {
        var0.ifLeft(var1 -> {
            this.writeBoolean(true);
            var12.accept((Object)((Object)this), var1);
        }).ifRight(var1 -> {
            this.writeBoolean(false);
            var2.accept((Object)((Object)this), var1);
        });
    }

    public <L, R> Either<L, R> readEither(a<L> var0, a<R> var1) {
        if (this.readBoolean()) {
            return Either.left(var0.apply((L)((Object)this)));
        }
        return Either.right(var1.apply((R)((Object)this)));
    }

    public byte[] readByteArray() {
        return this.readByteArray(this.readableBytes());
    }

    public PacketDataSerializer writeByteArray(byte[] var0) {
        this.writeVarInt(var0.length);
        this.writeBytes(var0);
        return this;
    }

    public byte[] readByteArray(int var0) {
        int var1 = this.readVarInt();
        if (var1 > var0) {
            throw new DecoderException("ByteArray with size " + var1 + " is bigger than allowed " + var0);
        }
        byte[] var2 = new byte[var1];
        this.readBytes(var2);
        return var2;
    }

    public PacketDataSerializer writeVarIntArray(int[] var0) {
        this.writeVarInt(var0.length);
        for (int var4 : var0) {
            this.writeVarInt(var4);
        }
        return this;
    }

    public int[] readVarIntArray() {
        return this.readVarIntArray(this.readableBytes());
    }

    public int[] readVarIntArray(int var0) {
        int var1 = this.readVarInt();
        if (var1 > var0) {
            throw new DecoderException("VarIntArray with size " + var1 + " is bigger than allowed " + var0);
        }
        int[] var2 = new int[var1];
        for (int var3 = 0; var3 < var2.length; ++var3) {
            var2[var3] = this.readVarInt();
        }
        return var2;
    }

    public PacketDataSerializer writeLongArray(long[] var0) {
        this.writeVarInt(var0.length);
        for (long var4 : var0) {
            this.writeLong(var4);
        }
        return this;
    }

    public long[] readLongArray() {
        return this.readLongArray(null);
    }

    public long[] readLongArray(@Nullable long[] var0) {
        return this.readLongArray(var0, this.readableBytes() / 8);
    }

    public long[] readLongArray(@Nullable long[] var0, int var1) {
        int var2 = this.readVarInt();
        if (var0 == null || var0.length != var2) {
            if (var2 > var1) {
                throw new DecoderException("LongArray with size " + var2 + " is bigger than allowed " + var1);
            }
            var0 = new long[var2];
        }
        for (int var3 = 0; var3 < var0.length; ++var3) {
            var0[var3] = this.readLong();
        }
        return var0;
    }

    @VisibleForTesting
    public byte[] accessByteBufWithCorrectSize() {
        int var0 = this.writerIndex();
        byte[] var1 = new byte[var0];
        this.getBytes(0, var1);
        return var1;
    }

    public BlockPosition readBlockPos() {
        return BlockPosition.of(this.readLong());
    }

    public PacketDataSerializer writeBlockPos(BlockPosition var0) {
        this.writeLong(var0.asLong());
        return this;
    }

    public ChunkCoordIntPair readChunkPos() {
        return new ChunkCoordIntPair(this.readLong());
    }

    public PacketDataSerializer writeChunkPos(ChunkCoordIntPair var0) {
        this.writeLong(var0.toLong());
        return this;
    }

    public SectionPosition readSectionPos() {
        return SectionPosition.of(this.readLong());
    }

    public PacketDataSerializer writeSectionPos(SectionPosition var0) {
        this.writeLong(var0.asLong());
        return this;
    }

    public GlobalPos readGlobalPos() {
        ResourceKey<World> var0 = this.readResourceKey(Registries.DIMENSION);
        BlockPosition var1 = this.readBlockPos();
        return GlobalPos.of(var0, var1);
    }

    public void writeGlobalPos(GlobalPos var0) {
        this.writeResourceKey(var0.dimension());
        this.writeBlockPos(var0.pos());
    }

    public Vector3f readVector3f() {
        return new Vector3f(this.readFloat(), this.readFloat(), this.readFloat());
    }

    public void writeVector3f(Vector3f var0) {
        this.writeFloat(var0.x());
        this.writeFloat(var0.y());
        this.writeFloat(var0.z());
    }

    public Quaternionf readQuaternion() {
        return new Quaternionf(this.readFloat(), this.readFloat(), this.readFloat(), this.readFloat());
    }

    public void writeQuaternion(Quaternionf var0) {
        this.writeFloat(var0.x);
        this.writeFloat(var0.y);
        this.writeFloat(var0.z);
        this.writeFloat(var0.w);
    }

    public IChatBaseComponent readComponent() {
        IChatMutableComponent var0 = IChatBaseComponent.ChatSerializer.fromJson(this.readUtf(262144));
        if (var0 == null) {
            throw new DecoderException("Received unexpected null component");
        }
        return var0;
    }

    public PacketDataSerializer writeComponent(IChatBaseComponent var0) {
        return this.writeUtf(IChatBaseComponent.ChatSerializer.toJson(var0), 262144);
    }

    public <T extends Enum<T>> T readEnum(Class<T> var0) {
        return (T)((Enum[])var0.getEnumConstants())[this.readVarInt()];
    }

    public PacketDataSerializer writeEnum(Enum<?> var0) {
        return this.writeVarInt(var0.ordinal());
    }

    public int readVarInt() {
        byte var2;
        int var0 = 0;
        int var1 = 0;
        do {
            var2 = this.readByte();
            var0 |= (var2 & 0x7F) << var1++ * 7;
            if (var1 <= 5) continue;
            throw new RuntimeException("VarInt too big");
        } while ((var2 & 0x80) == 128);
        return var0;
    }

    public long readVarLong() {
        byte var3;
        long var0 = 0L;
        int var2 = 0;
        do {
            var3 = this.readByte();
            var0 |= (long)(var3 & 0x7F) << var2++ * 7;
            if (var2 <= 10) continue;
            throw new RuntimeException("VarLong too big");
        } while ((var3 & 0x80) == 128);
        return var0;
    }

    public PacketDataSerializer writeUUID(UUID var0) {
        this.writeLong(var0.getMostSignificantBits());
        this.writeLong(var0.getLeastSignificantBits());
        return this;
    }

    public UUID readUUID() {
        return new UUID(this.readLong(), this.readLong());
    }

    public PacketDataSerializer writeVarInt(int var0) {
        while (true) {
            if ((var0 & 0xFFFFFF80) == 0) {
                this.writeByte(var0);
                return this;
            }
            this.writeByte(var0 & 0x7F | 0x80);
            var0 >>>= 7;
        }
    }

    public PacketDataSerializer writeVarLong(long var0) {
        while (true) {
            if ((var0 & 0xFFFFFFFFFFFFFF80L) == 0L) {
                this.writeByte((int)var0);
                return this;
            }
            this.writeByte((int)(var0 & 0x7FL) | 0x80);
            var0 >>>= 7;
        }
    }

    public PacketDataSerializer writeNbt(@Nullable NBTTagCompound var0) {
        if (var0 == null) {
            this.writeByte(0);
        } else {
            try {
                NBTCompressedStreamTools.write(var0, (DataOutput)new ByteBufOutputStream((ByteBuf)this));
            }
            catch (IOException var1) {
                throw new EncoderException((Throwable)var1);
            }
        }
        return this;
    }

    @Nullable
    public NBTTagCompound readNbt() {
        return this.readNbt(new NBTReadLimiter(0x200000L));
    }

    @Nullable
    public NBTTagCompound readAnySizeNbt() {
        return this.readNbt(NBTReadLimiter.UNLIMITED);
    }

    @Nullable
    public NBTTagCompound readNbt(NBTReadLimiter var0) {
        int var1 = this.readerIndex();
        byte var2 = this.readByte();
        if (var2 == 0) {
            return null;
        }
        this.readerIndex(var1);
        try {
            return NBTCompressedStreamTools.read((DataInput)new ByteBufInputStream((ByteBuf)this), var0);
        }
        catch (IOException var3) {
            throw new EncoderException((Throwable)var3);
        }
    }

    public PacketDataSerializer writeItem(ItemStack var0) {
        if (var0.isEmpty()) {
            this.writeBoolean(false);
        } else {
            this.writeBoolean(true);
            Item var1 = var0.getItem();
            this.writeId(BuiltInRegistries.ITEM, var1);
            this.writeByte(var0.getCount());
            NBTTagCompound var2 = null;
            if (var1.canBeDepleted() || var1.shouldOverrideMultiplayerNbt()) {
                var2 = var0.getTag();
            }
            this.writeNbt(var2);
        }
        return this;
    }

    public ItemStack readItem() {
        if (!this.readBoolean()) {
            return ItemStack.EMPTY;
        }
        Item var0 = this.readById(BuiltInRegistries.ITEM);
        byte var1 = this.readByte();
        ItemStack var2 = new ItemStack(var0, (int)var1);
        var2.setTag(this.readNbt());
        return var2;
    }

    public String readUtf() {
        return this.readUtf(Short.MAX_VALUE);
    }

    public String readUtf(int var0) {
        int var1 = PacketDataSerializer.getMaxEncodedUtfLength(var0);
        int var2 = this.readVarInt();
        if (var2 > var1) {
            throw new DecoderException("The received encoded string buffer length is longer than maximum allowed (" + var2 + " > " + var1 + ")");
        }
        if (var2 < 0) {
            throw new DecoderException("The received encoded string buffer length is less than zero! Weird string!");
        }
        String var3 = this.toString(this.readerIndex(), var2, StandardCharsets.UTF_8);
        this.readerIndex(this.readerIndex() + var2);
        if (var3.length() > var0) {
            throw new DecoderException("The received string length is longer than maximum allowed (" + var3.length() + " > " + var0 + ")");
        }
        return var3;
    }

    public PacketDataSerializer writeUtf(String var0) {
        return this.writeUtf(var0, Short.MAX_VALUE);
    }

    public PacketDataSerializer writeUtf(String var0, int var1) {
        int var3;
        if (var0.length() > var1) {
            throw new EncoderException("String too big (was " + var0.length() + " characters, max " + var1 + ")");
        }
        byte[] var2 = var0.getBytes(StandardCharsets.UTF_8);
        if (var2.length > (var3 = PacketDataSerializer.getMaxEncodedUtfLength(var1))) {
            throw new EncoderException("String too big (was " + var2.length + " bytes encoded, max " + var3 + ")");
        }
        this.writeVarInt(var2.length);
        this.writeBytes(var2);
        return this;
    }

    private static int getMaxEncodedUtfLength(int var0) {
        return var0 * 3;
    }

    public MinecraftKey readResourceLocation() {
        return new MinecraftKey(this.readUtf(Short.MAX_VALUE));
    }

    public PacketDataSerializer writeResourceLocation(MinecraftKey var0) {
        this.writeUtf(var0.toString());
        return this;
    }

    public <T> ResourceKey<T> readResourceKey(ResourceKey<? extends IRegistry<T>> var0) {
        MinecraftKey var1 = this.readResourceLocation();
        return ResourceKey.create(var0, var1);
    }

    public void writeResourceKey(ResourceKey<?> var0) {
        this.writeResourceLocation(var0.location());
    }

    public Date readDate() {
        return new Date(this.readLong());
    }

    public PacketDataSerializer writeDate(Date var0) {
        this.writeLong(var0.getTime());
        return this;
    }

    public Instant readInstant() {
        return Instant.ofEpochMilli(this.readLong());
    }

    public void writeInstant(Instant var0) {
        this.writeLong(var0.toEpochMilli());
    }

    public PublicKey readPublicKey() {
        try {
            return MinecraftEncryption.byteToPublicKey(this.readByteArray(512));
        }
        catch (CryptographyException var0) {
            throw new DecoderException("Malformed public key bytes", (Throwable)var0);
        }
    }

    public PacketDataSerializer writePublicKey(PublicKey var0) {
        this.writeByteArray(var0.getEncoded());
        return this;
    }

    public MovingObjectPositionBlock readBlockHitResult() {
        BlockPosition var0 = this.readBlockPos();
        EnumDirection var1 = this.readEnum(EnumDirection.class);
        float var2 = this.readFloat();
        float var3 = this.readFloat();
        float var4 = this.readFloat();
        boolean var5 = this.readBoolean();
        return new MovingObjectPositionBlock(new Vec3D((double)var0.getX() + (double)var2, (double)var0.getY() + (double)var3, (double)var0.getZ() + (double)var4), var1, var0, var5);
    }

    public void writeBlockHitResult(MovingObjectPositionBlock var0) {
        BlockPosition var1 = var0.getBlockPos();
        this.writeBlockPos(var1);
        this.writeEnum(var0.getDirection());
        Vec3D var2 = var0.getLocation();
        this.writeFloat((float)(var2.x - (double)var1.getX()));
        this.writeFloat((float)(var2.y - (double)var1.getY()));
        this.writeFloat((float)(var2.z - (double)var1.getZ()));
        this.writeBoolean(var0.isInside());
    }

    public BitSet readBitSet() {
        return BitSet.valueOf(this.readLongArray());
    }

    public void writeBitSet(BitSet var0) {
        this.writeLongArray(var0.toLongArray());
    }

    public BitSet readFixedBitSet(int var0) {
        byte[] var1 = new byte[MathHelper.positiveCeilDiv(var0, 8)];
        this.readBytes(var1);
        return BitSet.valueOf(var1);
    }

    public void writeFixedBitSet(BitSet var0, int var1) {
        if (var0.length() > var1) {
            throw new EncoderException("BitSet is larger than expected size (" + var0.length() + ">" + var1 + ")");
        }
        byte[] var2 = var0.toByteArray();
        this.writeBytes(Arrays.copyOf(var2, MathHelper.positiveCeilDiv(var1, 8)));
    }

    public GameProfile readGameProfile() {
        UUID var0 = this.readUUID();
        String var1 = this.readUtf(16);
        GameProfile var2 = new GameProfile(var0, var1);
        var2.getProperties().putAll((Multimap)this.readGameProfileProperties());
        return var2;
    }

    public void writeGameProfile(GameProfile var0) {
        this.writeUUID(var0.getId());
        this.writeUtf(var0.getName());
        this.writeGameProfileProperties(var0.getProperties());
    }

    public PropertyMap readGameProfileProperties() {
        PropertyMap var0 = new PropertyMap();
        this.readWithCount(var1 -> {
            Property var2 = this.readProperty();
            var0.put((Object)var2.getName(), (Object)var2);
        });
        return var0;
    }

    public void writeGameProfileProperties(PropertyMap var0) {
        this.writeCollection(var0.values(), PacketDataSerializer::writeProperty);
    }

    public Property readProperty() {
        String var0 = this.readUtf();
        String var1 = this.readUtf();
        if (this.readBoolean()) {
            String var2 = this.readUtf();
            return new Property(var0, var1, var2);
        }
        return new Property(var0, var1);
    }

    public void writeProperty(Property var0) {
        this.writeUtf(var0.getName());
        this.writeUtf(var0.getValue());
        if (var0.hasSignature()) {
            this.writeBoolean(true);
            this.writeUtf(var0.getSignature());
        } else {
            this.writeBoolean(false);
        }
    }

    public int capacity() {
        return this.source.capacity();
    }

    public ByteBuf capacity(int var0) {
        return this.source.capacity(var0);
    }

    public int maxCapacity() {
        return this.source.maxCapacity();
    }

    public ByteBufAllocator alloc() {
        return this.source.alloc();
    }

    public ByteOrder order() {
        return this.source.order();
    }

    public ByteBuf order(ByteOrder var0) {
        return this.source.order(var0);
    }

    public ByteBuf unwrap() {
        return this.source.unwrap();
    }

    public boolean isDirect() {
        return this.source.isDirect();
    }

    public boolean isReadOnly() {
        return this.source.isReadOnly();
    }

    public ByteBuf asReadOnly() {
        return this.source.asReadOnly();
    }

    public int readerIndex() {
        return this.source.readerIndex();
    }

    public ByteBuf readerIndex(int var0) {
        return this.source.readerIndex(var0);
    }

    public int writerIndex() {
        return this.source.writerIndex();
    }

    public ByteBuf writerIndex(int var0) {
        return this.source.writerIndex(var0);
    }

    public ByteBuf setIndex(int var0, int var1) {
        return this.source.setIndex(var0, var1);
    }

    public int readableBytes() {
        return this.source.readableBytes();
    }

    public int writableBytes() {
        return this.source.writableBytes();
    }

    public int maxWritableBytes() {
        return this.source.maxWritableBytes();
    }

    public boolean isReadable() {
        return this.source.isReadable();
    }

    public boolean isReadable(int var0) {
        return this.source.isReadable(var0);
    }

    public boolean isWritable() {
        return this.source.isWritable();
    }

    public boolean isWritable(int var0) {
        return this.source.isWritable(var0);
    }

    public ByteBuf clear() {
        return this.source.clear();
    }

    public ByteBuf markReaderIndex() {
        return this.source.markReaderIndex();
    }

    public ByteBuf resetReaderIndex() {
        return this.source.resetReaderIndex();
    }

    public ByteBuf markWriterIndex() {
        return this.source.markWriterIndex();
    }

    public ByteBuf resetWriterIndex() {
        return this.source.resetWriterIndex();
    }

    public ByteBuf discardReadBytes() {
        return this.source.discardReadBytes();
    }

    public ByteBuf discardSomeReadBytes() {
        return this.source.discardSomeReadBytes();
    }

    public ByteBuf ensureWritable(int var0) {
        return this.source.ensureWritable(var0);
    }

    public int ensureWritable(int var0, boolean var1) {
        return this.source.ensureWritable(var0, var1);
    }

    public boolean getBoolean(int var0) {
        return this.source.getBoolean(var0);
    }

    public byte getByte(int var0) {
        return this.source.getByte(var0);
    }

    public short getUnsignedByte(int var0) {
        return this.source.getUnsignedByte(var0);
    }

    public short getShort(int var0) {
        return this.source.getShort(var0);
    }

    public short getShortLE(int var0) {
        return this.source.getShortLE(var0);
    }

    public int getUnsignedShort(int var0) {
        return this.source.getUnsignedShort(var0);
    }

    public int getUnsignedShortLE(int var0) {
        return this.source.getUnsignedShortLE(var0);
    }

    public int getMedium(int var0) {
        return this.source.getMedium(var0);
    }

    public int getMediumLE(int var0) {
        return this.source.getMediumLE(var0);
    }

    public int getUnsignedMedium(int var0) {
        return this.source.getUnsignedMedium(var0);
    }

    public int getUnsignedMediumLE(int var0) {
        return this.source.getUnsignedMediumLE(var0);
    }

    public int getInt(int var0) {
        return this.source.getInt(var0);
    }

    public int getIntLE(int var0) {
        return this.source.getIntLE(var0);
    }

    public long getUnsignedInt(int var0) {
        return this.source.getUnsignedInt(var0);
    }

    public long getUnsignedIntLE(int var0) {
        return this.source.getUnsignedIntLE(var0);
    }

    public long getLong(int var0) {
        return this.source.getLong(var0);
    }

    public long getLongLE(int var0) {
        return this.source.getLongLE(var0);
    }

    public char getChar(int var0) {
        return this.source.getChar(var0);
    }

    public float getFloat(int var0) {
        return this.source.getFloat(var0);
    }

    public double getDouble(int var0) {
        return this.source.getDouble(var0);
    }

    public ByteBuf getBytes(int var0, ByteBuf var1) {
        return this.source.getBytes(var0, var1);
    }

    public ByteBuf getBytes(int var0, ByteBuf var1, int var2) {
        return this.source.getBytes(var0, var1, var2);
    }

    public ByteBuf getBytes(int var0, ByteBuf var1, int var2, int var3) {
        return this.source.getBytes(var0, var1, var2, var3);
    }

    public ByteBuf getBytes(int var0, byte[] var1) {
        return this.source.getBytes(var0, var1);
    }

    public ByteBuf getBytes(int var0, byte[] var1, int var2, int var3) {
        return this.source.getBytes(var0, var1, var2, var3);
    }

    public ByteBuf getBytes(int var0, ByteBuffer var1) {
        return this.source.getBytes(var0, var1);
    }

    public ByteBuf getBytes(int var0, OutputStream var1, int var2) throws IOException {
        return this.source.getBytes(var0, var1, var2);
    }

    public int getBytes(int var0, GatheringByteChannel var1, int var2) throws IOException {
        return this.source.getBytes(var0, var1, var2);
    }

    public int getBytes(int var0, FileChannel var1, long var2, int var4) throws IOException {
        return this.source.getBytes(var0, var1, var2, var4);
    }

    public CharSequence getCharSequence(int var0, int var1, Charset var2) {
        return this.source.getCharSequence(var0, var1, var2);
    }

    public ByteBuf setBoolean(int var0, boolean var1) {
        return this.source.setBoolean(var0, var1);
    }

    public ByteBuf setByte(int var0, int var1) {
        return this.source.setByte(var0, var1);
    }

    public ByteBuf setShort(int var0, int var1) {
        return this.source.setShort(var0, var1);
    }

    public ByteBuf setShortLE(int var0, int var1) {
        return this.source.setShortLE(var0, var1);
    }

    public ByteBuf setMedium(int var0, int var1) {
        return this.source.setMedium(var0, var1);
    }

    public ByteBuf setMediumLE(int var0, int var1) {
        return this.source.setMediumLE(var0, var1);
    }

    public ByteBuf setInt(int var0, int var1) {
        return this.source.setInt(var0, var1);
    }

    public ByteBuf setIntLE(int var0, int var1) {
        return this.source.setIntLE(var0, var1);
    }

    public ByteBuf setLong(int var0, long var1) {
        return this.source.setLong(var0, var1);
    }

    public ByteBuf setLongLE(int var0, long var1) {
        return this.source.setLongLE(var0, var1);
    }

    public ByteBuf setChar(int var0, int var1) {
        return this.source.setChar(var0, var1);
    }

    public ByteBuf setFloat(int var0, float var1) {
        return this.source.setFloat(var0, var1);
    }

    public ByteBuf setDouble(int var0, double var1) {
        return this.source.setDouble(var0, var1);
    }

    public ByteBuf setBytes(int var0, ByteBuf var1) {
        return this.source.setBytes(var0, var1);
    }

    public ByteBuf setBytes(int var0, ByteBuf var1, int var2) {
        return this.source.setBytes(var0, var1, var2);
    }

    public ByteBuf setBytes(int var0, ByteBuf var1, int var2, int var3) {
        return this.source.setBytes(var0, var1, var2, var3);
    }

    public ByteBuf setBytes(int var0, byte[] var1) {
        return this.source.setBytes(var0, var1);
    }

    public ByteBuf setBytes(int var0, byte[] var1, int var2, int var3) {
        return this.source.setBytes(var0, var1, var2, var3);
    }

    public ByteBuf setBytes(int var0, ByteBuffer var1) {
        return this.source.setBytes(var0, var1);
    }

    public int setBytes(int var0, InputStream var1, int var2) throws IOException {
        return this.source.setBytes(var0, var1, var2);
    }

    public int setBytes(int var0, ScatteringByteChannel var1, int var2) throws IOException {
        return this.source.setBytes(var0, var1, var2);
    }

    public int setBytes(int var0, FileChannel var1, long var2, int var4) throws IOException {
        return this.source.setBytes(var0, var1, var2, var4);
    }

    public ByteBuf setZero(int var0, int var1) {
        return this.source.setZero(var0, var1);
    }

    public int setCharSequence(int var0, CharSequence var1, Charset var2) {
        return this.source.setCharSequence(var0, var1, var2);
    }

    public boolean readBoolean() {
        return this.source.readBoolean();
    }

    public byte readByte() {
        return this.source.readByte();
    }

    public short readUnsignedByte() {
        return this.source.readUnsignedByte();
    }

    public short readShort() {
        return this.source.readShort();
    }

    public short readShortLE() {
        return this.source.readShortLE();
    }

    public int readUnsignedShort() {
        return this.source.readUnsignedShort();
    }

    public int readUnsignedShortLE() {
        return this.source.readUnsignedShortLE();
    }

    public int readMedium() {
        return this.source.readMedium();
    }

    public int readMediumLE() {
        return this.source.readMediumLE();
    }

    public int readUnsignedMedium() {
        return this.source.readUnsignedMedium();
    }

    public int readUnsignedMediumLE() {
        return this.source.readUnsignedMediumLE();
    }

    public int readInt() {
        return this.source.readInt();
    }

    public int readIntLE() {
        return this.source.readIntLE();
    }

    public long readUnsignedInt() {
        return this.source.readUnsignedInt();
    }

    public long readUnsignedIntLE() {
        return this.source.readUnsignedIntLE();
    }

    public long readLong() {
        return this.source.readLong();
    }

    public long readLongLE() {
        return this.source.readLongLE();
    }

    public char readChar() {
        return this.source.readChar();
    }

    public float readFloat() {
        return this.source.readFloat();
    }

    public double readDouble() {
        return this.source.readDouble();
    }

    public ByteBuf readBytes(int var0) {
        return this.source.readBytes(var0);
    }

    public ByteBuf readSlice(int var0) {
        return this.source.readSlice(var0);
    }

    public ByteBuf readRetainedSlice(int var0) {
        return this.source.readRetainedSlice(var0);
    }

    public ByteBuf readBytes(ByteBuf var0) {
        return this.source.readBytes(var0);
    }

    public ByteBuf readBytes(ByteBuf var0, int var1) {
        return this.source.readBytes(var0, var1);
    }

    public ByteBuf readBytes(ByteBuf var0, int var1, int var2) {
        return this.source.readBytes(var0, var1, var2);
    }

    public ByteBuf readBytes(byte[] var0) {
        return this.source.readBytes(var0);
    }

    public ByteBuf readBytes(byte[] var0, int var1, int var2) {
        return this.source.readBytes(var0, var1, var2);
    }

    public ByteBuf readBytes(ByteBuffer var0) {
        return this.source.readBytes(var0);
    }

    public ByteBuf readBytes(OutputStream var0, int var1) throws IOException {
        return this.source.readBytes(var0, var1);
    }

    public int readBytes(GatheringByteChannel var0, int var1) throws IOException {
        return this.source.readBytes(var0, var1);
    }

    public CharSequence readCharSequence(int var0, Charset var1) {
        return this.source.readCharSequence(var0, var1);
    }

    public int readBytes(FileChannel var0, long var1, int var3) throws IOException {
        return this.source.readBytes(var0, var1, var3);
    }

    public ByteBuf skipBytes(int var0) {
        return this.source.skipBytes(var0);
    }

    public ByteBuf writeBoolean(boolean var0) {
        return this.source.writeBoolean(var0);
    }

    public ByteBuf writeByte(int var0) {
        return this.source.writeByte(var0);
    }

    public ByteBuf writeShort(int var0) {
        return this.source.writeShort(var0);
    }

    public ByteBuf writeShortLE(int var0) {
        return this.source.writeShortLE(var0);
    }

    public ByteBuf writeMedium(int var0) {
        return this.source.writeMedium(var0);
    }

    public ByteBuf writeMediumLE(int var0) {
        return this.source.writeMediumLE(var0);
    }

    public ByteBuf writeInt(int var0) {
        return this.source.writeInt(var0);
    }

    public ByteBuf writeIntLE(int var0) {
        return this.source.writeIntLE(var0);
    }

    public ByteBuf writeLong(long var0) {
        return this.source.writeLong(var0);
    }

    public ByteBuf writeLongLE(long var0) {
        return this.source.writeLongLE(var0);
    }

    public ByteBuf writeChar(int var0) {
        return this.source.writeChar(var0);
    }

    public ByteBuf writeFloat(float var0) {
        return this.source.writeFloat(var0);
    }

    public ByteBuf writeDouble(double var0) {
        return this.source.writeDouble(var0);
    }

    public ByteBuf writeBytes(ByteBuf var0) {
        return this.source.writeBytes(var0);
    }

    public ByteBuf writeBytes(ByteBuf var0, int var1) {
        return this.source.writeBytes(var0, var1);
    }

    public ByteBuf writeBytes(ByteBuf var0, int var1, int var2) {
        return this.source.writeBytes(var0, var1, var2);
    }

    public ByteBuf writeBytes(byte[] var0) {
        return this.source.writeBytes(var0);
    }

    public ByteBuf writeBytes(byte[] var0, int var1, int var2) {
        return this.source.writeBytes(var0, var1, var2);
    }

    public ByteBuf writeBytes(ByteBuffer var0) {
        return this.source.writeBytes(var0);
    }

    public int writeBytes(InputStream var0, int var1) throws IOException {
        return this.source.writeBytes(var0, var1);
    }

    public int writeBytes(ScatteringByteChannel var0, int var1) throws IOException {
        return this.source.writeBytes(var0, var1);
    }

    public int writeBytes(FileChannel var0, long var1, int var3) throws IOException {
        return this.source.writeBytes(var0, var1, var3);
    }

    public ByteBuf writeZero(int var0) {
        return this.source.writeZero(var0);
    }

    public int writeCharSequence(CharSequence var0, Charset var1) {
        return this.source.writeCharSequence(var0, var1);
    }

    public int indexOf(int var0, int var1, byte var2) {
        return this.source.indexOf(var0, var1, var2);
    }

    public int bytesBefore(byte var0) {
        return this.source.bytesBefore(var0);
    }

    public int bytesBefore(int var0, byte var1) {
        return this.source.bytesBefore(var0, var1);
    }

    public int bytesBefore(int var0, int var1, byte var2) {
        return this.source.bytesBefore(var0, var1, var2);
    }

    public int forEachByte(ByteProcessor var0) {
        return this.source.forEachByte(var0);
    }

    public int forEachByte(int var0, int var1, ByteProcessor var2) {
        return this.source.forEachByte(var0, var1, var2);
    }

    public int forEachByteDesc(ByteProcessor var0) {
        return this.source.forEachByteDesc(var0);
    }

    public int forEachByteDesc(int var0, int var1, ByteProcessor var2) {
        return this.source.forEachByteDesc(var0, var1, var2);
    }

    public ByteBuf copy() {
        return this.source.copy();
    }

    public ByteBuf copy(int var0, int var1) {
        return this.source.copy(var0, var1);
    }

    public ByteBuf slice() {
        return this.source.slice();
    }

    public ByteBuf retainedSlice() {
        return this.source.retainedSlice();
    }

    public ByteBuf slice(int var0, int var1) {
        return this.source.slice(var0, var1);
    }

    public ByteBuf retainedSlice(int var0, int var1) {
        return this.source.retainedSlice(var0, var1);
    }

    public ByteBuf duplicate() {
        return this.source.duplicate();
    }

    public ByteBuf retainedDuplicate() {
        return this.source.retainedDuplicate();
    }

    public int nioBufferCount() {
        return this.source.nioBufferCount();
    }

    public ByteBuffer nioBuffer() {
        return this.source.nioBuffer();
    }

    public ByteBuffer nioBuffer(int var0, int var1) {
        return this.source.nioBuffer(var0, var1);
    }

    public ByteBuffer internalNioBuffer(int var0, int var1) {
        return this.source.internalNioBuffer(var0, var1);
    }

    public ByteBuffer[] nioBuffers() {
        return this.source.nioBuffers();
    }

    public ByteBuffer[] nioBuffers(int var0, int var1) {
        return this.source.nioBuffers(var0, var1);
    }

    public boolean hasArray() {
        return this.source.hasArray();
    }

    public byte[] array() {
        return this.source.array();
    }

    public int arrayOffset() {
        return this.source.arrayOffset();
    }

    public boolean hasMemoryAddress() {
        return this.source.hasMemoryAddress();
    }

    public long memoryAddress() {
        return this.source.memoryAddress();
    }

    public String toString(Charset var0) {
        return this.source.toString(var0);
    }

    public String toString(int var0, int var1, Charset var2) {
        return this.source.toString(var0, var1, var2);
    }

    public int hashCode() {
        return this.source.hashCode();
    }

    public boolean equals(Object var0) {
        return this.source.equals(var0);
    }

    public int compareTo(ByteBuf var0) {
        return this.source.compareTo(var0);
    }

    public String toString() {
        return this.source.toString();
    }

    public ByteBuf retain(int var0) {
        return this.source.retain(var0);
    }

    public ByteBuf retain() {
        return this.source.retain();
    }

    public ByteBuf touch() {
        return this.source.touch();
    }

    public ByteBuf touch(Object var0) {
        return this.source.touch(var0);
    }

    public int refCnt() {
        return this.source.refCnt();
    }

    public boolean release() {
        return this.source.release();
    }

    public boolean release(int var0) {
        return this.source.release(var0);
    }

    @FunctionalInterface
    public static interface b<T>
    extends BiConsumer<PacketDataSerializer, T> {
        default public b<Optional<T>> asOptional() {
            return (var0, var1) -> var0.writeOptional(var1, this);
        }
    }

    @FunctionalInterface
    public static interface a<T>
    extends Function<PacketDataSerializer, T> {
        default public a<Optional<T>> asOptional() {
            return var0 -> var0.readOptional(this);
        }
    }
}

