/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToByteEncoder;
import java.util.zip.Deflater;
import net.minecraft.network.PacketDataSerializer;

public class PacketCompressor
extends MessageToByteEncoder<ByteBuf> {
    private final byte[] encodeBuf = new byte[8192];
    private final Deflater deflater;
    private int threshold;

    public PacketCompressor(int var0) {
        this.threshold = var0;
        this.deflater = new Deflater();
    }

    protected void encode(ChannelHandlerContext var0, ByteBuf var1, ByteBuf var2) {
        int var3 = var1.readableBytes();
        PacketDataSerializer var4 = new PacketDataSerializer(var2);
        if (var3 < this.threshold) {
            var4.writeVarInt(0);
            var4.writeBytes(var1);
        } else {
            byte[] var5 = new byte[var3];
            var1.readBytes(var5);
            var4.writeVarInt(var5.length);
            this.deflater.setInput(var5, 0, var3);
            this.deflater.finish();
            while (!this.deflater.finished()) {
                int var6 = this.deflater.deflate(this.encodeBuf);
                var4.writeBytes(this.encodeBuf, 0, var6);
            }
            this.deflater.reset();
        }
    }

    public int getThreshold() {
        return this.threshold;
    }

    public void setThreshold(int var0) {
        this.threshold = var0;
    }

    protected /* synthetic */ void encode(ChannelHandlerContext channelHandlerContext, Object object, ByteBuf byteBuf) throws Exception {
        this.encode(channelHandlerContext, (ByteBuf)object, byteBuf);
    }
}

