/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network;

import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.codec.MessageToMessageDecoder;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.protocol.BundlerInfo;
import net.minecraft.network.protocol.EnumProtocolDirection;
import net.minecraft.network.protocol.Packet;

public class PacketBundlePacker
extends MessageToMessageDecoder<Packet<?>> {
    @Nullable
    private BundlerInfo.a currentBundler;
    @Nullable
    private BundlerInfo infoForCurrentBundler;
    private final EnumProtocolDirection flow;

    public PacketBundlePacker(EnumProtocolDirection var0) {
        this.flow = var0;
    }

    protected void decode(ChannelHandlerContext var0, Packet<?> var1, List<Object> var2) throws Exception {
        BundlerInfo.b var3 = (BundlerInfo.b)var0.channel().attr(BundlerInfo.BUNDLER_PROVIDER).get();
        if (var3 == null) {
            throw new DecoderException("Bundler not configured: " + var1);
        }
        BundlerInfo var4 = var3.getBundlerInfo(this.flow);
        if (this.currentBundler != null) {
            if (this.infoForCurrentBundler != var4) {
                throw new DecoderException("Bundler handler changed during bundling");
            }
            Packet<?> var5 = this.currentBundler.addPacket(var1);
            if (var5 != null) {
                this.infoForCurrentBundler = null;
                this.currentBundler = null;
                var2.add(var5);
            }
        } else {
            BundlerInfo.a var5 = var4.startPacketBundling(var1);
            if (var5 != null) {
                this.currentBundler = var5;
                this.infoForCurrentBundler = var4;
            } else {
                var2.add(var1);
            }
        }
    }

    protected /* synthetic */ void decode(ChannelHandlerContext channelHandlerContext, Object object, List list) throws Exception {
        this.decode(channelHandlerContext, (Packet)object, (List<Object>)list);
    }
}

