/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt;

import it.unimi.dsi.fastutil.longs.LongSet;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTList;
import net.minecraft.nbt.NBTNumber;
import net.minecraft.nbt.NBTReadLimiter;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.nbt.NBTTagType;
import net.minecraft.nbt.StreamTagVisitor;
import net.minecraft.nbt.TagVisitor;
import org.apache.commons.lang3.ArrayUtils;

public class NBTTagLongArray
extends NBTList<NBTTagLong> {
    private static final int SELF_SIZE_IN_BYTES = 24;
    public static final NBTTagType<NBTTagLongArray> TYPE = new NBTTagType.b<NBTTagLongArray>(){

        @Override
        public NBTTagLongArray load(DataInput var0, int var1, NBTReadLimiter var2) throws IOException {
            var2.accountBytes(24L);
            int var3 = var0.readInt();
            var2.accountBytes(8L * (long)var3);
            long[] var4 = new long[var3];
            for (int var5 = 0; var5 < var3; ++var5) {
                var4[var5] = var0.readLong();
            }
            return new NBTTagLongArray(var4);
        }

        @Override
        public StreamTagVisitor.b parse(DataInput var0, StreamTagVisitor var1) throws IOException {
            int var2 = var0.readInt();
            long[] var3 = new long[var2];
            for (int var4 = 0; var4 < var2; ++var4) {
                var3[var4] = var0.readLong();
            }
            return var1.visit(var3);
        }

        @Override
        public void skip(DataInput var0) throws IOException {
            var0.skipBytes(var0.readInt() * 8);
        }

        @Override
        public String getName() {
            return "LONG[]";
        }

        @Override
        public String getPrettyName() {
            return "TAG_Long_Array";
        }

        @Override
        public /* synthetic */ NBTBase load(DataInput dataInput, int n2, NBTReadLimiter nBTReadLimiter) throws IOException {
            return this.load(dataInput, n2, nBTReadLimiter);
        }
    };
    private long[] data;

    public NBTTagLongArray(long[] var0) {
        this.data = var0;
    }

    public NBTTagLongArray(LongSet var0) {
        this.data = var0.toLongArray();
    }

    public NBTTagLongArray(List<Long> var0) {
        this(NBTTagLongArray.toArray(var0));
    }

    private static long[] toArray(List<Long> var0) {
        long[] var1 = new long[var0.size()];
        for (int var2 = 0; var2 < var0.size(); ++var2) {
            Long var3 = var0.get(var2);
            var1[var2] = var3 == null ? 0L : var3;
        }
        return var1;
    }

    @Override
    public void write(DataOutput var0) throws IOException {
        var0.writeInt(this.data.length);
        for (long var4 : this.data) {
            var0.writeLong(var4);
        }
    }

    @Override
    public int sizeInBytes() {
        return 24 + 8 * this.data.length;
    }

    @Override
    public byte getId() {
        return 12;
    }

    public NBTTagType<NBTTagLongArray> getType() {
        return TYPE;
    }

    @Override
    public String toString() {
        return this.getAsString();
    }

    @Override
    public NBTTagLongArray copy() {
        long[] var0 = new long[this.data.length];
        System.arraycopy(this.data, 0, var0, 0, this.data.length);
        return new NBTTagLongArray(var0);
    }

    @Override
    public boolean equals(Object var0) {
        if (this == var0) {
            return true;
        }
        return var0 instanceof NBTTagLongArray && Arrays.equals(this.data, ((NBTTagLongArray)var0).data);
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.data);
    }

    @Override
    public void accept(TagVisitor var0) {
        var0.visitLongArray(this);
    }

    public long[] getAsLongArray() {
        return this.data;
    }

    @Override
    public int size() {
        return this.data.length;
    }

    @Override
    public NBTTagLong get(int var0) {
        return NBTTagLong.valueOf(this.data[var0]);
    }

    @Override
    public NBTTagLong set(int var0, NBTTagLong var1) {
        long var2 = this.data[var0];
        this.data[var0] = var1.getAsLong();
        return NBTTagLong.valueOf(var2);
    }

    @Override
    public void add(int var0, NBTTagLong var1) {
        this.data = ArrayUtils.add((long[])this.data, (int)var0, (long)var1.getAsLong());
    }

    @Override
    public boolean setTag(int var0, NBTBase var1) {
        if (var1 instanceof NBTNumber) {
            this.data[var0] = ((NBTNumber)var1).getAsLong();
            return true;
        }
        return false;
    }

    @Override
    public boolean addTag(int var0, NBTBase var1) {
        if (var1 instanceof NBTNumber) {
            this.data = ArrayUtils.add((long[])this.data, (int)var0, (long)((NBTNumber)var1).getAsLong());
            return true;
        }
        return false;
    }

    @Override
    public NBTTagLong remove(int var0) {
        long var1 = this.data[var0];
        this.data = ArrayUtils.remove((long[])this.data, (int)var0);
        return NBTTagLong.valueOf(var1);
    }

    @Override
    public byte getElementType() {
        return 4;
    }

    @Override
    public void clear() {
        this.data = new long[0];
    }

    @Override
    public StreamTagVisitor.b accept(StreamTagVisitor var0) {
        return var0.visit(this.data);
    }

    @Override
    public /* synthetic */ NBTBase remove(int n2) {
        return this.remove(n2);
    }

    @Override
    public /* synthetic */ void add(int n2, NBTBase nBTBase) {
        this.add(n2, (NBTTagLong)nBTBase);
    }

    @Override
    public /* synthetic */ NBTBase set(int n2, NBTBase nBTBase) {
        return this.set(n2, (NBTTagLong)nBTBase);
    }

    @Override
    public /* synthetic */ NBTBase copy() {
        return this.copy();
    }

    @Override
    public /* synthetic */ Object remove(int n2) {
        return this.remove(n2);
    }

    @Override
    public /* synthetic */ void add(int n2, Object object) {
        this.add(n2, (NBTTagLong)object);
    }

    @Override
    public /* synthetic */ Object set(int n2, Object object) {
        return this.set(n2, (NBTTagLong)object);
    }

    @Override
    public /* synthetic */ Object get(int n2) {
        return this.get(n2);
    }
}

