/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTNumber;
import net.minecraft.nbt.NBTReadLimiter;
import net.minecraft.nbt.NBTTagType;
import net.minecraft.nbt.StreamTagVisitor;
import net.minecraft.nbt.TagVisitor;
import net.minecraft.util.MathHelper;

public class NBTTagFloat
extends NBTNumber {
    private static final int SELF_SIZE_IN_BYTES = 12;
    public static final NBTTagFloat ZERO = new NBTTagFloat(0.0f);
    public static final NBTTagType<NBTTagFloat> TYPE = new NBTTagType.a<NBTTagFloat>(){

        @Override
        public NBTTagFloat load(DataInput var0, int var1, NBTReadLimiter var2) throws IOException {
            var2.accountBytes(12L);
            return NBTTagFloat.valueOf(var0.readFloat());
        }

        @Override
        public StreamTagVisitor.b parse(DataInput var0, StreamTagVisitor var1) throws IOException {
            return var1.visit(var0.readFloat());
        }

        @Override
        public int size() {
            return 4;
        }

        @Override
        public String getName() {
            return "FLOAT";
        }

        @Override
        public String getPrettyName() {
            return "TAG_Float";
        }

        @Override
        public boolean isValue() {
            return true;
        }

        @Override
        public /* synthetic */ NBTBase load(DataInput dataInput, int n2, NBTReadLimiter nBTReadLimiter) throws IOException {
            return this.load(dataInput, n2, nBTReadLimiter);
        }
    };
    private final float data;

    private NBTTagFloat(float var0) {
        this.data = var0;
    }

    public static NBTTagFloat valueOf(float var0) {
        if (var0 == 0.0f) {
            return ZERO;
        }
        return new NBTTagFloat(var0);
    }

    @Override
    public void write(DataOutput var0) throws IOException {
        var0.writeFloat(this.data);
    }

    @Override
    public int sizeInBytes() {
        return 12;
    }

    @Override
    public byte getId() {
        return 5;
    }

    public NBTTagType<NBTTagFloat> getType() {
        return TYPE;
    }

    @Override
    public NBTTagFloat copy() {
        return this;
    }

    public boolean equals(Object var0) {
        if (this == var0) {
            return true;
        }
        return var0 instanceof NBTTagFloat && this.data == ((NBTTagFloat)var0).data;
    }

    public int hashCode() {
        return Float.floatToIntBits(this.data);
    }

    @Override
    public void accept(TagVisitor var0) {
        var0.visitFloat(this);
    }

    @Override
    public long getAsLong() {
        return (long)this.data;
    }

    @Override
    public int getAsInt() {
        return MathHelper.floor(this.data);
    }

    @Override
    public short getAsShort() {
        return (short)(MathHelper.floor(this.data) & 0xFFFF);
    }

    @Override
    public byte getAsByte() {
        return (byte)(MathHelper.floor(this.data) & 0xFF);
    }

    @Override
    public double getAsDouble() {
        return this.data;
    }

    @Override
    public float getAsFloat() {
        return this.data;
    }

    @Override
    public Number getAsNumber() {
        return Float.valueOf(this.data);
    }

    @Override
    public StreamTagVisitor.b accept(StreamTagVisitor var0) {
        return var0.visit(this.data);
    }

    @Override
    public /* synthetic */ NBTBase copy() {
        return this.copy();
    }
}

