/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTNumber;
import net.minecraft.nbt.NBTReadLimiter;
import net.minecraft.nbt.NBTTagType;
import net.minecraft.nbt.StreamTagVisitor;
import net.minecraft.nbt.TagVisitor;

public class NBTTagByte
extends NBTNumber {
    private static final int SELF_SIZE_IN_BYTES = 9;
    public static final NBTTagType<NBTTagByte> TYPE = new NBTTagType.a<NBTTagByte>(){

        @Override
        public NBTTagByte load(DataInput var0, int var1, NBTReadLimiter var2) throws IOException {
            var2.accountBytes(9L);
            return NBTTagByte.valueOf(var0.readByte());
        }

        @Override
        public StreamTagVisitor.b parse(DataInput var0, StreamTagVisitor var1) throws IOException {
            return var1.visit(var0.readByte());
        }

        @Override
        public int size() {
            return 1;
        }

        @Override
        public String getName() {
            return "BYTE";
        }

        @Override
        public String getPrettyName() {
            return "TAG_Byte";
        }

        @Override
        public boolean isValue() {
            return true;
        }

        @Override
        public /* synthetic */ NBTBase load(DataInput dataInput, int n2, NBTReadLimiter nBTReadLimiter) throws IOException {
            return this.load(dataInput, n2, nBTReadLimiter);
        }
    };
    public static final NBTTagByte ZERO = NBTTagByte.valueOf((byte)0);
    public static final NBTTagByte ONE = NBTTagByte.valueOf((byte)1);
    private final byte data;

    NBTTagByte(byte var0) {
        this.data = var0;
    }

    public static NBTTagByte valueOf(byte var0) {
        return a.cache[128 + var0];
    }

    public static NBTTagByte valueOf(boolean var0) {
        return var0 ? ONE : ZERO;
    }

    @Override
    public void write(DataOutput var0) throws IOException {
        var0.writeByte(this.data);
    }

    @Override
    public int sizeInBytes() {
        return 9;
    }

    @Override
    public byte getId() {
        return 1;
    }

    public NBTTagType<NBTTagByte> getType() {
        return TYPE;
    }

    @Override
    public NBTTagByte copy() {
        return this;
    }

    public boolean equals(Object var0) {
        if (this == var0) {
            return true;
        }
        return var0 instanceof NBTTagByte && this.data == ((NBTTagByte)var0).data;
    }

    public int hashCode() {
        return this.data;
    }

    @Override
    public void accept(TagVisitor var0) {
        var0.visitByte(this);
    }

    @Override
    public long getAsLong() {
        return this.data;
    }

    @Override
    public int getAsInt() {
        return this.data;
    }

    @Override
    public short getAsShort() {
        return this.data;
    }

    @Override
    public byte getAsByte() {
        return this.data;
    }

    @Override
    public double getAsDouble() {
        return this.data;
    }

    @Override
    public float getAsFloat() {
        return this.data;
    }

    @Override
    public Number getAsNumber() {
        return this.data;
    }

    @Override
    public StreamTagVisitor.b accept(StreamTagVisitor var0) {
        return var0.visit(this.data);
    }

    @Override
    public /* synthetic */ NBTBase copy() {
        return this.copy();
    }

    static class a {
        static final NBTTagByte[] cache = new NBTTagByte[256];

        private a() {
        }

        static {
            for (int var0 = 0; var0 < cache.length; ++var0) {
                a.cache[var0] = new NBTTagByte((byte)(var0 - 128));
            }
        }
    }
}

