/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.particles;

import com.mojang.serialization.Codec;
import java.util.function.Function;
import net.minecraft.core.IRegistry;
import net.minecraft.core.particles.DustColorTransitionOptions;
import net.minecraft.core.particles.Particle;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.core.particles.ParticleParamBlock;
import net.minecraft.core.particles.ParticleParamItem;
import net.minecraft.core.particles.ParticleParamRedstone;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.SculkChargeParticleOptions;
import net.minecraft.core.particles.ShriekParticleOption;
import net.minecraft.core.particles.VibrationParticleOption;
import net.minecraft.core.registries.BuiltInRegistries;

public class Particles {
    public static final ParticleType AMBIENT_ENTITY_EFFECT = Particles.register("ambient_entity_effect", false);
    public static final ParticleType ANGRY_VILLAGER = Particles.register("angry_villager", false);
    public static final Particle<ParticleParamBlock> BLOCK = Particles.register("block", false, ParticleParamBlock.DESERIALIZER, ParticleParamBlock::codec);
    public static final Particle<ParticleParamBlock> BLOCK_MARKER = Particles.register("block_marker", false, ParticleParamBlock.DESERIALIZER, ParticleParamBlock::codec);
    public static final ParticleType BUBBLE = Particles.register("bubble", false);
    public static final ParticleType CLOUD = Particles.register("cloud", false);
    public static final ParticleType CRIT = Particles.register("crit", false);
    public static final ParticleType DAMAGE_INDICATOR = Particles.register("damage_indicator", true);
    public static final ParticleType DRAGON_BREATH = Particles.register("dragon_breath", false);
    public static final ParticleType DRIPPING_LAVA = Particles.register("dripping_lava", false);
    public static final ParticleType FALLING_LAVA = Particles.register("falling_lava", false);
    public static final ParticleType LANDING_LAVA = Particles.register("landing_lava", false);
    public static final ParticleType DRIPPING_WATER = Particles.register("dripping_water", false);
    public static final ParticleType FALLING_WATER = Particles.register("falling_water", false);
    public static final Particle<ParticleParamRedstone> DUST = Particles.register("dust", false, ParticleParamRedstone.DESERIALIZER, var0 -> ParticleParamRedstone.CODEC);
    public static final Particle<DustColorTransitionOptions> DUST_COLOR_TRANSITION = Particles.register("dust_color_transition", false, DustColorTransitionOptions.DESERIALIZER, var0 -> DustColorTransitionOptions.CODEC);
    public static final ParticleType EFFECT = Particles.register("effect", false);
    public static final ParticleType ELDER_GUARDIAN = Particles.register("elder_guardian", true);
    public static final ParticleType ENCHANTED_HIT = Particles.register("enchanted_hit", false);
    public static final ParticleType ENCHANT = Particles.register("enchant", false);
    public static final ParticleType END_ROD = Particles.register("end_rod", false);
    public static final ParticleType ENTITY_EFFECT = Particles.register("entity_effect", false);
    public static final ParticleType EXPLOSION_EMITTER = Particles.register("explosion_emitter", true);
    public static final ParticleType EXPLOSION = Particles.register("explosion", true);
    public static final ParticleType SONIC_BOOM = Particles.register("sonic_boom", true);
    public static final Particle<ParticleParamBlock> FALLING_DUST = Particles.register("falling_dust", false, ParticleParamBlock.DESERIALIZER, ParticleParamBlock::codec);
    public static final ParticleType FIREWORK = Particles.register("firework", false);
    public static final ParticleType FISHING = Particles.register("fishing", false);
    public static final ParticleType FLAME = Particles.register("flame", false);
    public static final ParticleType CHERRY_LEAVES = Particles.register("cherry_leaves", false);
    public static final ParticleType SCULK_SOUL = Particles.register("sculk_soul", false);
    public static final Particle<SculkChargeParticleOptions> SCULK_CHARGE = Particles.register("sculk_charge", true, SculkChargeParticleOptions.DESERIALIZER, var0 -> SculkChargeParticleOptions.CODEC);
    public static final ParticleType SCULK_CHARGE_POP = Particles.register("sculk_charge_pop", true);
    public static final ParticleType SOUL_FIRE_FLAME = Particles.register("soul_fire_flame", false);
    public static final ParticleType SOUL = Particles.register("soul", false);
    public static final ParticleType FLASH = Particles.register("flash", false);
    public static final ParticleType HAPPY_VILLAGER = Particles.register("happy_villager", false);
    public static final ParticleType COMPOSTER = Particles.register("composter", false);
    public static final ParticleType HEART = Particles.register("heart", false);
    public static final ParticleType INSTANT_EFFECT = Particles.register("instant_effect", false);
    public static final Particle<ParticleParamItem> ITEM = Particles.register("item", false, ParticleParamItem.DESERIALIZER, ParticleParamItem::codec);
    public static final Particle<VibrationParticleOption> VIBRATION = Particles.register("vibration", true, VibrationParticleOption.DESERIALIZER, var0 -> VibrationParticleOption.CODEC);
    public static final ParticleType ITEM_SLIME = Particles.register("item_slime", false);
    public static final ParticleType ITEM_SNOWBALL = Particles.register("item_snowball", false);
    public static final ParticleType LARGE_SMOKE = Particles.register("large_smoke", false);
    public static final ParticleType LAVA = Particles.register("lava", false);
    public static final ParticleType MYCELIUM = Particles.register("mycelium", false);
    public static final ParticleType NOTE = Particles.register("note", false);
    public static final ParticleType POOF = Particles.register("poof", true);
    public static final ParticleType PORTAL = Particles.register("portal", false);
    public static final ParticleType RAIN = Particles.register("rain", false);
    public static final ParticleType SMOKE = Particles.register("smoke", false);
    public static final ParticleType SNEEZE = Particles.register("sneeze", false);
    public static final ParticleType SPIT = Particles.register("spit", true);
    public static final ParticleType SQUID_INK = Particles.register("squid_ink", true);
    public static final ParticleType SWEEP_ATTACK = Particles.register("sweep_attack", true);
    public static final ParticleType TOTEM_OF_UNDYING = Particles.register("totem_of_undying", false);
    public static final ParticleType UNDERWATER = Particles.register("underwater", false);
    public static final ParticleType SPLASH = Particles.register("splash", false);
    public static final ParticleType WITCH = Particles.register("witch", false);
    public static final ParticleType BUBBLE_POP = Particles.register("bubble_pop", false);
    public static final ParticleType CURRENT_DOWN = Particles.register("current_down", false);
    public static final ParticleType BUBBLE_COLUMN_UP = Particles.register("bubble_column_up", false);
    public static final ParticleType NAUTILUS = Particles.register("nautilus", false);
    public static final ParticleType DOLPHIN = Particles.register("dolphin", false);
    public static final ParticleType CAMPFIRE_COSY_SMOKE = Particles.register("campfire_cosy_smoke", true);
    public static final ParticleType CAMPFIRE_SIGNAL_SMOKE = Particles.register("campfire_signal_smoke", true);
    public static final ParticleType DRIPPING_HONEY = Particles.register("dripping_honey", false);
    public static final ParticleType FALLING_HONEY = Particles.register("falling_honey", false);
    public static final ParticleType LANDING_HONEY = Particles.register("landing_honey", false);
    public static final ParticleType FALLING_NECTAR = Particles.register("falling_nectar", false);
    public static final ParticleType FALLING_SPORE_BLOSSOM = Particles.register("falling_spore_blossom", false);
    public static final ParticleType ASH = Particles.register("ash", false);
    public static final ParticleType CRIMSON_SPORE = Particles.register("crimson_spore", false);
    public static final ParticleType WARPED_SPORE = Particles.register("warped_spore", false);
    public static final ParticleType SPORE_BLOSSOM_AIR = Particles.register("spore_blossom_air", false);
    public static final ParticleType DRIPPING_OBSIDIAN_TEAR = Particles.register("dripping_obsidian_tear", false);
    public static final ParticleType FALLING_OBSIDIAN_TEAR = Particles.register("falling_obsidian_tear", false);
    public static final ParticleType LANDING_OBSIDIAN_TEAR = Particles.register("landing_obsidian_tear", false);
    public static final ParticleType REVERSE_PORTAL = Particles.register("reverse_portal", false);
    public static final ParticleType WHITE_ASH = Particles.register("white_ash", false);
    public static final ParticleType SMALL_FLAME = Particles.register("small_flame", false);
    public static final ParticleType SNOWFLAKE = Particles.register("snowflake", false);
    public static final ParticleType DRIPPING_DRIPSTONE_LAVA = Particles.register("dripping_dripstone_lava", false);
    public static final ParticleType FALLING_DRIPSTONE_LAVA = Particles.register("falling_dripstone_lava", false);
    public static final ParticleType DRIPPING_DRIPSTONE_WATER = Particles.register("dripping_dripstone_water", false);
    public static final ParticleType FALLING_DRIPSTONE_WATER = Particles.register("falling_dripstone_water", false);
    public static final ParticleType GLOW_SQUID_INK = Particles.register("glow_squid_ink", true);
    public static final ParticleType GLOW = Particles.register("glow", true);
    public static final ParticleType WAX_ON = Particles.register("wax_on", true);
    public static final ParticleType WAX_OFF = Particles.register("wax_off", true);
    public static final ParticleType ELECTRIC_SPARK = Particles.register("electric_spark", true);
    public static final ParticleType SCRAPE = Particles.register("scrape", true);
    public static final Particle<ShriekParticleOption> SHRIEK = Particles.register("shriek", false, ShriekParticleOption.DESERIALIZER, var0 -> ShriekParticleOption.CODEC);
    public static final ParticleType EGG_CRACK = Particles.register("egg_crack", false);
    public static final Codec<ParticleParam> CODEC = BuiltInRegistries.PARTICLE_TYPE.byNameCodec().dispatch("type", ParticleParam::getType, Particle::codec);

    private static ParticleType register(String var0, boolean var1) {
        return IRegistry.register(BuiltInRegistries.PARTICLE_TYPE, var0, new ParticleType(var1));
    }

    private static <T extends ParticleParam> Particle<T> register(String var0, boolean var1, ParticleParam.a<T> var2, final Function<Particle<T>, Codec<T>> var3) {
        return IRegistry.register(BuiltInRegistries.PARTICLE_TYPE, var0, new Particle<T>(var1, var2){

            @Override
            public Codec<T> codec() {
                return (Codec)var3.apply(this);
            }
        });
    }
}

