/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands;

import com.google.common.collect.Lists;
import com.mojang.brigadier.ParseResults;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.commands.CommandDispatcher;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.CustomFunctionData;

public class CustomFunction {
    private final c[] entries;
    final MinecraftKey id;

    public CustomFunction(MinecraftKey var0, c[] var1) {
        this.id = var0;
        this.entries = var1;
    }

    public MinecraftKey getId() {
        return this.id;
    }

    public c[] getEntries() {
        return this.entries;
    }

    public static CustomFunction fromLines(MinecraftKey var0, com.mojang.brigadier.CommandDispatcher<CommandListenerWrapper> var1, CommandListenerWrapper var2, List<String> var3) {
        ArrayList var4 = Lists.newArrayListWithCapacity((int)var3.size());
        for (int var5 = 0; var5 < var3.size(); ++var5) {
            Object var9;
            int var6 = var5 + 1;
            String var7 = var3.get(var5).trim();
            StringReader var8 = new StringReader(var7);
            if (!var8.canRead() || var8.peek() == '#') continue;
            if (var8.peek() == '/') {
                var8.skip();
                if (var8.peek() == '/') {
                    throw new IllegalArgumentException("Unknown or invalid command '" + var7 + "' on line " + var6 + " (if you intended to make a comment, use '#' not '//')");
                }
                var9 = var8.readUnquotedString();
                throw new IllegalArgumentException("Unknown or invalid command '" + var7 + "' on line " + var6 + " (did you mean '" + (String)var9 + "'? Do not use a preceding forwards slash.)");
            }
            try {
                var9 = var1.parse(var8, (Object)var2);
                if (var9.getReader().canRead()) {
                    throw CommandDispatcher.getParseException(var9);
                }
                var4.add(new b((ParseResults<CommandListenerWrapper>)var9));
                continue;
            }
            catch (CommandSyntaxException var92) {
                throw new IllegalArgumentException("Whilst parsing command on line " + var6 + ": " + var92.getMessage());
            }
        }
        return new CustomFunction(var0, var4.toArray(new c[0]));
    }

    @FunctionalInterface
    public static interface c {
        public void execute(CustomFunctionData var1, CommandListenerWrapper var2, Deque<CustomFunctionData.QueuedCommand> var3, int var4, int var5, @Nullable CustomFunctionData.TraceCallbacks var6) throws CommandSyntaxException;
    }

    public static class b
    implements c {
        private final ParseResults<CommandListenerWrapper> parse;

        public b(ParseResults<CommandListenerWrapper> var0) {
            this.parse = var0;
        }

        @Override
        public void execute(CustomFunctionData var0, CommandListenerWrapper var1, Deque<CustomFunctionData.QueuedCommand> var2, int var3, int var4, @Nullable CustomFunctionData.TraceCallbacks var5) throws CommandSyntaxException {
            if (var5 != null) {
                String var6 = this.parse.getReader().getString();
                var5.onCommand(var4, var6);
                int var7 = this.execute(var0, var1);
                var5.onReturn(var4, var6, var7);
            } else {
                this.execute(var0, var1);
            }
        }

        private int execute(CustomFunctionData var0, CommandListenerWrapper var12) throws CommandSyntaxException {
            return var0.getDispatcher().execute(CommandDispatcher.mapSource(this.parse, var1 -> var12));
        }

        public String toString() {
            return this.parse.getReader().getString();
        }
    }

    public static class a {
        public static final a NONE = new a((MinecraftKey)null);
        @Nullable
        private final MinecraftKey id;
        private boolean resolved;
        private Optional<CustomFunction> function = Optional.empty();

        public a(@Nullable MinecraftKey var0) {
            this.id = var0;
        }

        public a(CustomFunction var0) {
            this.resolved = true;
            this.id = null;
            this.function = Optional.of(var0);
        }

        public Optional<CustomFunction> get(CustomFunctionData var0) {
            if (!this.resolved) {
                if (this.id != null) {
                    this.function = var0.get(this.id);
                }
                this.resolved = true;
            }
            return this.function;
        }

        @Nullable
        public MinecraftKey getId() {
            return this.function.map(var0 -> var0.id).orElse(this.id);
        }
    }

    public static class d
    implements c {
        private final a function;

        public d(CustomFunction var0) {
            this.function = new a(var0);
        }

        @Override
        public void execute(CustomFunctionData var0, CommandListenerWrapper var1, Deque<CustomFunctionData.QueuedCommand> var2, int var3, int var4, @Nullable CustomFunctionData.TraceCallbacks var52) {
            SystemUtils.ifElse(this.function.get(var0), var5 -> {
                c[] var6 = var5.getEntries();
                if (var52 != null) {
                    var52.onCall(var4, var5.getId(), var6.length);
                }
                int var7 = var3 - var2.size();
                int var8 = Math.min(var6.length, var7);
                for (int var9 = var8 - 1; var9 >= 0; --var9) {
                    var2.addFirst(new CustomFunctionData.QueuedCommand(var1, var4 + 1, var6[var9]));
                }
            }, () -> {
                if (var52 != null) {
                    var52.onCall(var4, this.function.getId(), -1);
                }
            });
        }

        public String toString() {
            return "function " + this.function.getId();
        }
    }
}

