/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.critereon;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.util.ChatDeserializer;

public class TagPredicate<T> {
    private final TagKey<T> tag;
    private final boolean expected;

    public TagPredicate(TagKey<T> var0, boolean var1) {
        this.tag = var0;
        this.expected = var1;
    }

    public static <T> TagPredicate<T> is(TagKey<T> var0) {
        return new TagPredicate<T>(var0, true);
    }

    public static <T> TagPredicate<T> isNot(TagKey<T> var0) {
        return new TagPredicate<T>(var0, false);
    }

    public boolean matches(Holder<T> var0) {
        return var0.is(this.tag) == this.expected;
    }

    public JsonElement serializeToJson() {
        JsonObject var0 = new JsonObject();
        var0.addProperty("id", this.tag.location().toString());
        var0.addProperty("expected", Boolean.valueOf(this.expected));
        return var0;
    }

    public static <T> TagPredicate<T> fromJson(@Nullable JsonElement var0, ResourceKey<? extends IRegistry<T>> var1) {
        if (var0 == null) {
            throw new JsonParseException("Expected a tag predicate");
        }
        JsonObject var2 = ChatDeserializer.convertToJsonObject(var0, "Tag Predicate");
        MinecraftKey var3 = new MinecraftKey(ChatDeserializer.getAsString(var2, "id"));
        boolean var4 = ChatDeserializer.getAsBoolean(var2, "expected");
        return new TagPredicate(TagKey.create(var1, var3), var4);
    }
}

