/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.critereon;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.CriterionConditionItem;
import net.minecraft.advancements.critereon.CriterionInstanceAbstract;
import net.minecraft.advancements.critereon.CriterionTriggerAbstract;
import net.minecraft.advancements.critereon.LootDeserializationContext;
import net.minecraft.advancements.critereon.LootSerializationContext;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.util.ChatDeserializer;
import net.minecraft.world.item.ItemStack;

public class RecipeCraftedTrigger
extends CriterionTriggerAbstract<a> {
    static final MinecraftKey ID = new MinecraftKey("recipe_crafted");

    @Override
    public MinecraftKey getId() {
        return ID;
    }

    @Override
    protected a createInstance(JsonObject var0, ContextAwarePredicate var1, LootDeserializationContext var2) {
        MinecraftKey var3 = new MinecraftKey(ChatDeserializer.getAsString(var0, "recipe_id"));
        CriterionConditionItem[] var4 = CriterionConditionItem.fromJsonArray(var0.get("ingredients"));
        return new a(var1, var3, List.of(var4));
    }

    public void trigger(EntityPlayer var0, MinecraftKey var1, List<ItemStack> var22) {
        this.trigger(var0, var2 -> var2.matches(var1, var22));
    }

    @Override
    protected /* synthetic */ CriterionInstanceAbstract createInstance(JsonObject jsonObject, ContextAwarePredicate contextAwarePredicate, LootDeserializationContext lootDeserializationContext) {
        return this.createInstance(jsonObject, contextAwarePredicate, lootDeserializationContext);
    }

    public static class a
    extends CriterionInstanceAbstract {
        private final MinecraftKey recipeId;
        private final List<CriterionConditionItem> predicates;

        public a(ContextAwarePredicate var0, MinecraftKey var1, List<CriterionConditionItem> var2) {
            super(ID, var0);
            this.recipeId = var1;
            this.predicates = var2;
        }

        public static a craftedItem(MinecraftKey var0, List<CriterionConditionItem> var1) {
            return new a(ContextAwarePredicate.ANY, var0, var1);
        }

        public static a craftedItem(MinecraftKey var0) {
            return new a(ContextAwarePredicate.ANY, var0, List.of());
        }

        boolean matches(MinecraftKey var0, List<ItemStack> var1) {
            if (!var0.equals(this.recipeId)) {
                return false;
            }
            ArrayList<ItemStack> var2 = new ArrayList<ItemStack>(var1);
            for (CriterionConditionItem var4 : this.predicates) {
                boolean var5 = false;
                Iterator var6 = var2.iterator();
                while (var6.hasNext()) {
                    if (!var4.matches((ItemStack)var6.next())) continue;
                    var6.remove();
                    var5 = true;
                    break;
                }
                if (var5) continue;
                return false;
            }
            return true;
        }

        @Override
        public JsonObject serializeToJson(LootSerializationContext var0) {
            JsonObject var1 = super.serializeToJson(var0);
            var1.addProperty("recipe_id", this.recipeId.toString());
            if (this.predicates.size() > 0) {
                JsonArray var2 = new JsonArray();
                for (CriterionConditionItem var4 : this.predicates) {
                    var2.add(var4.serializeToJson());
                }
                var1.add("ingredients", (JsonElement)var2);
            }
            return var1;
        }
    }
}

