/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.critereon;

import com.google.gson.JsonObject;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.CriterionConditionEntity;
import net.minecraft.advancements.critereon.CriterionInstanceAbstract;
import net.minecraft.advancements.critereon.CriterionTriggerAbstract;
import net.minecraft.advancements.critereon.LootDeserializationContext;
import net.minecraft.advancements.critereon.LootSerializationContext;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLightning;
import net.minecraft.world.level.storage.loot.LootTableInfo;

public class LightningStrikeTrigger
extends CriterionTriggerAbstract<a> {
    static final MinecraftKey ID = new MinecraftKey("lightning_strike");

    @Override
    public MinecraftKey getId() {
        return ID;
    }

    @Override
    public a createInstance(JsonObject var0, ContextAwarePredicate var1, LootDeserializationContext var2) {
        ContextAwarePredicate var3 = CriterionConditionEntity.fromJson(var0, "lightning", var2);
        ContextAwarePredicate var4 = CriterionConditionEntity.fromJson(var0, "bystander", var2);
        return new a(var1, var3, var4);
    }

    public void trigger(EntityPlayer var0, EntityLightning var12, List<Entity> var22) {
        List var3 = var22.stream().map(var1 -> CriterionConditionEntity.createContext(var0, var1)).collect(Collectors.toList());
        LootTableInfo var4 = CriterionConditionEntity.createContext(var0, var12);
        this.trigger(var0, var2 -> var2.matches(var4, var3));
    }

    @Override
    public /* synthetic */ CriterionInstanceAbstract createInstance(JsonObject jsonObject, ContextAwarePredicate contextAwarePredicate, LootDeserializationContext lootDeserializationContext) {
        return this.createInstance(jsonObject, contextAwarePredicate, lootDeserializationContext);
    }

    public static class a
    extends CriterionInstanceAbstract {
        private final ContextAwarePredicate lightning;
        private final ContextAwarePredicate bystander;

        public a(ContextAwarePredicate var0, ContextAwarePredicate var1, ContextAwarePredicate var2) {
            super(ID, var0);
            this.lightning = var1;
            this.bystander = var2;
        }

        public static a lighthingStrike(CriterionConditionEntity var0, CriterionConditionEntity var1) {
            return new a(ContextAwarePredicate.ANY, CriterionConditionEntity.wrap(var0), CriterionConditionEntity.wrap(var1));
        }

        public boolean matches(LootTableInfo var0, List<LootTableInfo> var1) {
            if (!this.lightning.matches(var0)) {
                return false;
            }
            if (this.bystander != ContextAwarePredicate.ANY) {
                if (var1.stream().noneMatch(this.bystander::matches)) {
                    return false;
                }
            }
            return true;
        }

        @Override
        public JsonObject serializeToJson(LootSerializationContext var0) {
            JsonObject var1 = super.serializeToJson(var0);
            var1.add("lightning", this.lightning.toJson(var0));
            var1.add("bystander", this.bystander.toJson(var0));
            return var1;
        }
    }
}

