/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.critereon;

import com.google.gson.JsonObject;
import javax.annotation.Nullable;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.CriterionInstanceAbstract;
import net.minecraft.advancements.critereon.CriterionTriggerAbstract;
import net.minecraft.advancements.critereon.LootDeserializationContext;
import net.minecraft.advancements.critereon.LootSerializationContext;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.util.ChatDeserializer;
import net.minecraft.world.level.World;

public class CriterionTriggerChangedDimension
extends CriterionTriggerAbstract<a> {
    static final MinecraftKey ID = new MinecraftKey("changed_dimension");

    @Override
    public MinecraftKey getId() {
        return ID;
    }

    @Override
    public a createInstance(JsonObject var0, ContextAwarePredicate var1, LootDeserializationContext var2) {
        ResourceKey<World> var3 = var0.has("from") ? ResourceKey.create(Registries.DIMENSION, new MinecraftKey(ChatDeserializer.getAsString(var0, "from"))) : null;
        ResourceKey<World> var4 = var0.has("to") ? ResourceKey.create(Registries.DIMENSION, new MinecraftKey(ChatDeserializer.getAsString(var0, "to"))) : null;
        return new a(var1, var3, var4);
    }

    public void trigger(EntityPlayer var0, ResourceKey<World> var1, ResourceKey<World> var22) {
        this.trigger(var0, var2 -> var2.matches(var1, var22));
    }

    @Override
    public /* synthetic */ CriterionInstanceAbstract createInstance(JsonObject jsonObject, ContextAwarePredicate contextAwarePredicate, LootDeserializationContext lootDeserializationContext) {
        return this.createInstance(jsonObject, contextAwarePredicate, lootDeserializationContext);
    }

    public static class a
    extends CriterionInstanceAbstract {
        @Nullable
        private final ResourceKey<World> from;
        @Nullable
        private final ResourceKey<World> to;

        public a(ContextAwarePredicate var0, @Nullable ResourceKey<World> var1, @Nullable ResourceKey<World> var2) {
            super(ID, var0);
            this.from = var1;
            this.to = var2;
        }

        public static a changedDimension() {
            return new a(ContextAwarePredicate.ANY, null, null);
        }

        public static a changedDimension(ResourceKey<World> var0, ResourceKey<World> var1) {
            return new a(ContextAwarePredicate.ANY, var0, var1);
        }

        public static a changedDimensionTo(ResourceKey<World> var0) {
            return new a(ContextAwarePredicate.ANY, null, var0);
        }

        public static a changedDimensionFrom(ResourceKey<World> var0) {
            return new a(ContextAwarePredicate.ANY, var0, null);
        }

        public boolean matches(ResourceKey<World> var0, ResourceKey<World> var1) {
            if (this.from != null && this.from != var0) {
                return false;
            }
            return this.to == null || this.to == var1;
        }

        @Override
        public JsonObject serializeToJson(LootSerializationContext var0) {
            JsonObject var1 = super.serializeToJson(var0);
            if (this.from != null) {
                var1.addProperty("from", this.from.location().toString());
            }
            if (this.to != null) {
                var1.addProperty("to", this.to.location().toString());
            }
            return var1;
        }
    }
}

