/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.critereon;

import com.google.common.collect.Maps;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.advancements.CriterionProgress;
import net.minecraft.advancements.critereon.CriterionConditionEntity;
import net.minecraft.advancements.critereon.CriterionConditionValue;
import net.minecraft.advancements.critereon.EntitySubPredicate;
import net.minecraft.core.IRegistry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.AdvancementDataPlayer;
import net.minecraft.server.AdvancementDataWorld;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.stats.RecipeBookServer;
import net.minecraft.stats.ServerStatisticManager;
import net.minecraft.stats.Statistic;
import net.minecraft.stats.StatisticWrapper;
import net.minecraft.util.ChatDeserializer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.ProjectileHelper;
import net.minecraft.world.level.EnumGamemode;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionEntity;
import net.minecraft.world.phys.Vec3D;

public class CriterionConditionPlayer
implements EntitySubPredicate {
    public static final int LOOKING_AT_RANGE = 100;
    private final CriterionConditionValue.IntegerRange level;
    @Nullable
    private final EnumGamemode gameType;
    private final Map<Statistic<?>, CriterionConditionValue.IntegerRange> stats;
    private final Object2BooleanMap<MinecraftKey> recipes;
    private final Map<MinecraftKey, c> advancements;
    private final CriterionConditionEntity lookingAt;

    private static c advancementPredicateFromJson(JsonElement var0) {
        if (var0.isJsonPrimitive()) {
            boolean var1 = var0.getAsBoolean();
            return new b(var1);
        }
        Object2BooleanOpenHashMap var1 = new Object2BooleanOpenHashMap();
        JsonObject var2 = ChatDeserializer.convertToJsonObject(var0, "criterion data");
        var2.entrySet().forEach(arg_0 -> CriterionConditionPlayer.a((Object2BooleanMap)var1, arg_0));
        return new a((Object2BooleanMap<String>)var1);
    }

    CriterionConditionPlayer(CriterionConditionValue.IntegerRange var0, @Nullable EnumGamemode var1, Map<Statistic<?>, CriterionConditionValue.IntegerRange> var2, Object2BooleanMap<MinecraftKey> var3, Map<MinecraftKey, c> var4, CriterionConditionEntity var5) {
        this.level = var0;
        this.gameType = var1;
        this.stats = var2;
        this.recipes = var3;
        this.advancements = var4;
        this.lookingAt = var5;
    }

    @Override
    public boolean matches(Entity var02, WorldServer var1, @Nullable Vec3D var2) {
        Object var10;
        if (!(var02 instanceof EntityPlayer)) {
            return false;
        }
        EntityPlayer var3 = (EntityPlayer)var02;
        if (!this.level.matches(var3.experienceLevel)) {
            return false;
        }
        if (this.gameType != null && this.gameType != var3.gameMode.getGameModeForPlayer()) {
            return false;
        }
        ServerStatisticManager var4 = var3.getStats();
        for (Map.Entry<Statistic<?>, CriterionConditionValue.IntegerRange> entry : this.stats.entrySet()) {
            int var7 = var4.getValue(entry.getKey());
            if (entry.getValue().matches(var7)) continue;
            return false;
        }
        RecipeBookServer var5 = var3.getRecipeBook();
        for (Object2BooleanMap.Entry var7 : this.recipes.object2BooleanEntrySet()) {
            if (var5.contains((MinecraftKey)var7.getKey()) == var7.getBooleanValue()) continue;
            return false;
        }
        if (!this.advancements.isEmpty()) {
            AdvancementDataPlayer advancementDataPlayer = var3.getAdvancements();
            AdvancementDataWorld var7 = var3.getServer().getAdvancements();
            for (Map.Entry<MinecraftKey, c> entry : this.advancements.entrySet()) {
                var10 = var7.getAdvancement(entry.getKey());
                if (var10 != null && entry.getValue().test(advancementDataPlayer.getOrStartProgress((Advancement)var10))) continue;
                return false;
            }
        }
        if (this.lookingAt != CriterionConditionEntity.ANY) {
            Vec3D vec3D = var3.getEyePosition();
            Vec3D var7 = var3.getViewVector(1.0f);
            Vec3D var8 = vec3D.add(var7.x * 100.0, var7.y * 100.0, var7.z * 100.0);
            MovingObjectPositionEntity movingObjectPositionEntity = ProjectileHelper.getEntityHitResult(var3.level(), var3, vec3D, var8, new AxisAlignedBB(vec3D, var8).inflate(1.0), var0 -> !var0.isSpectator(), 0.0f);
            if (movingObjectPositionEntity == null || movingObjectPositionEntity.getType() != MovingObjectPosition.EnumMovingObjectType.ENTITY) {
                return false;
            }
            var10 = movingObjectPositionEntity.getEntity();
            if (!this.lookingAt.matches(var3, (Entity)var10) || !var3.hasLineOfSight((Entity)var10)) {
                return false;
            }
        }
        return true;
    }

    public static CriterionConditionPlayer fromJson(JsonObject var0) {
        Object var13;
        Object var12;
        StatisticWrapper<?> var10;
        Object var92;
        Object var8;
        JsonElement var72;
        CriterionConditionValue.IntegerRange var1 = CriterionConditionValue.IntegerRange.fromJson(var0.get("level"));
        String var2 = ChatDeserializer.getAsString(var0, "gamemode", "");
        EnumGamemode var3 = EnumGamemode.byName(var2, null);
        HashMap var4 = Maps.newHashMap();
        JsonArray var5 = ChatDeserializer.getAsJsonArray(var0, "stats", null);
        if (var5 != null) {
            for (JsonElement var72 : var5) {
                var8 = ChatDeserializer.convertToJsonObject(var72, "stats entry");
                var92 = new MinecraftKey(ChatDeserializer.getAsString((JsonObject)var8, "type"));
                var10 = BuiltInRegistries.STAT_TYPE.get((MinecraftKey)var92);
                if (var10 == null) {
                    throw new JsonParseException("Invalid stat type: " + (MinecraftKey)var92);
                }
                MinecraftKey var11 = new MinecraftKey(ChatDeserializer.getAsString((JsonObject)var8, "stat"));
                var12 = CriterionConditionPlayer.getStat(var10, var11);
                var13 = CriterionConditionValue.IntegerRange.fromJson(var8.get("value"));
                var4.put(var12, var13);
            }
        }
        Object2BooleanOpenHashMap var6 = new Object2BooleanOpenHashMap();
        var72 = ChatDeserializer.getAsJsonObject(var0, "recipes", new JsonObject());
        for (Object var92 : var72.entrySet()) {
            var10 = new MinecraftKey((String)var92.getKey());
            boolean var11 = ChatDeserializer.convertToBoolean((JsonElement)var92.getValue(), "recipe present");
            var6.put(var10, var11);
        }
        var8 = Maps.newHashMap();
        var92 = ChatDeserializer.getAsJsonObject(var0, "advancements", new JsonObject());
        for (Map.Entry var11 : var92.entrySet()) {
            var12 = new MinecraftKey((String)var11.getKey());
            var13 = CriterionConditionPlayer.advancementPredicateFromJson((JsonElement)var11.getValue());
            var8.put(var12, var13);
        }
        var10 = CriterionConditionEntity.fromJson(var0.get("looking_at"));
        return new CriterionConditionPlayer(var1, var3, var4, (Object2BooleanMap<MinecraftKey>)var6, (Map<MinecraftKey, c>)var8, (CriterionConditionEntity)((Object)var10));
    }

    private static <T> Statistic<T> getStat(StatisticWrapper<T> var0, MinecraftKey var1) {
        IRegistry<T> var2 = var0.getRegistry();
        T var3 = var2.get(var1);
        if (var3 == null) {
            throw new JsonParseException("Unknown object " + var1 + " for stat type " + BuiltInRegistries.STAT_TYPE.getKey(var0));
        }
        return var0.get(var3);
    }

    private static <T> MinecraftKey getStatValueId(Statistic<T> var0) {
        return var0.getType().getRegistry().getKey(var0.getValue());
    }

    @Override
    public JsonObject serializeCustomData() {
        JsonArray var12;
        JsonObject var0 = new JsonObject();
        var0.add("level", this.level.serializeToJson());
        if (this.gameType != null) {
            var0.addProperty("gamemode", this.gameType.getName());
        }
        if (!this.stats.isEmpty()) {
            var12 = new JsonArray();
            this.stats.forEach((var1, var2) -> {
                JsonObject var3 = new JsonObject();
                var3.addProperty("type", BuiltInRegistries.STAT_TYPE.getKey(var1.getType()).toString());
                var3.addProperty("stat", CriterionConditionPlayer.getStatValueId(var1).toString());
                var3.add("value", var2.serializeToJson());
                var12.add((JsonElement)var3);
            });
            var0.add("stats", (JsonElement)var12);
        }
        if (!this.recipes.isEmpty()) {
            var12 = new JsonObject();
            this.recipes.forEach((arg_0, arg_1) -> CriterionConditionPlayer.a((JsonObject)var12, arg_0, arg_1));
            var0.add("recipes", (JsonElement)var12);
        }
        if (!this.advancements.isEmpty()) {
            var12 = new JsonObject();
            this.advancements.forEach((arg_0, arg_1) -> CriterionConditionPlayer.a((JsonObject)var12, arg_0, arg_1));
            var0.add("advancements", (JsonElement)var12);
        }
        var0.add("looking_at", this.lookingAt.serializeToJson());
        return var0;
    }

    @Override
    public EntitySubPredicate.a type() {
        return EntitySubPredicate.b.PLAYER;
    }

    private static /* synthetic */ void a(JsonObject var0, MinecraftKey var1, c var2) {
        var0.add(var1.toString(), var2.toJson());
    }

    private static /* synthetic */ void a(JsonObject var0, MinecraftKey var1, Boolean var2) {
        var0.addProperty(var1.toString(), var2);
    }

    private static /* synthetic */ void a(Object2BooleanMap var0, Map.Entry var1) {
        boolean var2 = ChatDeserializer.convertToBoolean((JsonElement)var1.getValue(), "criterion test");
        var0.put((Object)((String)var1.getKey()), var2);
    }

    static class b
    implements c {
        private final boolean state;

        public b(boolean var0) {
            this.state = var0;
        }

        @Override
        public JsonElement toJson() {
            return new JsonPrimitive(Boolean.valueOf(this.state));
        }

        @Override
        public boolean test(AdvancementProgress var0) {
            return var0.isDone() == this.state;
        }

        @Override
        public /* synthetic */ boolean test(Object object) {
            return this.test((AdvancementProgress)object);
        }
    }

    static class a
    implements c {
        private final Object2BooleanMap<String> criterions;

        public a(Object2BooleanMap<String> var0) {
            this.criterions = var0;
        }

        @Override
        public JsonElement toJson() {
            JsonObject var0 = new JsonObject();
            this.criterions.forEach((arg_0, arg_1) -> ((JsonObject)var0).addProperty(arg_0, arg_1));
            return var0;
        }

        @Override
        public boolean test(AdvancementProgress var0) {
            for (Object2BooleanMap.Entry var2 : this.criterions.object2BooleanEntrySet()) {
                CriterionProgress var3 = var0.getCriterion((String)var2.getKey());
                if (var3 != null && var3.isDone() == var2.getBooleanValue()) continue;
                return false;
            }
            return true;
        }

        @Override
        public /* synthetic */ boolean test(Object object) {
            return this.test((AdvancementProgress)object);
        }
    }

    static interface c
    extends Predicate<AdvancementProgress> {
        public JsonElement toJson();
    }

    public static class d {
        private CriterionConditionValue.IntegerRange level = CriterionConditionValue.IntegerRange.ANY;
        @Nullable
        private EnumGamemode gameType;
        private final Map<Statistic<?>, CriterionConditionValue.IntegerRange> stats = Maps.newHashMap();
        private final Object2BooleanMap<MinecraftKey> recipes = new Object2BooleanOpenHashMap();
        private final Map<MinecraftKey, c> advancements = Maps.newHashMap();
        private CriterionConditionEntity lookingAt = CriterionConditionEntity.ANY;

        public static d player() {
            return new d();
        }

        public d setLevel(CriterionConditionValue.IntegerRange var0) {
            this.level = var0;
            return this;
        }

        public d addStat(Statistic<?> var0, CriterionConditionValue.IntegerRange var1) {
            this.stats.put(var0, var1);
            return this;
        }

        public d addRecipe(MinecraftKey var0, boolean var1) {
            this.recipes.put((Object)var0, var1);
            return this;
        }

        public d setGameType(EnumGamemode var0) {
            this.gameType = var0;
            return this;
        }

        public d setLookingAt(CriterionConditionEntity var0) {
            this.lookingAt = var0;
            return this;
        }

        public d checkAdvancementDone(MinecraftKey var0, boolean var1) {
            this.advancements.put(var0, new b(var1));
            return this;
        }

        public d checkAdvancementCriterions(MinecraftKey var0, Map<String, Boolean> var1) {
            this.advancements.put(var0, new a((Object2BooleanMap<String>)new Object2BooleanOpenHashMap(var1)));
            return this;
        }

        public CriterionConditionPlayer build() {
            return new CriterionConditionPlayer(this.level, this.gameType, this.stats, this.recipes, this.advancements, this.lookingAt);
        }
    }
}

