/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.critereon;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.advancements.critereon.LootDeserializationContext;
import net.minecraft.advancements.critereon.LootSerializationContext;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameterSet;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditions;

public class ContextAwarePredicate {
    public static final ContextAwarePredicate ANY = new ContextAwarePredicate(new LootItemCondition[0]);
    private final LootItemCondition[] conditions;
    private final Predicate<LootTableInfo> compositePredicates;

    ContextAwarePredicate(LootItemCondition[] var0) {
        this.conditions = var0;
        this.compositePredicates = LootItemConditions.andConditions(var0);
    }

    public static ContextAwarePredicate create(LootItemCondition ... var0) {
        return new ContextAwarePredicate(var0);
    }

    @Nullable
    public static ContextAwarePredicate fromElement(String var0, LootDeserializationContext var1, @Nullable JsonElement var2, LootContextParameterSet var3) {
        if (var2 != null && var2.isJsonArray()) {
            LootItemCondition[] var4 = var1.deserializeConditions(var2.getAsJsonArray(), var1.getAdvancementId() + "/" + var0, var3);
            return new ContextAwarePredicate(var4);
        }
        return null;
    }

    public boolean matches(LootTableInfo var0) {
        return this.compositePredicates.test(var0);
    }

    public JsonElement toJson(LootSerializationContext var0) {
        if (this.conditions.length == 0) {
            return JsonNull.INSTANCE;
        }
        return var0.serializeConditions(this.conditions);
    }

    public static JsonElement toJson(ContextAwarePredicate[] var0, LootSerializationContext var1) {
        if (var0.length == 0) {
            return JsonNull.INSTANCE;
        }
        JsonArray var2 = new JsonArray();
        for (ContextAwarePredicate var6 : var0) {
            var2.add(var6.toJson(var1));
        }
        return var2;
    }
}

