/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.scores;

import java.util.Comparator;
import javax.annotation.Nullable;
import net.minecraft.world.scores.Scoreboard;
import net.minecraft.world.scores.ScoreboardObjective;

public class ScoreboardScore {
    public static final Comparator<ScoreboardScore> SCORE_COMPARATOR = (var0, var1) -> {
        if (var0.getScore() > var1.getScore()) {
            return 1;
        }
        if (var0.getScore() < var1.getScore()) {
            return -1;
        }
        return var1.getOwner().compareToIgnoreCase(var0.getOwner());
    };
    private final Scoreboard scoreboard;
    @Nullable
    private final ScoreboardObjective objective;
    private final String owner;
    private int count;
    private boolean locked;
    private boolean forceUpdate;

    public ScoreboardScore(Scoreboard var0, ScoreboardObjective var1, String var2) {
        this.scoreboard = var0;
        this.objective = var1;
        this.owner = var2;
        this.locked = true;
        this.forceUpdate = true;
    }

    public void add(int var0) {
        if (this.objective.getCriteria().isReadOnly()) {
            throw new IllegalStateException("Cannot modify read-only score");
        }
        this.setScore(this.getScore() + var0);
    }

    public void increment() {
        this.add(1);
    }

    public int getScore() {
        return this.count;
    }

    public void reset() {
        this.setScore(0);
    }

    public void setScore(int var0) {
        int var1 = this.count;
        this.count = var0;
        if (var1 != var0 || this.forceUpdate) {
            this.forceUpdate = false;
            this.getScoreboard().onScoreChanged(this);
        }
    }

    @Nullable
    public ScoreboardObjective getObjective() {
        return this.objective;
    }

    public String getOwner() {
        return this.owner;
    }

    public Scoreboard getScoreboard() {
        return this.scoreboard;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public void setLocked(boolean var0) {
        this.locked = var0;
    }
}

