/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.validation;

import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.level.validation.ForbiddenSymlinkInfo;
import net.minecraft.world.level.validation.PathAllowList;

public class DirectoryValidator {
    private final PathAllowList symlinkTargetAllowList;

    public DirectoryValidator(PathAllowList var0) {
        this.symlinkTargetAllowList = var0;
    }

    public void validateSymlink(Path var0, List<ForbiddenSymlinkInfo> var1) throws IOException {
        Path var2 = Files.readSymbolicLink(var0);
        if (!this.symlinkTargetAllowList.matches(var2)) {
            var1.add(new ForbiddenSymlinkInfo(var0, var2));
        }
    }

    public List<ForbiddenSymlinkInfo> validateSave(Path var0, boolean var1) throws IOException {
        BasicFileAttributes var3;
        final ArrayList<ForbiddenSymlinkInfo> var2 = new ArrayList<ForbiddenSymlinkInfo>();
        try {
            var3 = Files.readAttributes(var0, BasicFileAttributes.class, LinkOption.NOFOLLOW_LINKS);
        }
        catch (NoSuchFileException var4) {
            return var2;
        }
        if (var3.isRegularFile() || var3.isOther()) {
            throw new IOException("Path " + var0 + " is not a directory");
        }
        if (var3.isSymbolicLink()) {
            if (var1) {
                var0 = Files.readSymbolicLink(var0);
            } else {
                this.validateSymlink(var0, var2);
                return var2;
            }
        }
        Files.walkFileTree(var0, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            private void validateSymlink(Path var0, BasicFileAttributes var1) throws IOException {
                if (var1.isSymbolicLink()) {
                    DirectoryValidator.this.validateSymlink(var0, var2);
                }
            }

            @Override
            public FileVisitResult preVisitDirectory(Path var0, BasicFileAttributes var1) throws IOException {
                this.validateSymlink(var0, var1);
                return super.preVisitDirectory(var0, var1);
            }

            @Override
            public FileVisitResult visitFile(Path var0, BasicFileAttributes var1) throws IOException {
                this.validateSymlink(var0, var1);
                return super.visitFile(var0, var1);
            }

            @Override
            public /* synthetic */ FileVisitResult visitFile(Object object, BasicFileAttributes basicFileAttributes) throws IOException {
                return this.visitFile((Path)object, basicFileAttributes);
            }

            @Override
            public /* synthetic */ FileVisitResult preVisitDirectory(Object object, BasicFileAttributes basicFileAttributes) throws IOException {
                return this.preVisitDirectory((Path)object, basicFileAttributes);
            }
        });
        return var2;
    }
}

