/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.predicates;

import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.util.Set;
import net.minecraft.advancements.critereon.CriterionConditionItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootSerializer;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameter;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditions;

public class LootItemConditionMatchTool
implements LootItemCondition {
    final CriterionConditionItem predicate;

    public LootItemConditionMatchTool(CriterionConditionItem var0) {
        this.predicate = var0;
    }

    @Override
    public LootItemConditionType getType() {
        return LootItemConditions.MATCH_TOOL;
    }

    @Override
    public Set<LootContextParameter<?>> getReferencedContextParams() {
        return ImmutableSet.of(LootContextParameters.TOOL);
    }

    @Override
    public boolean test(LootTableInfo var0) {
        ItemStack var1 = var0.getParamOrNull(LootContextParameters.TOOL);
        return var1 != null && this.predicate.matches(var1);
    }

    public static LootItemCondition.a toolMatches(CriterionConditionItem.a var0) {
        return () -> new LootItemConditionMatchTool(var0.build());
    }

    @Override
    public /* synthetic */ boolean test(Object object) {
        return this.test((LootTableInfo)object);
    }

    public static class a
    implements LootSerializer<LootItemConditionMatchTool> {
        @Override
        public void serialize(JsonObject var0, LootItemConditionMatchTool var1, JsonSerializationContext var2) {
            var0.add("predicate", var1.predicate.serializeToJson());
        }

        @Override
        public LootItemConditionMatchTool deserialize(JsonObject var0, JsonDeserializationContext var1) {
            CriterionConditionItem var2 = CriterionConditionItem.fromJson(var0.get("predicate"));
            return new LootItemConditionMatchTool(var2);
        }

        @Override
        public /* synthetic */ Object deserialize(JsonObject jsonObject, JsonDeserializationContext jsonDeserializationContext) {
            return this.deserialize(jsonObject, jsonDeserializationContext);
        }
    }
}

