/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.predicates;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import net.minecraft.advancements.critereon.CriterionConditionLocation;
import net.minecraft.core.BlockPosition;
import net.minecraft.util.ChatDeserializer;
import net.minecraft.world.level.storage.loot.LootSerializer;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditions;
import net.minecraft.world.phys.Vec3D;

public class LootItemConditionLocationCheck
implements LootItemCondition {
    final CriterionConditionLocation predicate;
    final BlockPosition offset;

    LootItemConditionLocationCheck(CriterionConditionLocation var0, BlockPosition var1) {
        this.predicate = var0;
        this.offset = var1;
    }

    @Override
    public LootItemConditionType getType() {
        return LootItemConditions.LOCATION_CHECK;
    }

    @Override
    public boolean test(LootTableInfo var0) {
        Vec3D var1 = var0.getParamOrNull(LootContextParameters.ORIGIN);
        return var1 != null && this.predicate.matches(var0.getLevel(), var1.x() + (double)this.offset.getX(), var1.y() + (double)this.offset.getY(), var1.z() + (double)this.offset.getZ());
    }

    public static LootItemCondition.a checkLocation(CriterionConditionLocation.a var0) {
        return () -> new LootItemConditionLocationCheck(var0.build(), BlockPosition.ZERO);
    }

    public static LootItemCondition.a checkLocation(CriterionConditionLocation.a var0, BlockPosition var1) {
        return () -> new LootItemConditionLocationCheck(var0.build(), var1);
    }

    @Override
    public /* synthetic */ boolean test(Object object) {
        return this.test((LootTableInfo)object);
    }

    public static class a
    implements LootSerializer<LootItemConditionLocationCheck> {
        @Override
        public void serialize(JsonObject var0, LootItemConditionLocationCheck var1, JsonSerializationContext var2) {
            var0.add("predicate", var1.predicate.serializeToJson());
            if (var1.offset.getX() != 0) {
                var0.addProperty("offsetX", (Number)var1.offset.getX());
            }
            if (var1.offset.getY() != 0) {
                var0.addProperty("offsetY", (Number)var1.offset.getY());
            }
            if (var1.offset.getZ() != 0) {
                var0.addProperty("offsetZ", (Number)var1.offset.getZ());
            }
        }

        @Override
        public LootItemConditionLocationCheck deserialize(JsonObject var0, JsonDeserializationContext var1) {
            CriterionConditionLocation var2 = CriterionConditionLocation.fromJson(var0.get("predicate"));
            int var3 = ChatDeserializer.getAsInt(var0, "offsetX", 0);
            int var4 = ChatDeserializer.getAsInt(var0, "offsetY", 0);
            int var5 = ChatDeserializer.getAsInt(var0, "offsetZ", 0);
            return new LootItemConditionLocationCheck(var2, new BlockPosition(var3, var4, var5));
        }

        @Override
        public /* synthetic */ Object deserialize(JsonObject jsonObject, JsonDeserializationContext jsonDeserializationContext) {
            return this.deserialize(jsonObject, jsonDeserializationContext);
        }
    }
}

