/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.functions;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSyntaxException;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.ChatDeserializer;
import net.minecraft.world.item.EnumColor;
import net.minecraft.world.item.ItemBlock;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.EnumBannerPatternType;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionConditional;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class SetBannerPatternFunction
extends LootItemFunctionConditional {
    final List<Pair<Holder<EnumBannerPatternType>, EnumColor>> patterns;
    final boolean append;

    SetBannerPatternFunction(LootItemCondition[] var0, List<Pair<Holder<EnumBannerPatternType>, EnumColor>> var1, boolean var2) {
        super(var0);
        this.patterns = var1;
        this.append = var2;
    }

    @Override
    protected ItemStack run(ItemStack var0, LootTableInfo var1) {
        NBTTagList var5;
        NBTTagCompound var2 = ItemBlock.getBlockEntityData(var0);
        if (var2 == null) {
            var2 = new NBTTagCompound();
        }
        EnumBannerPatternType.a var3 = new EnumBannerPatternType.a();
        this.patterns.forEach(var3::addPattern);
        NBTTagList var4 = var3.toListTag();
        if (this.append) {
            var5 = var2.getList("Patterns", 10).copy();
            var5.addAll(var4);
        } else {
            var5 = var4;
        }
        var2.put("Patterns", var5);
        ItemBlock.setBlockEntityData(var0, TileEntityTypes.BANNER, var2);
        return var0;
    }

    @Override
    public LootItemFunctionType getType() {
        return LootItemFunctions.SET_BANNER_PATTERN;
    }

    public static a setBannerPattern(boolean var0) {
        return new a(var0);
    }

    public static class a
    extends LootItemFunctionConditional.a<a> {
        private final ImmutableList.Builder<Pair<Holder<EnumBannerPatternType>, EnumColor>> patterns = ImmutableList.builder();
        private final boolean append;

        a(boolean var0) {
            this.append = var0;
        }

        @Override
        protected a getThis() {
            return this;
        }

        @Override
        public LootItemFunction build() {
            return new SetBannerPatternFunction(this.getConditions(), (List<Pair<Holder<EnumBannerPatternType>, EnumColor>>)this.patterns.build(), this.append);
        }

        public a addPattern(ResourceKey<EnumBannerPatternType> var0, EnumColor var1) {
            return this.addPattern(BuiltInRegistries.BANNER_PATTERN.getHolderOrThrow(var0), var1);
        }

        public a addPattern(Holder<EnumBannerPatternType> var0, EnumColor var1) {
            this.patterns.add((Object)Pair.of(var0, (Object)var1));
            return this;
        }

        @Override
        protected /* synthetic */ LootItemFunctionConditional.a getThis() {
            return this.getThis();
        }
    }

    public static class b
    extends LootItemFunctionConditional.c<SetBannerPatternFunction> {
        @Override
        public void serialize(JsonObject var0, SetBannerPatternFunction var12, JsonSerializationContext var2) {
            super.serialize(var0, var12, var2);
            JsonArray var3 = new JsonArray();
            var12.patterns.forEach(var1 -> {
                JsonObject var2 = new JsonObject();
                var2.addProperty("pattern", ((Holder)var1.getFirst()).unwrapKey().orElseThrow(() -> new JsonSyntaxException("Unknown pattern: " + var1.getFirst())).location().toString());
                var2.addProperty("color", ((EnumColor)var1.getSecond()).getName());
                var3.add((JsonElement)var2);
            });
            var0.add("patterns", (JsonElement)var3);
            var0.addProperty("append", Boolean.valueOf(var12.append));
        }

        @Override
        public SetBannerPatternFunction deserialize(JsonObject var0, JsonDeserializationContext var1, LootItemCondition[] var2) {
            int var5;
            ImmutableList.Builder var3 = ImmutableList.builder();
            JsonArray var4 = ChatDeserializer.getAsJsonArray(var0, "patterns");
            for (var5 = 0; var5 < var4.size(); ++var5) {
                JsonObject var6 = ChatDeserializer.convertToJsonObject(var4.get(var5), "pattern[" + var5 + "]");
                String var7 = ChatDeserializer.getAsString(var6, "pattern");
                Optional<Holder.c<EnumBannerPatternType>> var8 = BuiltInRegistries.BANNER_PATTERN.getHolder(ResourceKey.create(Registries.BANNER_PATTERN, new MinecraftKey(var7)));
                if (var8.isEmpty()) {
                    throw new JsonSyntaxException("Unknown pattern: " + var7);
                }
                String var9 = ChatDeserializer.getAsString(var6, "color");
                EnumColor var10 = EnumColor.byName(var9, null);
                if (var10 == null) {
                    throw new JsonSyntaxException("Unknown color: " + var9);
                }
                var3.add((Object)Pair.of((Object)var8.get(), (Object)var10));
            }
            var5 = ChatDeserializer.getAsBoolean(var0, "append") ? 1 : 0;
            return new SetBannerPatternFunction(var2, (List<Pair<Holder<EnumBannerPatternType>, EnumColor>>)var3.build(), var5 != 0);
        }

        @Override
        public /* synthetic */ LootItemFunctionConditional deserialize(JsonObject jsonObject, JsonDeserializationContext jsonDeserializationContext, LootItemCondition[] lootItemConditionArray) {
            return this.deserialize(jsonObject, jsonDeserializationContext, lootItemConditionArray);
        }
    }
}

