/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.functions;

import java.util.function.BiFunction;
import net.minecraft.core.IRegistry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.JsonRegistry;
import net.minecraft.world.level.storage.loot.LootSerializer;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.functions.FunctionReference;
import net.minecraft.world.level.storage.loot.functions.LootEnchantFunction;
import net.minecraft.world.level.storage.loot.functions.LootEnchantLevel;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionApplyBonus;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionCopyNBT;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionCopyName;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionCopyState;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionEnchant;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionExplorationMap;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionExplosionDecay;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionFillPlayerHead;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionLimitCount;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionSetAttribute;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionSetContents;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionSetCount;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionSetDamage;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionSetLore;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionSetName;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionSetStewEffect;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionSetTable;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionSetTag;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionSmelt;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.functions.SetBannerPatternFunction;
import net.minecraft.world.level.storage.loot.functions.SetEnchantmentsFunction;
import net.minecraft.world.level.storage.loot.functions.SetInstrumentFunction;
import net.minecraft.world.level.storage.loot.functions.SetPotionFunction;

public class LootItemFunctions {
    public static final BiFunction<ItemStack, LootTableInfo, ItemStack> IDENTITY = (var0, var1) -> var0;
    public static final LootItemFunctionType SET_COUNT = LootItemFunctions.register("set_count", new LootItemFunctionSetCount.a());
    public static final LootItemFunctionType ENCHANT_WITH_LEVELS = LootItemFunctions.register("enchant_with_levels", new LootEnchantLevel.b());
    public static final LootItemFunctionType ENCHANT_RANDOMLY = LootItemFunctions.register("enchant_randomly", new LootItemFunctionEnchant.b());
    public static final LootItemFunctionType SET_ENCHANTMENTS = LootItemFunctions.register("set_enchantments", new SetEnchantmentsFunction.b());
    public static final LootItemFunctionType SET_NBT = LootItemFunctions.register("set_nbt", new LootItemFunctionSetTag.a());
    public static final LootItemFunctionType FURNACE_SMELT = LootItemFunctions.register("furnace_smelt", new LootItemFunctionSmelt.a());
    public static final LootItemFunctionType LOOTING_ENCHANT = LootItemFunctions.register("looting_enchant", new LootEnchantFunction.b());
    public static final LootItemFunctionType SET_DAMAGE = LootItemFunctions.register("set_damage", new LootItemFunctionSetDamage.a());
    public static final LootItemFunctionType SET_ATTRIBUTES = LootItemFunctions.register("set_attributes", new LootItemFunctionSetAttribute.d());
    public static final LootItemFunctionType SET_NAME = LootItemFunctions.register("set_name", new LootItemFunctionSetName.a());
    public static final LootItemFunctionType EXPLORATION_MAP = LootItemFunctions.register("exploration_map", new LootItemFunctionExplorationMap.b());
    public static final LootItemFunctionType SET_STEW_EFFECT = LootItemFunctions.register("set_stew_effect", new LootItemFunctionSetStewEffect.b());
    public static final LootItemFunctionType COPY_NAME = LootItemFunctions.register("copy_name", new LootItemFunctionCopyName.b());
    public static final LootItemFunctionType SET_CONTENTS = LootItemFunctions.register("set_contents", new LootItemFunctionSetContents.b());
    public static final LootItemFunctionType LIMIT_COUNT = LootItemFunctions.register("limit_count", new LootItemFunctionLimitCount.a());
    public static final LootItemFunctionType APPLY_BONUS = LootItemFunctions.register("apply_bonus", new LootItemFunctionApplyBonus.e());
    public static final LootItemFunctionType SET_LOOT_TABLE = LootItemFunctions.register("set_loot_table", new LootItemFunctionSetTable.a());
    public static final LootItemFunctionType EXPLOSION_DECAY = LootItemFunctions.register("explosion_decay", new LootItemFunctionExplosionDecay.a());
    public static final LootItemFunctionType SET_LORE = LootItemFunctions.register("set_lore", new LootItemFunctionSetLore.b());
    public static final LootItemFunctionType FILL_PLAYER_HEAD = LootItemFunctions.register("fill_player_head", new LootItemFunctionFillPlayerHead.a());
    public static final LootItemFunctionType COPY_NBT = LootItemFunctions.register("copy_nbt", new LootItemFunctionCopyNBT.d());
    public static final LootItemFunctionType COPY_STATE = LootItemFunctions.register("copy_state", new LootItemFunctionCopyState.b());
    public static final LootItemFunctionType SET_BANNER_PATTERN = LootItemFunctions.register("set_banner_pattern", new SetBannerPatternFunction.b());
    public static final LootItemFunctionType SET_POTION = LootItemFunctions.register("set_potion", new SetPotionFunction.a());
    public static final LootItemFunctionType SET_INSTRUMENT = LootItemFunctions.register("set_instrument", new SetInstrumentFunction.a());
    public static final LootItemFunctionType REFERENCE = LootItemFunctions.register("reference", new FunctionReference.a());

    private static LootItemFunctionType register(String var0, LootSerializer<? extends LootItemFunction> var1) {
        return IRegistry.register(BuiltInRegistries.LOOT_FUNCTION_TYPE, new MinecraftKey(var0), new LootItemFunctionType(var1));
    }

    public static Object createGsonAdapter() {
        return JsonRegistry.builder(BuiltInRegistries.LOOT_FUNCTION_TYPE, "function", "function", LootItemFunction::getType).build();
    }

    public static BiFunction<ItemStack, LootTableInfo, ItemStack> compose(BiFunction<ItemStack, LootTableInfo, ItemStack>[] var0) {
        switch (var0.length) {
            case 0: {
                return IDENTITY;
            }
            case 1: {
                return var0[0];
            }
            case 2: {
                BiFunction<ItemStack, LootTableInfo, ItemStack> var12 = var0[0];
                BiFunction<ItemStack, LootTableInfo, ItemStack> var22 = var0[1];
                return (var2, var3) -> (ItemStack)var22.apply((ItemStack)var12.apply((ItemStack)var2, (LootTableInfo)var3), (LootTableInfo)var3);
            }
        }
        return (var1, var2) -> {
            for (BiFunction var6 : var0) {
                var1 = (ItemStack)var6.apply(var1, var2);
            }
            return var1;
        };
    }
}

