/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.functions;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSyntaxException;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.util.ChatDeserializer;
import net.minecraft.world.item.ItemBlock;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.storage.loot.LootCollector;
import net.minecraft.world.level.storage.loot.LootDataId;
import net.minecraft.world.level.storage.loot.LootDataType;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionConditional;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class LootItemFunctionSetTable
extends LootItemFunctionConditional {
    final MinecraftKey name;
    final long seed;
    final TileEntityTypes<?> type;

    LootItemFunctionSetTable(LootItemCondition[] var0, MinecraftKey var1, long var2, TileEntityTypes<?> var4) {
        super(var0);
        this.name = var1;
        this.seed = var2;
        this.type = var4;
    }

    @Override
    public LootItemFunctionType getType() {
        return LootItemFunctions.SET_LOOT_TABLE;
    }

    @Override
    public ItemStack run(ItemStack var0, LootTableInfo var1) {
        if (var0.isEmpty()) {
            return var0;
        }
        NBTTagCompound var2 = ItemBlock.getBlockEntityData(var0);
        if (var2 == null) {
            var2 = new NBTTagCompound();
        }
        var2.putString("LootTable", this.name.toString());
        if (this.seed != 0L) {
            var2.putLong("LootTableSeed", this.seed);
        }
        ItemBlock.setBlockEntityData(var0, this.type, var2);
        return var0;
    }

    @Override
    public void validate(LootCollector var0) {
        super.validate(var0);
        LootDataId<LootTable> var1 = new LootDataId<LootTable>(LootDataType.TABLE, this.name);
        if (var0.resolver().getElementOptional(var1).isEmpty()) {
            var0.reportProblem("Missing loot table used for container: " + this.name);
        }
    }

    public static LootItemFunctionConditional.a<?> withLootTable(TileEntityTypes<?> var0, MinecraftKey var1) {
        return LootItemFunctionSetTable.simpleBuilder(var2 -> new LootItemFunctionSetTable((LootItemCondition[])var2, var1, 0L, var0));
    }

    public static LootItemFunctionConditional.a<?> withLootTable(TileEntityTypes<?> var0, MinecraftKey var1, long var2) {
        return LootItemFunctionSetTable.simpleBuilder(var4 -> new LootItemFunctionSetTable((LootItemCondition[])var4, var1, var2, var0));
    }

    public static class a
    extends LootItemFunctionConditional.c<LootItemFunctionSetTable> {
        @Override
        public void serialize(JsonObject var0, LootItemFunctionSetTable var1, JsonSerializationContext var2) {
            super.serialize(var0, var1, var2);
            var0.addProperty("name", var1.name.toString());
            var0.addProperty("type", BuiltInRegistries.BLOCK_ENTITY_TYPE.getKey(var1.type).toString());
            if (var1.seed != 0L) {
                var0.addProperty("seed", (Number)var1.seed);
            }
        }

        @Override
        public LootItemFunctionSetTable deserialize(JsonObject var0, JsonDeserializationContext var1, LootItemCondition[] var2) {
            MinecraftKey var3 = new MinecraftKey(ChatDeserializer.getAsString(var0, "name"));
            long var4 = ChatDeserializer.getAsLong(var0, "seed", 0L);
            MinecraftKey var6 = new MinecraftKey(ChatDeserializer.getAsString(var0, "type"));
            TileEntityTypes<?> var7 = BuiltInRegistries.BLOCK_ENTITY_TYPE.getOptional(var6).orElseThrow(() -> new JsonSyntaxException("Unknown block entity type id '" + var6 + "'"));
            return new LootItemFunctionSetTable(var2, var3, var4, var7);
        }

        @Override
        public /* synthetic */ LootItemFunctionConditional deserialize(JsonObject jsonObject, JsonDeserializationContext jsonDeserializationContext, LootItemCondition[] lootItemConditionArray) {
            return this.deserialize(jsonObject, jsonDeserializationContext, lootItemConditionArray);
        }
    }
}

