/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.functions;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.util.Set;
import net.minecraft.util.ChatDeserializer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionConditional;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameter;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;

public class LootEnchantLevel
extends LootItemFunctionConditional {
    final NumberProvider levels;
    final boolean treasure;

    LootEnchantLevel(LootItemCondition[] var0, NumberProvider var1, boolean var2) {
        super(var0);
        this.levels = var1;
        this.treasure = var2;
    }

    @Override
    public LootItemFunctionType getType() {
        return LootItemFunctions.ENCHANT_WITH_LEVELS;
    }

    @Override
    public Set<LootContextParameter<?>> getReferencedContextParams() {
        return this.levels.getReferencedContextParams();
    }

    @Override
    public ItemStack run(ItemStack var0, LootTableInfo var1) {
        RandomSource var2 = var1.getRandom();
        return EnchantmentManager.enchantItem(var2, var0, this.levels.getInt(var1), this.treasure);
    }

    public static a enchantWithLevels(NumberProvider var0) {
        return new a(var0);
    }

    public static class a
    extends LootItemFunctionConditional.a<a> {
        private final NumberProvider levels;
        private boolean treasure;

        public a(NumberProvider var0) {
            this.levels = var0;
        }

        @Override
        protected a getThis() {
            return this;
        }

        public a allowTreasure() {
            this.treasure = true;
            return this;
        }

        @Override
        public LootItemFunction build() {
            return new LootEnchantLevel(this.getConditions(), this.levels, this.treasure);
        }

        @Override
        protected /* synthetic */ LootItemFunctionConditional.a getThis() {
            return this.getThis();
        }
    }

    public static class b
    extends LootItemFunctionConditional.c<LootEnchantLevel> {
        @Override
        public void serialize(JsonObject var0, LootEnchantLevel var1, JsonSerializationContext var2) {
            super.serialize(var0, var1, var2);
            var0.add("levels", var2.serialize((Object)var1.levels));
            var0.addProperty("treasure", Boolean.valueOf(var1.treasure));
        }

        @Override
        public LootEnchantLevel deserialize(JsonObject var0, JsonDeserializationContext var1, LootItemCondition[] var2) {
            NumberProvider var3 = ChatDeserializer.getAsObject(var0, "levels", var1, NumberProvider.class);
            boolean var4 = ChatDeserializer.getAsBoolean(var0, "treasure", false);
            return new LootEnchantLevel(var2, var3, var4);
        }

        @Override
        public /* synthetic */ LootItemFunctionConditional deserialize(JsonObject jsonObject, JsonDeserializationContext jsonDeserializationContext, LootItemCondition[] lootItemConditionArray) {
            return this.deserialize(jsonObject, jsonDeserializationContext, lootItemConditionArray);
        }
    }
}

