/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.entries;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.util.function.Consumer;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.tags.TagKey;
import net.minecraft.util.ChatDeserializer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.entries.LootEntries;
import net.minecraft.world.level.storage.loot.entries.LootEntry;
import net.minecraft.world.level.storage.loot.entries.LootEntryType;
import net.minecraft.world.level.storage.loot.entries.LootSelectorEntry;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class LootSelectorTag
extends LootSelectorEntry {
    final TagKey<Item> tag;
    final boolean expand;

    LootSelectorTag(TagKey<Item> var0, boolean var1, int var2, int var3, LootItemCondition[] var4, LootItemFunction[] var5) {
        super(var2, var3, var4, var5);
        this.tag = var0;
        this.expand = var1;
    }

    @Override
    public LootEntryType getType() {
        return LootEntries.TAG;
    }

    @Override
    public void createItemStack(Consumer<ItemStack> var0, LootTableInfo var12) {
        BuiltInRegistries.ITEM.getTagOrEmpty(this.tag).forEach(var1 -> var0.accept(new ItemStack((Holder<Item>)var1)));
    }

    private boolean expandTag(LootTableInfo var0, Consumer<LootEntry> var1) {
        if (this.canRun(var0)) {
            for (final Holder<Item> var3 : BuiltInRegistries.ITEM.getTagOrEmpty(this.tag)) {
                var1.accept(new LootSelectorEntry.c(){

                    @Override
                    public void createItemStack(Consumer<ItemStack> var0, LootTableInfo var1) {
                        var0.accept(new ItemStack(var3));
                    }
                });
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean expand(LootTableInfo var0, Consumer<LootEntry> var1) {
        if (this.expand) {
            return this.expandTag(var0, var1);
        }
        return super.expand(var0, var1);
    }

    public static LootSelectorEntry.a<?> tagContents(TagKey<Item> var0) {
        return LootSelectorTag.simpleBuilder((var1, var2, var3, var4) -> new LootSelectorTag(var0, false, var1, var2, var3, var4));
    }

    public static LootSelectorEntry.a<?> expandTag(TagKey<Item> var0) {
        return LootSelectorTag.simpleBuilder((var1, var2, var3, var4) -> new LootSelectorTag(var0, true, var1, var2, var3, var4));
    }

    public static class a
    extends LootSelectorEntry.e<LootSelectorTag> {
        @Override
        public void serializeCustom(JsonObject var0, LootSelectorTag var1, JsonSerializationContext var2) {
            super.serializeCustom(var0, var1, var2);
            var0.addProperty("name", var1.tag.location().toString());
            var0.addProperty("expand", Boolean.valueOf(var1.expand));
        }

        @Override
        protected LootSelectorTag deserialize(JsonObject var0, JsonDeserializationContext var1, int var2, int var3, LootItemCondition[] var4, LootItemFunction[] var5) {
            MinecraftKey var6 = new MinecraftKey(ChatDeserializer.getAsString(var0, "name"));
            TagKey<Item> var7 = TagKey.create(Registries.ITEM, var6);
            boolean var8 = ChatDeserializer.getAsBoolean(var0, "expand");
            return new LootSelectorTag(var7, var8, var2, var3, var4, var5);
        }

        @Override
        protected /* synthetic */ LootSelectorEntry deserialize(JsonObject jsonObject, JsonDeserializationContext jsonDeserializationContext, int n2, int n3, LootItemCondition[] lootItemConditionArray, LootItemFunction[] lootItemFunctionArray) {
            return this.deserialize(jsonObject, jsonDeserializationContext, n2, n3, lootItemConditionArray, lootItemFunctionArray);
        }
    }
}

