/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.google.gson.JsonElement;
import com.mojang.logging.LogUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.packs.resources.IReloadListener;
import net.minecraft.server.packs.resources.IResourceManager;
import net.minecraft.server.packs.resources.ResourceDataJson;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootCollector;
import net.minecraft.world.level.storage.loot.LootDataId;
import net.minecraft.world.level.storage.loot.LootDataResolver;
import net.minecraft.world.level.storage.loot.LootDataType;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.LootTables;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameterSets;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditions;
import org.slf4j.Logger;

public class LootDataManager
implements IReloadListener,
LootDataResolver {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final LootDataId<LootTable> EMPTY_LOOT_TABLE_KEY = new LootDataId<LootTable>(LootDataType.TABLE, LootTables.EMPTY);
    private Map<LootDataId<?>, ?> elements = Map.of();
    private Multimap<LootDataType<?>, MinecraftKey> typeKeys = ImmutableMultimap.of();

    @Override
    public final CompletableFuture<Void> reload(IReloadListener.a var0, IResourceManager var12, GameProfilerFiller var2, GameProfilerFiller var32, Executor var4, Executor var5) {
        HashMap var6 = new HashMap();
        CompletableFuture[] var7 = (CompletableFuture[])LootDataType.values().map(var3 -> LootDataManager.scheduleElementParse(var3, var12, var4, var6)).toArray(CompletableFuture[]::new);
        return ((CompletableFuture)CompletableFuture.allOf(var7).thenCompose(var0::wait)).thenAcceptAsync(var1 -> this.apply(var6), var5);
    }

    private static <T> CompletableFuture<?> scheduleElementParse(LootDataType<T> var0, IResourceManager var1, Executor var2, Map<LootDataType<?>, Map<MinecraftKey, ?>> var3) {
        HashMap var4 = new HashMap();
        var3.put(var0, var4);
        return CompletableFuture.runAsync(() -> {
            HashMap<MinecraftKey, JsonElement> var32 = new HashMap<MinecraftKey, JsonElement>();
            ResourceDataJson.scanDirectory(var1, var0.directory(), var0.parser(), var32);
            var32.forEach((var22, var3) -> var0.deserialize((MinecraftKey)var22, (JsonElement)var3).ifPresent(var2 -> var4.put(var22, var2)));
        }, var2);
    }

    private void apply(Map<LootDataType<?>, Map<MinecraftKey, ?>> var02) {
        Object var12 = var02.get(LootDataType.TABLE).remove(LootTables.EMPTY);
        if (var12 != null) {
            LOGGER.warn("Datapack tried to redefine {} loot table, ignoring", (Object)LootTables.EMPTY);
        }
        ImmutableMap.Builder var22 = ImmutableMap.builder();
        ImmutableMultimap.Builder var3 = ImmutableMultimap.builder();
        var02.forEach((var2, var32) -> var32.forEach((var3, var4) -> {
            var22.put(new LootDataId(var2, (MinecraftKey)var3), var4);
            var3.put(var2, var3);
        }));
        var22.put(EMPTY_LOOT_TABLE_KEY, (Object)LootTable.EMPTY);
        ImmutableMap var4 = var22.build();
        LootCollector var5 = new LootCollector(LootContextParameterSets.ALL_PARAMS, new LootDataResolver((Map)var4){
            final /* synthetic */ Map a;
            {
                this.a = map;
            }

            @Override
            @Nullable
            public <T> T getElement(LootDataId<T> var0) {
                return (T)this.a.get(var0);
            }
        });
        var4.forEach((var1, var2) -> LootDataManager.castAndValidate(var5, var1, var2));
        var5.getProblems().forEach((var0, var1) -> LOGGER.warn("Found loot table element validation problem in {}: {}", var0, var1));
        this.elements = var4;
        this.typeKeys = var3.build();
    }

    private static <T> void castAndValidate(LootCollector var0, LootDataId<T> var1, Object var2) {
        var1.type().runValidation(var0, var1, var2);
    }

    @Override
    @Nullable
    public <T> T getElement(LootDataId<T> var0) {
        return (T)this.elements.get(var0);
    }

    public Collection<MinecraftKey> getKeys(LootDataType<?> var0) {
        return this.typeKeys.get(var0);
    }

    public static LootItemCondition createComposite(LootItemCondition[] var0) {
        return new a(var0);
    }

    public static LootItemFunction createComposite(LootItemFunction[] var0) {
        return new b(var0);
    }

    static class a
    implements LootItemCondition {
        private final LootItemCondition[] terms;
        private final Predicate<LootTableInfo> composedPredicate;

        a(LootItemCondition[] var0) {
            this.terms = var0;
            this.composedPredicate = LootItemConditions.andConditions(var0);
        }

        @Override
        public final boolean test(LootTableInfo var0) {
            return this.composedPredicate.test(var0);
        }

        @Override
        public void validate(LootCollector var0) {
            LootItemCondition.super.validate(var0);
            for (int var1 = 0; var1 < this.terms.length; ++var1) {
                this.terms[var1].validate(var0.forChild(".term[" + var1 + "]"));
            }
        }

        @Override
        public LootItemConditionType getType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public /* synthetic */ boolean test(Object object) {
            return this.test((LootTableInfo)object);
        }
    }

    static class b
    implements LootItemFunction {
        protected final LootItemFunction[] functions;
        private final BiFunction<ItemStack, LootTableInfo, ItemStack> compositeFunction;

        public b(LootItemFunction[] var0) {
            this.functions = var0;
            this.compositeFunction = LootItemFunctions.compose(var0);
        }

        @Override
        public ItemStack apply(ItemStack var0, LootTableInfo var1) {
            return this.compositeFunction.apply(var0, var1);
        }

        @Override
        public void validate(LootCollector var0) {
            LootItemFunction.super.validate(var0);
            for (int var1 = 0; var1 < this.functions.length; ++var1) {
                this.functions[var1].validate(var0.forChild(".function[" + var1 + "]"));
            }
        }

        @Override
        public LootItemFunctionType getType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public /* synthetic */ Object apply(Object object, Object object2) {
            return this.apply((ItemStack)object, (LootTableInfo)object2);
        }
    }
}

