/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.world.level.storage.loot.LootDataId;
import net.minecraft.world.level.storage.loot.LootDataResolver;
import net.minecraft.world.level.storage.loot.LootItemUser;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameterSet;

public class LootCollector {
    private final Multimap<String, String> problems;
    private final Supplier<String> context;
    private final LootContextParameterSet params;
    private final LootDataResolver resolver;
    private final Set<LootDataId<?>> visitedElements;
    @Nullable
    private String contextCache;

    public LootCollector(LootContextParameterSet var0, LootDataResolver var1) {
        this((Multimap<String, String>)HashMultimap.create(), () -> "", var0, var1, (Set<LootDataId<?>>)ImmutableSet.of());
    }

    public LootCollector(Multimap<String, String> var0, Supplier<String> var1, LootContextParameterSet var2, LootDataResolver var3, Set<LootDataId<?>> var4) {
        this.problems = var0;
        this.context = var1;
        this.params = var2;
        this.resolver = var3;
        this.visitedElements = var4;
    }

    private String getContext() {
        if (this.contextCache == null) {
            this.contextCache = this.context.get();
        }
        return this.contextCache;
    }

    public void reportProblem(String var0) {
        this.problems.put((Object)this.getContext(), (Object)var0);
    }

    public LootCollector forChild(String var0) {
        return new LootCollector(this.problems, () -> this.getContext() + var0, this.params, this.resolver, this.visitedElements);
    }

    public LootCollector enterElement(String var0, LootDataId<?> var1) {
        ImmutableSet var2 = ImmutableSet.builder().addAll(this.visitedElements).add(var1).build();
        return new LootCollector(this.problems, () -> this.getContext() + var0, this.params, this.resolver, (Set<LootDataId<?>>)var2);
    }

    public boolean hasVisitedElement(LootDataId<?> var0) {
        return this.visitedElements.contains(var0);
    }

    public Multimap<String, String> getProblems() {
        return ImmutableMultimap.copyOf(this.problems);
    }

    public void validateUser(LootItemUser var0) {
        this.params.validateUser(this, var0);
    }

    public LootDataResolver resolver() {
        return this.resolver;
    }

    public LootCollector setParams(LootContextParameterSet var0) {
        return new LootCollector(this.problems, this.context, var0, this.resolver, this.visitedElements);
    }
}

