/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage;

import java.nio.file.Path;
import javax.annotation.Nullable;
import net.minecraft.EnumChatFormat;
import net.minecraft.SharedConstants;
import net.minecraft.WorldVersion;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.util.UtilColor;
import net.minecraft.world.level.EnumGamemode;
import net.minecraft.world.level.WorldSettings;
import net.minecraft.world.level.storage.LevelVersion;
import org.apache.commons.lang3.StringUtils;

public class WorldInfo
implements Comparable<WorldInfo> {
    private final WorldSettings settings;
    private final LevelVersion levelVersion;
    private final String levelId;
    private final boolean requiresManualConversion;
    private final boolean locked;
    private final boolean experimental;
    private final Path icon;
    @Nullable
    private IChatBaseComponent info;

    public WorldInfo(WorldSettings var0, LevelVersion var1, String var2, boolean var3, boolean var4, boolean var5, Path var6) {
        this.settings = var0;
        this.levelVersion = var1;
        this.levelId = var2;
        this.locked = var4;
        this.experimental = var5;
        this.icon = var6;
        this.requiresManualConversion = var3;
    }

    public String getLevelId() {
        return this.levelId;
    }

    public String getLevelName() {
        return StringUtils.isEmpty((CharSequence)this.settings.levelName()) ? this.levelId : this.settings.levelName();
    }

    public Path getIcon() {
        return this.icon;
    }

    public boolean requiresManualConversion() {
        return this.requiresManualConversion;
    }

    public boolean isExperimental() {
        return this.experimental;
    }

    public long getLastPlayed() {
        return this.levelVersion.lastPlayed();
    }

    @Override
    public int compareTo(WorldInfo var0) {
        if (this.getLastPlayed() < var0.getLastPlayed()) {
            return 1;
        }
        if (this.getLastPlayed() > var0.getLastPlayed()) {
            return -1;
        }
        return this.levelId.compareTo(var0.levelId);
    }

    public WorldSettings getSettings() {
        return this.settings;
    }

    public EnumGamemode getGameMode() {
        return this.settings.gameType();
    }

    public boolean isHardcore() {
        return this.settings.hardcore();
    }

    public boolean hasCheats() {
        return this.settings.allowCommands();
    }

    public IChatMutableComponent getWorldVersionName() {
        if (UtilColor.isNullOrEmpty(this.levelVersion.minecraftVersionName())) {
            return IChatBaseComponent.translatable("selectWorld.versionUnknown");
        }
        return IChatBaseComponent.literal(this.levelVersion.minecraftVersionName());
    }

    public LevelVersion levelVersion() {
        return this.levelVersion;
    }

    public boolean markVersionInList() {
        return this.askToOpenWorld() || !SharedConstants.getCurrentVersion().isStable() && !this.levelVersion.snapshot() || this.backupStatus().shouldBackup();
    }

    public boolean askToOpenWorld() {
        return this.levelVersion.minecraftVersion().getVersion() > SharedConstants.getCurrentVersion().getDataVersion().getVersion();
    }

    public a backupStatus() {
        WorldVersion var0 = SharedConstants.getCurrentVersion();
        int var1 = var0.getDataVersion().getVersion();
        int var2 = this.levelVersion.minecraftVersion().getVersion();
        if (!var0.isStable() && var2 < var1) {
            return a.UPGRADE_TO_SNAPSHOT;
        }
        if (var2 > var1) {
            return a.DOWNGRADE;
        }
        return a.NONE;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public boolean isDisabled() {
        if (this.isLocked() || this.requiresManualConversion()) {
            return true;
        }
        return !this.isCompatible();
    }

    public boolean isCompatible() {
        return SharedConstants.getCurrentVersion().getDataVersion().isCompatible(this.levelVersion.minecraftVersion());
    }

    public IChatBaseComponent getInfo() {
        if (this.info == null) {
            this.info = this.createInfo();
        }
        return this.info;
    }

    private IChatBaseComponent createInfo() {
        IChatMutableComponent var02;
        if (this.isLocked()) {
            return IChatBaseComponent.translatable("selectWorld.locked").withStyle(EnumChatFormat.RED);
        }
        if (this.requiresManualConversion()) {
            return IChatBaseComponent.translatable("selectWorld.conversion").withStyle(EnumChatFormat.RED);
        }
        if (!this.isCompatible()) {
            return IChatBaseComponent.translatable("selectWorld.incompatible_series").withStyle(EnumChatFormat.RED);
        }
        IChatMutableComponent iChatMutableComponent = var02 = this.isHardcore() ? IChatBaseComponent.empty().append(IChatBaseComponent.translatable("gameMode.hardcore").withStyle(var0 -> var0.withColor(-65536))) : IChatBaseComponent.translatable("gameMode." + this.getGameMode().getName());
        if (this.hasCheats()) {
            var02.append(", ").append(IChatBaseComponent.translatable("selectWorld.cheats"));
        }
        if (this.isExperimental()) {
            var02.append(", ").append(IChatBaseComponent.translatable("selectWorld.experimental").withStyle(EnumChatFormat.YELLOW));
        }
        IChatMutableComponent var1 = this.getWorldVersionName();
        IChatMutableComponent var2 = IChatBaseComponent.literal(", ").append(IChatBaseComponent.translatable("selectWorld.version")).append(CommonComponents.SPACE);
        if (this.markVersionInList()) {
            var2.append(var1.withStyle(this.askToOpenWorld() ? EnumChatFormat.RED : EnumChatFormat.ITALIC));
        } else {
            var2.append(var1);
        }
        var02.append(var2);
        return var02;
    }

    @Override
    public /* synthetic */ int compareTo(Object object) {
        return this.compareTo((WorldInfo)object);
    }

    public static final class a
    extends Enum<a> {
        public static final /* enum */ a NONE = new a(false, false, "");
        public static final /* enum */ a DOWNGRADE = new a(true, true, "downgrade");
        public static final /* enum */ a UPGRADE_TO_SNAPSHOT = new a(true, false, "snapshot");
        private final boolean shouldBackup;
        private final boolean severe;
        private final String translationKey;
        private static final /* synthetic */ a[] g;

        public static a[] values() {
            return (a[])g.clone();
        }

        public static a valueOf(String var0) {
            return Enum.valueOf(a.class, var0);
        }

        private a(boolean var2, boolean var3, String var4) {
            this.shouldBackup = var2;
            this.severe = var3;
            this.translationKey = var4;
        }

        public boolean shouldBackup() {
            return this.shouldBackup;
        }

        public boolean isSevere() {
            return this.severe;
        }

        public String getTranslationKey() {
            return this.translationKey;
        }

        private static /* synthetic */ a[] d() {
            return new a[]{NONE, DOWNGRADE, UPGRADE_TO_SNAPSHOT};
        }

        static {
            g = a.d();
        }
    }

    public static class b
    extends WorldInfo {
        public b(String var0, Path var1) {
            super(null, null, var0, false, false, false, var1);
        }

        @Override
        public String getLevelName() {
            return this.getLevelId();
        }

        @Override
        public IChatBaseComponent getInfo() {
            return IChatBaseComponent.translatable("symlink_warning.title").withStyle(var0 -> var0.withColor(-65536));
        }

        @Override
        public long getLastPlayed() {
            return -1L;
        }

        @Override
        public boolean isDisabled() {
            return false;
        }

        @Override
        public /* synthetic */ int compareTo(Object object) {
            return super.compareTo((WorldInfo)object);
        }
    }
}

