/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.mojang.datafixers.DataFixer;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Lifecycle;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.SignStyle;
import java.time.temporal.ChronoField;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.annotation.Nullable;
import net.minecraft.FileUtils;
import net.minecraft.SystemUtils;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTCompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.StreamTagVisitor;
import net.minecraft.nbt.visitors.FieldSelector;
import net.minecraft.nbt.visitors.SkipFields;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.MemoryReserve;
import net.minecraft.util.SessionLock;
import net.minecraft.util.datafix.DataConverterRegistry;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldDataConfiguration;
import net.minecraft.world.level.WorldSettings;
import net.minecraft.world.level.dimension.DimensionManager;
import net.minecraft.world.level.dimension.WorldDimension;
import net.minecraft.world.level.levelgen.GeneratorSettings;
import net.minecraft.world.level.levelgen.WorldDimensions;
import net.minecraft.world.level.storage.LevelStorageException;
import net.minecraft.world.level.storage.LevelVersion;
import net.minecraft.world.level.storage.SaveData;
import net.minecraft.world.level.storage.SavedFile;
import net.minecraft.world.level.storage.WorldDataServer;
import net.minecraft.world.level.storage.WorldInfo;
import net.minecraft.world.level.storage.WorldNBTStorage;
import net.minecraft.world.level.validation.ContentValidationException;
import net.minecraft.world.level.validation.DirectoryValidator;
import net.minecraft.world.level.validation.ForbiddenSymlinkInfo;
import net.minecraft.world.level.validation.PathAllowList;
import org.slf4j.Logger;

public class Convertable {
    static final Logger LOGGER = LogUtils.getLogger();
    static final DateTimeFormatter FORMATTER = new DateTimeFormatterBuilder().appendValue(ChronoField.YEAR, 4, 10, SignStyle.EXCEEDS_PAD).appendLiteral('-').appendValue(ChronoField.MONTH_OF_YEAR, 2).appendLiteral('-').appendValue(ChronoField.DAY_OF_MONTH, 2).appendLiteral('_').appendValue(ChronoField.HOUR_OF_DAY, 2).appendLiteral('-').appendValue(ChronoField.MINUTE_OF_HOUR, 2).appendLiteral('-').appendValue(ChronoField.SECOND_OF_MINUTE, 2).toFormatter();
    private static final ImmutableList<String> OLD_SETTINGS_KEYS = ImmutableList.of((Object)"RandomSeed", (Object)"generatorName", (Object)"generatorOptions", (Object)"generatorVersion", (Object)"legacy_custom_options", (Object)"MapFeatures", (Object)"BonusChest");
    private static final String TAG_DATA = "Data";
    private static final PathAllowList NO_SYMLINKS_ALLOWED = new PathAllowList(List.of());
    public static final String ALLOWED_SYMLINKS_CONFIG_NAME = "allowed_symlinks.txt";
    public final Path baseDir;
    private final Path backupDir;
    final DataFixer fixerUpper;
    private final DirectoryValidator worldDirValidator;

    public Convertable(Path var0, Path var1, DirectoryValidator var2, DataFixer var3) {
        this.fixerUpper = var3;
        try {
            FileUtils.createDirectoriesSafe(var0);
        }
        catch (IOException var4) {
            throw new UncheckedIOException(var4);
        }
        this.baseDir = var0;
        this.backupDir = var1;
        this.worldDirValidator = var2;
    }

    public static DirectoryValidator parseValidator(Path var0) {
        if (Files.exists(var0, new LinkOption[0])) {
            DirectoryValidator directoryValidator;
            block9: {
                BufferedReader var1 = Files.newBufferedReader(var0);
                try {
                    directoryValidator = new DirectoryValidator(PathAllowList.readPlain(var1));
                    if (var1 == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (var1 != null) {
                            try {
                                var1.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception var12) {
                        LOGGER.error("Failed to parse {}, disallowing all symbolic links", (Object)ALLOWED_SYMLINKS_CONFIG_NAME, (Object)var12);
                    }
                }
                var1.close();
            }
            return directoryValidator;
        }
        return new DirectoryValidator(NO_SYMLINKS_ALLOWED);
    }

    public static Convertable createDefault(Path var0) {
        DirectoryValidator var1 = Convertable.parseValidator(var0.resolve(ALLOWED_SYMLINKS_CONFIG_NAME));
        return new Convertable(var0, var0.resolve("../backups"), var1, DataConverterRegistry.getDataFixer());
    }

    private static <T> DataResult<GeneratorSettings> readWorldGenSettings(Dynamic<T> var0, DataFixer var1, int var2) {
        Dynamic var3 = var0.get("WorldGenSettings").orElseEmptyMap();
        for (String var5 : OLD_SETTINGS_KEYS) {
            Optional var6 = var0.get(var5).result();
            if (!var6.isPresent()) continue;
            var3 = var3.set(var5, (Dynamic)var6.get());
        }
        Dynamic var4 = DataFixTypes.WORLD_GEN_SETTINGS.updateToCurrentVersion(var1, var3, var2);
        return GeneratorSettings.CODEC.parse(var4);
    }

    private static WorldDataConfiguration readDataConfig(Dynamic<?> var0) {
        return WorldDataConfiguration.CODEC.parse(var0).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).orElse(WorldDataConfiguration.DEFAULT);
    }

    public String getName() {
        return "Anvil";
    }

    public a findLevelCandidates() throws LevelStorageException {
        a a2;
        block9: {
            if (!Files.isDirectory(this.baseDir, new LinkOption[0])) {
                throw new LevelStorageException(IChatBaseComponent.translatable("selectWorld.load_folder_access"));
            }
            Stream<Path> var02 = Files.list(this.baseDir);
            try {
                List<b> var1 = var02.filter(var0 -> Files.isDirectory(var0, new LinkOption[0])).map(b::new).filter(var0 -> Files.isRegularFile(var0.dataFile(), new LinkOption[0]) || Files.isRegularFile(var0.oldDataFile(), new LinkOption[0])).toList();
                a2 = new a(var1);
                if (var02 == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (var02 != null) {
                        try {
                            var02.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException var03) {
                    throw new LevelStorageException(IChatBaseComponent.translatable("selectWorld.load_folder_access"));
                }
            }
            var02.close();
        }
        return a2;
    }

    public CompletableFuture<List<WorldInfo>> loadLevelSummaries(a var02) {
        ArrayList<CompletableFuture<WorldInfo>> var1 = new ArrayList<CompletableFuture<WorldInfo>>(var02.levels.size());
        for (b var3 : var02.levels) {
            var1.add(CompletableFuture.supplyAsync(() -> {
                boolean var1;
                try {
                    var1 = SessionLock.isLocked(var3.path());
                }
                catch (Exception var2) {
                    LOGGER.warn("Failed to read {} lock", (Object)var3.path(), (Object)var2);
                    return null;
                }
                try {
                    WorldInfo var2 = this.readLevelData(var3, this.levelSummaryReader(var3, var1));
                    if (var2 != null) {
                        return var2;
                    }
                }
                catch (OutOfMemoryError var2) {
                    MemoryReserve.release();
                    System.gc();
                    LOGGER.error(LogUtils.FATAL_MARKER, "Ran out of memory trying to read summary of {}", (Object)var3.directoryName());
                    throw var2;
                }
                catch (StackOverflowError var2) {
                    LOGGER.error(LogUtils.FATAL_MARKER, "Ran out of stack trying to read summary of {}. Assuming corruption; attempting to restore from from level.dat_old.", (Object)var3.directoryName());
                    SystemUtils.safeReplaceOrMoveFile(var3.dataFile(), var3.oldDataFile(), var3.corruptedDataFile(LocalDateTime.now()), true);
                    throw var2;
                }
                return null;
            }, SystemUtils.backgroundExecutor()));
        }
        return SystemUtils.sequenceFailFastAndCancel(var1).thenApply(var0 -> var0.stream().filter(Objects::nonNull).sorted().toList());
    }

    private int getStorageVersion() {
        return 19133;
    }

    @Nullable
    <T> T readLevelData(b var0, BiFunction<Path, DataFixer, T> var1) {
        T var3;
        if (!Files.exists(var0.path(), new LinkOption[0])) {
            return null;
        }
        Path var2 = var0.dataFile();
        if (Files.exists(var2, new LinkOption[0]) && (var3 = var1.apply(var2, this.fixerUpper)) != null) {
            return var3;
        }
        var2 = var0.oldDataFile();
        if (Files.exists(var2, new LinkOption[0])) {
            return var1.apply(var2, this.fixerUpper);
        }
        return null;
    }

    @Nullable
    private static WorldDataConfiguration getDataConfiguration(Path var0, DataFixer var1) {
        try {
            NBTBase var2 = Convertable.readLightweightData(var0);
            if (var2 instanceof NBTTagCompound) {
                NBTTagCompound var3 = (NBTTagCompound)var2;
                NBTTagCompound var4 = var3.getCompound(TAG_DATA);
                int var5 = GameProfileSerializer.getDataVersion(var4, -1);
                Dynamic var6 = DataFixTypes.LEVEL.updateToCurrentVersion(var1, new Dynamic((DynamicOps)DynamicOpsNBT.INSTANCE, (Object)var4), var5);
                return Convertable.readDataConfig(var6);
            }
        }
        catch (Exception var2) {
            LOGGER.error("Exception reading {}", (Object)var0, (Object)var2);
        }
        return null;
    }

    static BiFunction<Path, DataFixer, Pair<SaveData, WorldDimensions.b>> getLevelData(DynamicOps<NBTBase> var0, WorldDataConfiguration var1, IRegistry<WorldDimension> var2, Lifecycle var3) {
        return (var4, var5) -> {
            NBTTagCompound var6;
            try {
                var6 = NBTCompressedStreamTools.readCompressed(var4.toFile());
            }
            catch (IOException var7) {
                throw new UncheckedIOException(var7);
            }
            NBTTagCompound var7 = var6.getCompound(TAG_DATA);
            NBTTagCompound var8 = var7.contains("Player", 10) ? var7.getCompound("Player") : null;
            var7.remove("Player");
            int var9 = GameProfileSerializer.getDataVersion(var7, -1);
            Dynamic var10 = DataFixTypes.LEVEL.updateToCurrentVersion((DataFixer)var5, new Dynamic(var0, (Object)var7), var9);
            GeneratorSettings var11 = (GeneratorSettings)Convertable.readWorldGenSettings(var10, var5, var9).getOrThrow(false, SystemUtils.prefix("WorldGenSettings: ", arg_0 -> ((Logger)LOGGER).error(arg_0)));
            LevelVersion var12 = LevelVersion.parse(var10);
            WorldSettings var13 = WorldSettings.parse(var10, var1);
            WorldDimensions.b var14 = var11.dimensions().bake(var2);
            Lifecycle var15 = var14.lifecycle().add(var3);
            WorldDataServer var16 = WorldDataServer.parse(var10, var5, var9, var8, var13, var12, var14.specialWorldProperty(), var11.options(), var15);
            return Pair.of((Object)var16, (Object)var14);
        };
    }

    BiFunction<Path, DataFixer, WorldInfo> levelSummaryReader(b var0, boolean var1) {
        return (var2, var3) -> {
            try {
                Object var4;
                if (Files.isSymbolicLink(var2)) {
                    var4 = new ArrayList();
                    this.worldDirValidator.validateSymlink((Path)var2, (List<ForbiddenSymlinkInfo>)var4);
                    if (!var4.isEmpty()) {
                        LOGGER.warn(ContentValidationException.getMessage(var2, (List<ForbiddenSymlinkInfo>)var4));
                        return new WorldInfo.b(var0.directoryName(), var0.iconFile());
                    }
                }
                if ((var4 = Convertable.readLightweightData(var2)) instanceof NBTTagCompound) {
                    int var7;
                    NBTTagCompound var5 = (NBTTagCompound)var4;
                    NBTTagCompound var6 = var5.getCompound(TAG_DATA);
                    Dynamic var8 = DataFixTypes.LEVEL.updateToCurrentVersion((DataFixer)var3, new Dynamic((DynamicOps)DynamicOpsNBT.INSTANCE, (Object)var6), var7 = GameProfileSerializer.getDataVersion(var6, -1));
                    LevelVersion var9 = LevelVersion.parse(var8);
                    int var10 = var9.levelDataVersion();
                    if (var10 == 19132 || var10 == 19133) {
                        boolean var11 = var10 != this.getStorageVersion();
                        Path var12 = var0.iconFile();
                        WorldDataConfiguration var13 = Convertable.readDataConfig(var8);
                        WorldSettings var14 = WorldSettings.parse(var8, var13);
                        FeatureFlagSet var15 = Convertable.parseFeatureFlagsFromSummary(var8);
                        boolean var16 = FeatureFlags.isExperimental(var15);
                        return new WorldInfo(var14, var9, var0.directoryName(), var11, var1, var16, var12);
                    }
                } else {
                    LOGGER.warn("Invalid root tag in {}", var2);
                }
                return null;
            }
            catch (Exception var4) {
                LOGGER.error("Exception reading {}", var2, (Object)var4);
                return null;
            }
        };
    }

    private static FeatureFlagSet parseFeatureFlagsFromSummary(Dynamic<?> var02) {
        Set<MinecraftKey> var1 = var02.get("enabled_features").asStream().flatMap(var0 -> var0.asString().result().map(MinecraftKey::tryParse).stream()).collect(Collectors.toSet());
        return FeatureFlags.REGISTRY.fromNames(var1, var0 -> {});
    }

    @Nullable
    private static NBTBase readLightweightData(Path var0) throws IOException {
        SkipFields var1 = new SkipFields(new FieldSelector(TAG_DATA, NBTTagCompound.TYPE, "Player"), new FieldSelector(TAG_DATA, NBTTagCompound.TYPE, "WorldGenSettings"));
        NBTCompressedStreamTools.parseCompressed(var0.toFile(), (StreamTagVisitor)var1);
        return var1.getResult();
    }

    public boolean isNewLevelIdAcceptable(String var0) {
        try {
            Path var1 = this.getLevelPath(var0);
            Files.createDirectory(var1, new FileAttribute[0]);
            Files.deleteIfExists(var1);
            return true;
        }
        catch (IOException var1) {
            return false;
        }
    }

    public boolean levelExists(String var0) {
        return Files.isDirectory(this.getLevelPath(var0), new LinkOption[0]);
    }

    private Path getLevelPath(String var0) {
        return this.baseDir.resolve(var0);
    }

    public Path getBaseDir() {
        return this.baseDir;
    }

    public Path getBackupPath() {
        return this.backupDir;
    }

    public ConversionSession validateAndCreateAccess(String var0) throws IOException, ContentValidationException {
        Path var1 = this.getLevelPath(var0);
        List<ForbiddenSymlinkInfo> var2 = this.worldDirValidator.validateSave(var1, true);
        if (!var2.isEmpty()) {
            throw new ContentValidationException(var1, var2);
        }
        return new ConversionSession(var0, var1);
    }

    public ConversionSession createAccess(String var0) throws IOException {
        Path var1 = this.getLevelPath(var0);
        return new ConversionSession(var0, var1);
    }

    public DirectoryValidator getWorldDirValidator() {
        return this.worldDirValidator;
    }

    public static final class a
    extends Record
    implements Iterable<b> {
        final List<b> levels;

        public a(List<b> var0) {
            this.levels = var0;
        }

        public boolean isEmpty() {
            return this.levels.isEmpty();
        }

        @Override
        public Iterator<b> iterator() {
            return this.levels.iterator();
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "levels", "levels"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "levels", "levels"}, this);
        }

        @Override
        public final boolean equals(Object var0) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "levels", "levels"}, this, var0);
        }

        public List<b> levels() {
            return this.levels;
        }
    }

    public record b(Path path) {
        public String directoryName() {
            return this.path.getFileName().toString();
        }

        public Path dataFile() {
            return this.resourcePath(SavedFile.LEVEL_DATA_FILE);
        }

        public Path oldDataFile() {
            return this.resourcePath(SavedFile.OLD_LEVEL_DATA_FILE);
        }

        public Path corruptedDataFile(LocalDateTime var0) {
            return this.path.resolve(SavedFile.LEVEL_DATA_FILE.getId() + "_corrupted_" + var0.format(FORMATTER));
        }

        public Path iconFile() {
            return this.resourcePath(SavedFile.ICON_FILE);
        }

        public Path lockFile() {
            return this.resourcePath(SavedFile.LOCK_FILE);
        }

        public Path resourcePath(SavedFile var0) {
            return this.path.resolve(var0.getId());
        }
    }

    public class ConversionSession
    implements AutoCloseable {
        final SessionLock lock;
        public final b levelDirectory;
        private final String levelId;
        private final Map<SavedFile, Path> resources = Maps.newHashMap();

        ConversionSession(String var1, Path var2) throws IOException {
            this.levelId = var1;
            this.levelDirectory = new b(var2);
            this.lock = SessionLock.create(var2);
        }

        public String getLevelId() {
            return this.levelId;
        }

        public Path getLevelPath(SavedFile var0) {
            return this.resources.computeIfAbsent(var0, this.levelDirectory::resourcePath);
        }

        public Path getDimensionPath(ResourceKey<World> var0) {
            return DimensionManager.getStorageFolder(var0, this.levelDirectory.path());
        }

        private void checkLock() {
            if (!this.lock.isValid()) {
                throw new IllegalStateException("Lock is no longer valid");
            }
        }

        public WorldNBTStorage createPlayerStorage() {
            this.checkLock();
            return new WorldNBTStorage(this, Convertable.this.fixerUpper);
        }

        @Nullable
        public WorldInfo getSummary() {
            this.checkLock();
            return Convertable.this.readLevelData(this.levelDirectory, Convertable.this.levelSummaryReader(this.levelDirectory, false));
        }

        @Nullable
        public Pair<SaveData, WorldDimensions.b> getDataTag(DynamicOps<NBTBase> var0, WorldDataConfiguration var1, IRegistry<WorldDimension> var2, Lifecycle var3) {
            this.checkLock();
            return Convertable.this.readLevelData(this.levelDirectory, Convertable.getLevelData(var0, var1, var2, var3));
        }

        @Nullable
        public WorldDataConfiguration getDataConfiguration() {
            this.checkLock();
            return Convertable.this.readLevelData(this.levelDirectory, Convertable::getDataConfiguration);
        }

        public void saveDataTag(IRegistryCustom var0, SaveData var1) {
            this.saveDataTag(var0, var1, null);
        }

        public void saveDataTag(IRegistryCustom var0, SaveData var1, @Nullable NBTTagCompound var2) {
            File var3 = this.levelDirectory.path().toFile();
            NBTTagCompound var4 = var1.createTag(var0, var2);
            NBTTagCompound var5 = new NBTTagCompound();
            var5.put(Convertable.TAG_DATA, var4);
            try {
                File var6 = File.createTempFile("level", ".dat", var3);
                NBTCompressedStreamTools.writeCompressed(var5, var6);
                File var7 = this.levelDirectory.oldDataFile().toFile();
                File var8 = this.levelDirectory.dataFile().toFile();
                SystemUtils.safeReplaceFile(var8, var6, var7);
            }
            catch (Exception var6) {
                LOGGER.error("Failed to save level {}", (Object)var3, (Object)var6);
            }
        }

        public Optional<Path> getIconFile() {
            if (!this.lock.isValid()) {
                return Optional.empty();
            }
            return Optional.of(this.levelDirectory.iconFile());
        }

        public void deleteLevel() throws IOException {
            this.checkLock();
            final Path var0 = this.levelDirectory.lockFile();
            LOGGER.info("Deleting level {}", (Object)this.levelId);
            for (int var1 = 1; var1 <= 5; ++var1) {
                LOGGER.info("Attempt {}...", (Object)var1);
                try {
                    Files.walkFileTree(this.levelDirectory.path(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                        @Override
                        public FileVisitResult visitFile(Path var02, BasicFileAttributes var1) throws IOException {
                            if (!var02.equals(var0)) {
                                LOGGER.debug("Deleting {}", (Object)var02);
                                Files.delete(var02);
                            }
                            return FileVisitResult.CONTINUE;
                        }

                        @Override
                        public FileVisitResult postVisitDirectory(Path var02, @Nullable IOException var1) throws IOException {
                            if (var1 != null) {
                                throw var1;
                            }
                            if (var02.equals(ConversionSession.this.levelDirectory.path())) {
                                ConversionSession.this.lock.close();
                                Files.deleteIfExists(var0);
                            }
                            Files.delete(var02);
                            return FileVisitResult.CONTINUE;
                        }

                        @Override
                        public /* synthetic */ FileVisitResult postVisitDirectory(Object object, @Nullable IOException iOException) throws IOException {
                            return this.postVisitDirectory((Path)object, iOException);
                        }

                        @Override
                        public /* synthetic */ FileVisitResult visitFile(Object object, BasicFileAttributes basicFileAttributes) throws IOException {
                            return this.visitFile((Path)object, basicFileAttributes);
                        }
                    });
                    break;
                }
                catch (IOException var2) {
                    if (var1 < 5) {
                        LOGGER.warn("Failed to delete {}", (Object)this.levelDirectory.path(), (Object)var2);
                        try {
                            Thread.sleep(500L);
                        }
                        catch (InterruptedException interruptedException) {}
                        continue;
                    }
                    throw var2;
                }
            }
        }

        public void renameLevel(String var0) throws IOException {
            this.checkLock();
            Path var1 = this.levelDirectory.dataFile();
            if (Files.exists(var1, new LinkOption[0])) {
                NBTTagCompound var2 = NBTCompressedStreamTools.readCompressed(var1.toFile());
                NBTTagCompound var3 = var2.getCompound(Convertable.TAG_DATA);
                var3.putString("LevelName", var0);
                NBTCompressedStreamTools.writeCompressed(var2, var1.toFile());
            }
        }

        public long makeWorldBackup() throws IOException {
            this.checkLock();
            String var0 = LocalDateTime.now().format(FORMATTER) + "_" + this.levelId;
            Path var1 = Convertable.this.getBackupPath();
            try {
                FileUtils.createDirectoriesSafe(var1);
            }
            catch (IOException var2) {
                throw new RuntimeException(var2);
            }
            Path var2 = var1.resolve(FileUtils.findAvailableName(var1, var0, ".zip"));
            try (final ZipOutputStream var3 = new ZipOutputStream(new BufferedOutputStream(Files.newOutputStream(var2, new OpenOption[0])));){
                final Path var4 = Paths.get(this.levelId, new String[0]);
                Files.walkFileTree(this.levelDirectory.path(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path var0, BasicFileAttributes var1) throws IOException {
                        if (var0.endsWith("session.lock")) {
                            return FileVisitResult.CONTINUE;
                        }
                        String var2 = var4.resolve(ConversionSession.this.levelDirectory.path().relativize(var0)).toString().replace('\\', '/');
                        ZipEntry var32 = new ZipEntry(var2);
                        var3.putNextEntry(var32);
                        com.google.common.io.Files.asByteSource((File)var0.toFile()).copyTo((OutputStream)var3);
                        var3.closeEntry();
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public /* synthetic */ FileVisitResult visitFile(Object object, BasicFileAttributes basicFileAttributes) throws IOException {
                        return this.visitFile((Path)object, basicFileAttributes);
                    }
                });
            }
            return Files.size(var2);
        }

        @Override
        public void close() throws IOException {
            this.lock.close();
        }
    }
}

