/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.portal;

import java.util.Comparator;
import java.util.Optional;
import net.minecraft.BlockUtil;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.TicketType;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.ai.village.poi.PoiTypes;
import net.minecraft.world.entity.ai.village.poi.VillagePlace;
import net.minecraft.world.entity.ai.village.poi.VillagePlaceRecord;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.block.BlockPortal;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.levelgen.HeightMap;

public class PortalTravelAgent {
    private static final int TICKET_RADIUS = 3;
    private static final int SEARCH_RADIUS = 128;
    private static final int CREATE_RADIUS = 16;
    private static final int FRAME_HEIGHT = 5;
    private static final int FRAME_WIDTH = 4;
    private static final int FRAME_BOX = 3;
    private static final int FRAME_HEIGHT_START = -1;
    private static final int FRAME_HEIGHT_END = 4;
    private static final int FRAME_WIDTH_START = -1;
    private static final int FRAME_WIDTH_END = 3;
    private static final int FRAME_BOX_START = -1;
    private static final int FRAME_BOX_END = 2;
    private static final int NOTHING_FOUND = -1;
    private final WorldServer level;

    public PortalTravelAgent(WorldServer var0) {
        this.level = var0;
    }

    public Optional<BlockUtil.Rectangle> findPortalAround(BlockPosition var02, boolean var12, WorldBorder var2) {
        VillagePlace var3 = this.level.getPoiManager();
        int var4 = var12 ? 16 : 128;
        var3.ensureLoadedAndValid(this.level, var02, var4);
        Optional<VillagePlaceRecord> var5 = var3.getInSquare(var0 -> var0.is(PoiTypes.NETHER_PORTAL), var02, var4, VillagePlace.Occupancy.ANY).filter(var1 -> var2.isWithinBounds(var1.getPos())).sorted(Comparator.comparingDouble(var1 -> var1.getPos().distSqr(var02)).thenComparingInt(var0 -> var0.getPos().getY())).filter(var0 -> this.level.getBlockState(var0.getPos()).hasProperty(BlockProperties.HORIZONTAL_AXIS)).findFirst();
        return var5.map(var0 -> {
            BlockPosition var12 = var0.getPos();
            this.level.getChunkSource().addRegionTicket(TicketType.PORTAL, new ChunkCoordIntPair(var12), 3, var12);
            IBlockData var2 = this.level.getBlockState(var12);
            return BlockUtil.getLargestRectangleAround(var12, var2.getValue(BlockProperties.HORIZONTAL_AXIS), 21, EnumDirection.EnumAxis.Y, 21, var1 -> this.level.getBlockState((BlockPosition)var1) == var2);
        });
    }

    public Optional<BlockUtil.Rectangle> createPortal(BlockPosition var0, EnumDirection.EnumAxis var1) {
        int var17;
        int var16;
        int var15;
        EnumDirection var2 = EnumDirection.get(EnumDirection.EnumAxisDirection.POSITIVE, var1);
        double var3 = -1.0;
        BlockPosition var5 = null;
        double var6 = -1.0;
        BlockPosition var8 = null;
        WorldBorder var9 = this.level.getWorldBorder();
        int var10 = Math.min(this.level.getMaxBuildHeight(), this.level.getMinBuildHeight() + this.level.getLogicalHeight()) - 1;
        BlockPosition.MutableBlockPosition var11 = var0.mutable();
        for (BlockPosition.MutableBlockPosition var13 : BlockPosition.spiralAround(var0, 16, EnumDirection.EAST, EnumDirection.SOUTH)) {
            int var14 = Math.min(var10, this.level.getHeight(HeightMap.Type.MOTION_BLOCKING, var13.getX(), var13.getZ()));
            var15 = 1;
            if (!var9.isWithinBounds(var13) || !var9.isWithinBounds(var13.move(var2, 1))) continue;
            var13.move(var2.getOpposite(), 1);
            for (var16 = var14; var16 >= this.level.getMinBuildHeight(); --var16) {
                int var18;
                var13.setY(var16);
                if (!this.canPortalReplaceBlock(var13)) continue;
                var17 = var16;
                while (var16 > this.level.getMinBuildHeight() && this.canPortalReplaceBlock(var13.move(EnumDirection.DOWN))) {
                    --var16;
                }
                if (var16 + 4 > var10 || (var18 = var17 - var16) > 0 && var18 < 3) continue;
                var13.setY(var16);
                if (!this.canHostFrame(var13, var11, var2, 0)) continue;
                double var19 = var0.distSqr(var13);
                if (this.canHostFrame(var13, var11, var2, -1) && this.canHostFrame(var13, var11, var2, 1) && (var3 == -1.0 || var3 > var19)) {
                    var3 = var19;
                    var5 = var13.immutable();
                }
                if (var3 != -1.0 || var6 != -1.0 && !(var6 > var19)) continue;
                var6 = var19;
                var8 = var13.immutable();
            }
        }
        if (var3 == -1.0 && var6 != -1.0) {
            var5 = var8;
            var3 = var6;
        }
        if (var3 == -1.0) {
            int var13 = var10 - 9;
            int var12 = Math.max(this.level.getMinBuildHeight() - -1, 70);
            if (var13 < var12) {
                return Optional.empty();
            }
            var5 = new BlockPosition(var0.getX(), MathHelper.clamp(var0.getY(), var12, var13), var0.getZ()).immutable();
            EnumDirection var14 = var2.getClockWise();
            if (!var9.isWithinBounds(var5)) {
                return Optional.empty();
            }
            for (var15 = -1; var15 < 2; ++var15) {
                for (var16 = 0; var16 < 2; ++var16) {
                    for (var17 = -1; var17 < 3; ++var17) {
                        IBlockData var18 = var17 < 0 ? Blocks.OBSIDIAN.defaultBlockState() : Blocks.AIR.defaultBlockState();
                        var11.setWithOffset(var5, var16 * var2.getStepX() + var15 * var14.getStepX(), var17, var16 * var2.getStepZ() + var15 * var14.getStepZ());
                        this.level.setBlockAndUpdate(var11, var18);
                    }
                }
            }
        }
        for (int var12 = -1; var12 < 3; ++var12) {
            for (int var13 = -1; var13 < 4; ++var13) {
                if (var12 != -1 && var12 != 2 && var13 != -1 && var13 != 3) continue;
                var11.setWithOffset(var5, var12 * var2.getStepX(), var13, var12 * var2.getStepZ());
                this.level.setBlock(var11, Blocks.OBSIDIAN.defaultBlockState(), 3);
            }
        }
        IBlockData var12 = (IBlockData)Blocks.NETHER_PORTAL.defaultBlockState().setValue(BlockPortal.AXIS, var1);
        for (int var13 = 0; var13 < 2; ++var13) {
            for (int var14 = 0; var14 < 3; ++var14) {
                var11.setWithOffset(var5, var13 * var2.getStepX(), var14, var13 * var2.getStepZ());
                this.level.setBlock(var11, var12, 18);
            }
        }
        return Optional.of(new BlockUtil.Rectangle(var5.immutable(), 2, 3));
    }

    private boolean canPortalReplaceBlock(BlockPosition.MutableBlockPosition var0) {
        IBlockData var1 = this.level.getBlockState(var0);
        return var1.canBeReplaced() && var1.getFluidState().isEmpty();
    }

    private boolean canHostFrame(BlockPosition var0, BlockPosition.MutableBlockPosition var1, EnumDirection var2, int var3) {
        EnumDirection var4 = var2.getClockWise();
        for (int var5 = -1; var5 < 3; ++var5) {
            for (int var6 = -1; var6 < 4; ++var6) {
                var1.setWithOffset(var0, var2.getStepX() * var5 + var4.getStepX() * var3, var6, var2.getStepZ() * var5 + var4.getStepZ() * var3);
                if (var6 < 0 && !this.level.getBlockState(var1).isSolid()) {
                    return false;
                }
                if (var6 < 0 || this.canPortalReplaceBlock(var1)) continue;
                return false;
            }
        }
        return true;
    }
}

