/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.pathfinder;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.level.ChunkCache;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockCampfire;
import net.minecraft.world.level.block.BlockDoor;
import net.minecraft.world.level.block.BlockFenceGate;
import net.minecraft.world.level.block.BlockLeaves;
import net.minecraft.world.level.block.BlockMinecartTrackAbstract;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.level.pathfinder.PathDestination;
import net.minecraft.world.level.pathfinder.PathMode;
import net.minecraft.world.level.pathfinder.PathPoint;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.pathfinder.PathfinderAbstract;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.VoxelShape;

public class PathfinderNormal
extends PathfinderAbstract {
    public static final double SPACE_BETWEEN_WALL_POSTS = 0.5;
    private static final double DEFAULT_MOB_JUMP_HEIGHT = 1.125;
    private final Long2ObjectMap<PathType> pathTypesByPosCache = new Long2ObjectOpenHashMap();
    private final Object2BooleanMap<AxisAlignedBB> collisionCache = new Object2BooleanOpenHashMap();

    @Override
    public void prepare(ChunkCache var0, EntityInsentient var1) {
        super.prepare(var0, var1);
        var1.onPathfindingStart();
    }

    @Override
    public void done() {
        this.mob.onPathfindingDone();
        this.pathTypesByPosCache.clear();
        this.collisionCache.clear();
        super.done();
    }

    @Override
    public PathPoint getStart() {
        BlockPosition var3;
        BlockPosition.MutableBlockPosition var1 = new BlockPosition.MutableBlockPosition();
        int var0 = this.mob.getBlockY();
        IBlockData var2 = this.level.getBlockState(var1.set(this.mob.getX(), (double)var0, this.mob.getZ()));
        if (this.mob.canStandOnFluid(var2.getFluidState())) {
            while (this.mob.canStandOnFluid(var2.getFluidState())) {
                var2 = this.level.getBlockState(var1.set(this.mob.getX(), (double)(++var0), this.mob.getZ()));
            }
            --var0;
        } else if (this.canFloat() && this.mob.isInWater()) {
            while (var2.is(Blocks.WATER) || var2.getFluidState() == FluidTypes.WATER.getSource(false)) {
                var2 = this.level.getBlockState(var1.set(this.mob.getX(), (double)(++var0), this.mob.getZ()));
            }
            --var0;
        } else if (this.mob.onGround()) {
            var0 = MathHelper.floor(this.mob.getY() + 0.5);
        } else {
            var3 = this.mob.blockPosition();
            while ((this.level.getBlockState(var3).isAir() || this.level.getBlockState(var3).isPathfindable(this.level, var3, PathMode.LAND)) && var3.getY() > this.mob.level().getMinBuildHeight()) {
                var3 = var3.below();
            }
            var0 = var3.above().getY();
        }
        var3 = this.mob.blockPosition();
        if (!this.canStartAt(var1.set(var3.getX(), var0, var3.getZ()))) {
            AxisAlignedBB var4 = this.mob.getBoundingBox();
            if (this.canStartAt(var1.set(var4.minX, (double)var0, var4.minZ)) || this.canStartAt(var1.set(var4.minX, (double)var0, var4.maxZ)) || this.canStartAt(var1.set(var4.maxX, (double)var0, var4.minZ)) || this.canStartAt(var1.set(var4.maxX, (double)var0, var4.maxZ))) {
                return this.getStartNode(var1);
            }
        }
        return this.getStartNode(new BlockPosition(var3.getX(), var0, var3.getZ()));
    }

    protected PathPoint getStartNode(BlockPosition var0) {
        PathPoint var1 = this.getNode(var0);
        var1.type = this.getBlockPathType(this.mob, var1.asBlockPos());
        var1.costMalus = this.mob.getPathfindingMalus(var1.type);
        return var1;
    }

    protected boolean canStartAt(BlockPosition var0) {
        PathType var1 = this.getBlockPathType(this.mob, var0);
        return var1 != PathType.OPEN && this.mob.getPathfindingMalus(var1) >= 0.0f;
    }

    @Override
    public PathDestination getGoal(double var0, double var2, double var4) {
        return this.getTargetFromNode(this.getNode(MathHelper.floor(var0), MathHelper.floor(var2), MathHelper.floor(var4)));
    }

    @Override
    public int getNeighbors(PathPoint[] var0, PathPoint var1) {
        PathPoint var15;
        PathPoint var14;
        PathPoint var13;
        PathPoint var12;
        PathPoint var11;
        PathPoint var10;
        PathPoint var9;
        double var6;
        PathPoint var8;
        int var2 = 0;
        int var3 = 0;
        PathType var4 = this.getCachedBlockType(this.mob, var1.x, var1.y + 1, var1.z);
        PathType var5 = this.getCachedBlockType(this.mob, var1.x, var1.y, var1.z);
        if (this.mob.getPathfindingMalus(var4) >= 0.0f && var5 != PathType.STICKY_HONEY) {
            var3 = MathHelper.floor(Math.max(1.0f, this.mob.maxUpStep()));
        }
        if (this.isNeighborValid(var8 = this.findAcceptedNode(var1.x, var1.y, var1.z + 1, var3, var6 = this.getFloorLevel(new BlockPosition(var1.x, var1.y, var1.z)), EnumDirection.SOUTH, var5), var1)) {
            var0[var2++] = var8;
        }
        if (this.isNeighborValid(var9 = this.findAcceptedNode(var1.x - 1, var1.y, var1.z, var3, var6, EnumDirection.WEST, var5), var1)) {
            var0[var2++] = var9;
        }
        if (this.isNeighborValid(var10 = this.findAcceptedNode(var1.x + 1, var1.y, var1.z, var3, var6, EnumDirection.EAST, var5), var1)) {
            var0[var2++] = var10;
        }
        if (this.isNeighborValid(var11 = this.findAcceptedNode(var1.x, var1.y, var1.z - 1, var3, var6, EnumDirection.NORTH, var5), var1)) {
            var0[var2++] = var11;
        }
        if (this.isDiagonalValid(var1, var9, var11, var12 = this.findAcceptedNode(var1.x - 1, var1.y, var1.z - 1, var3, var6, EnumDirection.NORTH, var5))) {
            var0[var2++] = var12;
        }
        if (this.isDiagonalValid(var1, var10, var11, var13 = this.findAcceptedNode(var1.x + 1, var1.y, var1.z - 1, var3, var6, EnumDirection.NORTH, var5))) {
            var0[var2++] = var13;
        }
        if (this.isDiagonalValid(var1, var9, var8, var14 = this.findAcceptedNode(var1.x - 1, var1.y, var1.z + 1, var3, var6, EnumDirection.SOUTH, var5))) {
            var0[var2++] = var14;
        }
        if (this.isDiagonalValid(var1, var10, var8, var15 = this.findAcceptedNode(var1.x + 1, var1.y, var1.z + 1, var3, var6, EnumDirection.SOUTH, var5))) {
            var0[var2++] = var15;
        }
        return var2;
    }

    protected boolean isNeighborValid(@Nullable PathPoint var0, PathPoint var1) {
        return var0 != null && !var0.closed && (var0.costMalus >= 0.0f || var1.costMalus < 0.0f);
    }

    protected boolean isDiagonalValid(PathPoint var0, @Nullable PathPoint var1, @Nullable PathPoint var2, @Nullable PathPoint var3) {
        if (var3 == null || var2 == null || var1 == null) {
            return false;
        }
        if (var3.closed) {
            return false;
        }
        if (var2.y > var0.y || var1.y > var0.y) {
            return false;
        }
        if (var1.type == PathType.WALKABLE_DOOR || var2.type == PathType.WALKABLE_DOOR || var3.type == PathType.WALKABLE_DOOR) {
            return false;
        }
        boolean var4 = var2.type == PathType.FENCE && var1.type == PathType.FENCE && (double)this.mob.getBbWidth() < 0.5;
        return var3.costMalus >= 0.0f && (var2.y < var0.y || var2.costMalus >= 0.0f || var4) && (var1.y < var0.y || var1.costMalus >= 0.0f || var4);
    }

    private static boolean doesBlockHavePartialCollision(PathType var0) {
        return var0 == PathType.FENCE || var0 == PathType.DOOR_WOOD_CLOSED || var0 == PathType.DOOR_IRON_CLOSED;
    }

    private boolean canReachWithoutCollision(PathPoint var0) {
        AxisAlignedBB var1 = this.mob.getBoundingBox();
        Vec3D var2 = new Vec3D((double)var0.x - this.mob.getX() + var1.getXsize() / 2.0, (double)var0.y - this.mob.getY() + var1.getYsize() / 2.0, (double)var0.z - this.mob.getZ() + var1.getZsize() / 2.0);
        int var3 = MathHelper.ceil(var2.length() / var1.getSize());
        var2 = var2.scale(1.0f / (float)var3);
        for (int var4 = 1; var4 <= var3; ++var4) {
            if (!this.hasCollisions(var1 = var1.move(var2))) continue;
            return false;
        }
        return true;
    }

    protected double getFloorLevel(BlockPosition var0) {
        if ((this.canFloat() || this.isAmphibious()) && this.level.getFluidState(var0).is(TagsFluid.WATER)) {
            return (double)var0.getY() + 0.5;
        }
        return PathfinderNormal.getFloorLevel(this.level, var0);
    }

    public static double getFloorLevel(IBlockAccess var0, BlockPosition var1) {
        BlockPosition var2 = var1.below();
        VoxelShape var3 = var0.getBlockState(var2).getCollisionShape(var0, var2);
        return (double)var2.getY() + (var3.isEmpty() ? 0.0 : var3.max(EnumDirection.EnumAxis.Y));
    }

    protected boolean isAmphibious() {
        return false;
    }

    @Nullable
    protected PathPoint findAcceptedNode(int var0, int var1, int var2, int var3, double var4, EnumDirection var6, PathType var7) {
        double var18;
        double var16;
        AxisAlignedBB var20;
        PathPoint var8 = null;
        BlockPosition.MutableBlockPosition var9 = new BlockPosition.MutableBlockPosition();
        double var10 = this.getFloorLevel(var9.set(var0, var1, var2));
        if (var10 - var4 > this.getMobJumpHeight()) {
            return null;
        }
        PathType var12 = this.getCachedBlockType(this.mob, var0, var1, var2);
        float var13 = this.mob.getPathfindingMalus(var12);
        double var14 = (double)this.mob.getBbWidth() / 2.0;
        if (var13 >= 0.0f) {
            var8 = this.getNodeAndUpdateCostToMax(var0, var1, var2, var12, var13);
        }
        if (PathfinderNormal.doesBlockHavePartialCollision(var7) && var8 != null && var8.costMalus >= 0.0f && !this.canReachWithoutCollision(var8)) {
            var8 = null;
        }
        if (var12 == PathType.WALKABLE || this.isAmphibious() && var12 == PathType.WATER) {
            return var8;
        }
        if ((var8 == null || var8.costMalus < 0.0f) && var3 > 0 && (var12 != PathType.FENCE || this.canWalkOverFences()) && var12 != PathType.UNPASSABLE_RAIL && var12 != PathType.TRAPDOOR && var12 != PathType.POWDER_SNOW && (var8 = this.findAcceptedNode(var0, var1 + 1, var2, var3 - 1, var4, var6, var7)) != null && (var8.type == PathType.OPEN || var8.type == PathType.WALKABLE) && this.mob.getBbWidth() < 1.0f && this.hasCollisions(var20 = new AxisAlignedBB((var16 = (double)(var0 - var6.getStepX()) + 0.5) - var14, this.getFloorLevel(var9.set(var16, (double)(var1 + 1), var18 = (double)(var2 - var6.getStepZ()) + 0.5)) + 0.001, var18 - var14, var16 + var14, (double)this.mob.getBbHeight() + this.getFloorLevel(var9.set((double)var8.x, (double)var8.y, (double)var8.z)) - 0.002, var18 + var14))) {
            var8 = null;
        }
        if (!this.isAmphibious() && var12 == PathType.WATER && !this.canFloat()) {
            if (this.getCachedBlockType(this.mob, var0, var1 - 1, var2) != PathType.WATER) {
                return var8;
            }
            while (var1 > this.mob.level().getMinBuildHeight()) {
                if ((var12 = this.getCachedBlockType(this.mob, var0, --var1, var2)) == PathType.WATER) {
                    var8 = this.getNodeAndUpdateCostToMax(var0, var1, var2, var12, this.mob.getPathfindingMalus(var12));
                    continue;
                }
                return var8;
            }
        }
        if (var12 == PathType.OPEN) {
            int var162 = 0;
            int var17 = var1;
            while (var12 == PathType.OPEN) {
                if (--var1 < this.mob.level().getMinBuildHeight()) {
                    return this.getBlockedNode(var0, var17, var2);
                }
                if (var162++ >= this.mob.getMaxFallDistance()) {
                    return this.getBlockedNode(var0, var1, var2);
                }
                var12 = this.getCachedBlockType(this.mob, var0, var1, var2);
                var13 = this.mob.getPathfindingMalus(var12);
                if (var12 != PathType.OPEN && var13 >= 0.0f) {
                    var8 = this.getNodeAndUpdateCostToMax(var0, var1, var2, var12, var13);
                    break;
                }
                if (!(var13 < 0.0f)) continue;
                return this.getBlockedNode(var0, var1, var2);
            }
        }
        if (PathfinderNormal.doesBlockHavePartialCollision(var12) && var8 == null) {
            var8 = this.getNode(var0, var1, var2);
            var8.closed = true;
            var8.type = var12;
            var8.costMalus = var12.getMalus();
        }
        return var8;
    }

    private double getMobJumpHeight() {
        return Math.max(1.125, (double)this.mob.maxUpStep());
    }

    private PathPoint getNodeAndUpdateCostToMax(int var0, int var1, int var2, PathType var3, float var4) {
        PathPoint var5 = this.getNode(var0, var1, var2);
        var5.type = var3;
        var5.costMalus = Math.max(var5.costMalus, var4);
        return var5;
    }

    private PathPoint getBlockedNode(int var0, int var1, int var2) {
        PathPoint var3 = this.getNode(var0, var1, var2);
        var3.type = PathType.BLOCKED;
        var3.costMalus = -1.0f;
        return var3;
    }

    private boolean hasCollisions(AxisAlignedBB var0) {
        return this.collisionCache.computeIfAbsent((Object)var0, var1 -> !this.level.noCollision(this.mob, var0));
    }

    @Override
    public PathType getBlockPathType(IBlockAccess var0, int var1, int var2, int var3, EntityInsentient var4) {
        EnumSet<PathType> var5 = EnumSet.noneOf(PathType.class);
        PathType var6 = PathType.BLOCKED;
        var6 = this.getBlockPathTypes(var0, var1, var2, var3, var5, var6, var4.blockPosition());
        if (var5.contains((Object)PathType.FENCE)) {
            return PathType.FENCE;
        }
        if (var5.contains((Object)PathType.UNPASSABLE_RAIL)) {
            return PathType.UNPASSABLE_RAIL;
        }
        PathType var7 = PathType.BLOCKED;
        for (PathType var9 : var5) {
            if (var4.getPathfindingMalus(var9) < 0.0f) {
                return var9;
            }
            if (!(var4.getPathfindingMalus(var9) >= var4.getPathfindingMalus(var7))) continue;
            var7 = var9;
        }
        if (var6 == PathType.OPEN && var4.getPathfindingMalus(var7) == 0.0f && this.entityWidth <= 1) {
            return PathType.OPEN;
        }
        return var7;
    }

    public PathType getBlockPathTypes(IBlockAccess var0, int var1, int var2, int var3, EnumSet<PathType> var4, PathType var5, BlockPosition var6) {
        for (int var7 = 0; var7 < this.entityWidth; ++var7) {
            for (int var8 = 0; var8 < this.entityHeight; ++var8) {
                for (int var9 = 0; var9 < this.entityDepth; ++var9) {
                    int var10 = var7 + var1;
                    int var11 = var8 + var2;
                    int var12 = var9 + var3;
                    PathType var13 = this.getBlockPathType(var0, var10, var11, var12);
                    var13 = this.evaluateBlockPathType(var0, var6, var13);
                    if (var7 == 0 && var8 == 0 && var9 == 0) {
                        var5 = var13;
                    }
                    var4.add(var13);
                }
            }
        }
        return var5;
    }

    protected PathType evaluateBlockPathType(IBlockAccess var0, BlockPosition var1, PathType var2) {
        boolean var3 = this.canPassDoors();
        if (var2 == PathType.DOOR_WOOD_CLOSED && this.canOpenDoors() && var3) {
            var2 = PathType.WALKABLE_DOOR;
        }
        if (var2 == PathType.DOOR_OPEN && !var3) {
            var2 = PathType.BLOCKED;
        }
        if (var2 == PathType.RAIL && !(var0.getBlockState(var1).getBlock() instanceof BlockMinecartTrackAbstract) && !(var0.getBlockState(var1.below()).getBlock() instanceof BlockMinecartTrackAbstract)) {
            var2 = PathType.UNPASSABLE_RAIL;
        }
        return var2;
    }

    protected PathType getBlockPathType(EntityInsentient var0, BlockPosition var1) {
        return this.getCachedBlockType(var0, var1.getX(), var1.getY(), var1.getZ());
    }

    protected PathType getCachedBlockType(EntityInsentient var0, int var1, int var2, int var3) {
        return (PathType)((Object)this.pathTypesByPosCache.computeIfAbsent(BlockPosition.asLong(var1, var2, var3), var4 -> this.getBlockPathType(this.level, var1, var2, var3, var0)));
    }

    @Override
    public PathType getBlockPathType(IBlockAccess var0, int var1, int var2, int var3) {
        return PathfinderNormal.getBlockPathTypeStatic(var0, new BlockPosition.MutableBlockPosition(var1, var2, var3));
    }

    public static PathType getBlockPathTypeStatic(IBlockAccess var0, BlockPosition.MutableBlockPosition var1) {
        int var2 = var1.getX();
        int var3 = var1.getY();
        int var4 = var1.getZ();
        PathType var5 = PathfinderNormal.getBlockPathTypeRaw(var0, var1);
        if (var5 == PathType.OPEN && var3 >= var0.getMinBuildHeight() + 1) {
            PathType var6 = PathfinderNormal.getBlockPathTypeRaw(var0, var1.set(var2, var3 - 1, var4));
            PathType pathType = var5 = var6 == PathType.WALKABLE || var6 == PathType.OPEN || var6 == PathType.WATER || var6 == PathType.LAVA ? PathType.OPEN : PathType.WALKABLE;
            if (var6 == PathType.DAMAGE_FIRE) {
                var5 = PathType.DAMAGE_FIRE;
            }
            if (var6 == PathType.DAMAGE_OTHER) {
                var5 = PathType.DAMAGE_OTHER;
            }
            if (var6 == PathType.STICKY_HONEY) {
                var5 = PathType.STICKY_HONEY;
            }
            if (var6 == PathType.POWDER_SNOW) {
                var5 = PathType.DANGER_POWDER_SNOW;
            }
            if (var6 == PathType.DAMAGE_CAUTIOUS) {
                var5 = PathType.DAMAGE_CAUTIOUS;
            }
        }
        if (var5 == PathType.WALKABLE) {
            var5 = PathfinderNormal.checkNeighbourBlocks(var0, var1.set(var2, var3, var4), var5);
        }
        return var5;
    }

    public static PathType checkNeighbourBlocks(IBlockAccess var0, BlockPosition.MutableBlockPosition var1, PathType var2) {
        int var3 = var1.getX();
        int var4 = var1.getY();
        int var5 = var1.getZ();
        for (int var6 = -1; var6 <= 1; ++var6) {
            for (int var7 = -1; var7 <= 1; ++var7) {
                for (int var8 = -1; var8 <= 1; ++var8) {
                    if (var6 == 0 && var8 == 0) continue;
                    var1.set(var3 + var6, var4 + var7, var5 + var8);
                    IBlockData var9 = var0.getBlockState(var1);
                    if (var9.is(Blocks.CACTUS) || var9.is(Blocks.SWEET_BERRY_BUSH)) {
                        return PathType.DANGER_OTHER;
                    }
                    if (PathfinderNormal.isBurningBlock(var9)) {
                        return PathType.DANGER_FIRE;
                    }
                    if (var0.getFluidState(var1).is(TagsFluid.WATER)) {
                        return PathType.WATER_BORDER;
                    }
                    if (!var9.is(Blocks.WITHER_ROSE) && !var9.is(Blocks.POINTED_DRIPSTONE)) continue;
                    return PathType.DAMAGE_CAUTIOUS;
                }
            }
        }
        return var2;
    }

    protected static PathType getBlockPathTypeRaw(IBlockAccess var0, BlockPosition var1) {
        IBlockData var2 = var0.getBlockState(var1);
        Block var3 = var2.getBlock();
        if (var2.isAir()) {
            return PathType.OPEN;
        }
        if (var2.is(TagsBlock.TRAPDOORS) || var2.is(Blocks.LILY_PAD) || var2.is(Blocks.BIG_DRIPLEAF)) {
            return PathType.TRAPDOOR;
        }
        if (var2.is(Blocks.POWDER_SNOW)) {
            return PathType.POWDER_SNOW;
        }
        if (var2.is(Blocks.CACTUS) || var2.is(Blocks.SWEET_BERRY_BUSH)) {
            return PathType.DAMAGE_OTHER;
        }
        if (var2.is(Blocks.HONEY_BLOCK)) {
            return PathType.STICKY_HONEY;
        }
        if (var2.is(Blocks.COCOA)) {
            return PathType.COCOA;
        }
        if (var2.is(Blocks.WITHER_ROSE) || var2.is(Blocks.POINTED_DRIPSTONE)) {
            return PathType.DAMAGE_CAUTIOUS;
        }
        Fluid var4 = var0.getFluidState(var1);
        if (var4.is(TagsFluid.LAVA)) {
            return PathType.LAVA;
        }
        if (PathfinderNormal.isBurningBlock(var2)) {
            return PathType.DAMAGE_FIRE;
        }
        if (var3 instanceof BlockDoor) {
            BlockDoor var5 = (BlockDoor)var3;
            if (var2.getValue(BlockDoor.OPEN).booleanValue()) {
                return PathType.DOOR_OPEN;
            }
            return var5.type().canOpenByHand() ? PathType.DOOR_WOOD_CLOSED : PathType.DOOR_IRON_CLOSED;
        }
        if (var3 instanceof BlockMinecartTrackAbstract) {
            return PathType.RAIL;
        }
        if (var3 instanceof BlockLeaves) {
            return PathType.LEAVES;
        }
        if (var2.is(TagsBlock.FENCES) || var2.is(TagsBlock.WALLS) || var3 instanceof BlockFenceGate && !var2.getValue(BlockFenceGate.OPEN).booleanValue()) {
            return PathType.FENCE;
        }
        if (!var2.isPathfindable(var0, var1, PathMode.LAND)) {
            return PathType.BLOCKED;
        }
        if (var4.is(TagsFluid.WATER)) {
            return PathType.WATER;
        }
        return PathType.OPEN;
    }

    public static boolean isBurningBlock(IBlockData var0) {
        return var0.is(TagsBlock.FIRE) || var0.is(Blocks.LAVA) || var0.is(Blocks.MAGMA_BLOCK) || BlockCampfire.isLitCampfire(var0) || var0.is(Blocks.LAVA_CAULDRON);
    }
}

