/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.pathfinder;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.util.profiling.metrics.MetricCategory;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.level.ChunkCache;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.level.pathfinder.PathDestination;
import net.minecraft.world.level.pathfinder.PathEntity;
import net.minecraft.world.level.pathfinder.PathPoint;
import net.minecraft.world.level.pathfinder.PathfinderAbstract;

public class Pathfinder {
    private static final float FUDGING = 1.5f;
    private final PathPoint[] neighbors = new PathPoint[32];
    private final int maxVisitedNodes;
    private final PathfinderAbstract nodeEvaluator;
    private static final boolean DEBUG = false;
    private final Path openSet = new Path();

    public Pathfinder(PathfinderAbstract var0, int var1) {
        this.nodeEvaluator = var0;
        this.maxVisitedNodes = var1;
    }

    @Nullable
    public PathEntity findPath(ChunkCache var02, EntityInsentient var1, Set<BlockPosition> var2, float var3, int var4, float var5) {
        this.openSet.clear();
        this.nodeEvaluator.prepare(var02, var1);
        PathPoint var6 = this.nodeEvaluator.getStart();
        if (var6 == null) {
            return null;
        }
        Map<PathDestination, BlockPosition> var7 = var2.stream().collect(Collectors.toMap(var0 -> this.nodeEvaluator.getGoal(var0.getX(), var0.getY(), var0.getZ()), Function.identity()));
        PathEntity var8 = this.findPath(var02.getProfiler(), var6, var7, var3, var4, var5);
        this.nodeEvaluator.done();
        return var8;
    }

    @Nullable
    private PathEntity findPath(GameProfilerFiller var0, PathPoint var12, Map<PathDestination, BlockPosition> var2, float var3, int var4, float var5) {
        Object var11;
        var0.push("find_path");
        var0.markForCharting(MetricCategory.PATH_FINDING);
        Set<PathDestination> var6 = var2.keySet();
        var12.g = 0.0f;
        var12.f = var12.h = this.getBestH(var12, var6);
        this.openSet.clear();
        this.openSet.insert(var12);
        ImmutableSet var7 = ImmutableSet.of();
        int var8 = 0;
        HashSet var9 = Sets.newHashSetWithExpectedSize((int)var6.size());
        int var10 = (int)((float)this.maxVisitedNodes * var5);
        while (!this.openSet.isEmpty() && ++var8 < var10) {
            var11 = this.openSet.pop();
            ((PathPoint)var11).closed = true;
            for (PathDestination var13 : var6) {
                if (!(((PathPoint)var11).distanceManhattan(var13) <= (float)var4)) continue;
                var13.setReached();
                var9.add(var13);
            }
            if (!var9.isEmpty()) break;
            if (((PathPoint)var11).distanceTo(var12) >= var3) continue;
            int var122 = this.nodeEvaluator.getNeighbors(this.neighbors, (PathPoint)var11);
            for (int var13 = 0; var13 < var122; ++var13) {
                PathPoint var14 = this.neighbors[var13];
                float var15 = this.distance((PathPoint)var11, var14);
                var14.walkedDistance = ((PathPoint)var11).walkedDistance + var15;
                float var16 = ((PathPoint)var11).g + var15 + var14.costMalus;
                if (!(var14.walkedDistance < var3) || var14.inOpenSet() && !(var16 < var14.g)) continue;
                var14.cameFrom = var11;
                var14.g = var16;
                var14.h = this.getBestH(var14, var6) * 1.5f;
                if (var14.inOpenSet()) {
                    this.openSet.changeCost(var14, var14.g + var14.h);
                    continue;
                }
                var14.f = var14.g + var14.h;
                this.openSet.insert(var14);
            }
        }
        var11 = !var9.isEmpty() ? var9.stream().map(var1 -> this.reconstructPath(var1.getBestNode(), (BlockPosition)var2.get(var1), true)).min(Comparator.comparingInt(PathEntity::getNodeCount)) : var6.stream().map(var1 -> this.reconstructPath(var1.getBestNode(), (BlockPosition)var2.get(var1), false)).min(Comparator.comparingDouble(PathEntity::getDistToTarget).thenComparingInt(PathEntity::getNodeCount));
        var0.pop();
        if (!((Optional)var11).isPresent()) {
            return null;
        }
        PathEntity var123 = (PathEntity)((Optional)var11).get();
        return var123;
    }

    protected float distance(PathPoint var0, PathPoint var1) {
        return var0.distanceTo(var1);
    }

    private float getBestH(PathPoint var0, Set<PathDestination> var1) {
        float var2 = Float.MAX_VALUE;
        for (PathDestination var4 : var1) {
            float var5 = var0.distanceTo(var4);
            var4.updateBest(var5, var0);
            var2 = Math.min(var5, var2);
        }
        return var2;
    }

    private PathEntity reconstructPath(PathPoint var0, BlockPosition var1, boolean var2) {
        ArrayList var3 = Lists.newArrayList();
        PathPoint var4 = var0;
        var3.add(0, var4);
        while (var4.cameFrom != null) {
            var4 = var4.cameFrom;
            var3.add(0, var4);
        }
        return new PathEntity(var3, var1, var2);
    }
}

