/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure.templatesystem;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.DataFixer;
import com.mojang.logging.LogUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.FileUtils;
import net.minecraft.ResourceKeyInvalidException;
import net.minecraft.SharedConstants;
import net.minecraft.core.HolderGetter;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTCompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.packs.resources.IResourceManager;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructure;
import net.minecraft.world.level.storage.Convertable;
import net.minecraft.world.level.storage.SavedFile;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;

public class StructureTemplateManager {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final String STRUCTURE_DIRECTORY_NAME = "structures";
    private static final String TEST_STRUCTURES_DIR = "gameteststructures";
    private static final String STRUCTURE_FILE_EXTENSION = ".nbt";
    private static final String STRUCTURE_TEXT_FILE_EXTENSION = ".snbt";
    public final Map<MinecraftKey, Optional<DefinedStructure>> structureRepository = Maps.newConcurrentMap();
    private final DataFixer fixerUpper;
    private IResourceManager resourceManager;
    private final Path generatedDir;
    private final List<b> sources;
    private final HolderGetter<Block> blockLookup;
    private static final FileToIdConverter LISTER = new FileToIdConverter("structures", ".nbt");

    public StructureTemplateManager(IResourceManager var0, Convertable.ConversionSession var1, DataFixer var2, HolderGetter<Block> var3) {
        this.resourceManager = var0;
        this.fixerUpper = var2;
        this.generatedDir = var1.getLevelPath(SavedFile.GENERATED_DIR).normalize();
        this.blockLookup = var3;
        ImmutableList.Builder var4 = ImmutableList.builder();
        var4.add((Object)new b(this::loadFromGenerated, this::listGenerated));
        if (SharedConstants.IS_RUNNING_IN_IDE) {
            var4.add((Object)new b(this::loadFromTestStructures, this::listTestStructures));
        }
        var4.add((Object)new b(this::loadFromResource, this::listResources));
        this.sources = var4.build();
    }

    public DefinedStructure getOrCreate(MinecraftKey var0) {
        Optional<DefinedStructure> var1 = this.get(var0);
        if (var1.isPresent()) {
            return var1.get();
        }
        DefinedStructure var2 = new DefinedStructure();
        this.structureRepository.put(var0, Optional.of(var2));
        return var2;
    }

    public Optional<DefinedStructure> get(MinecraftKey var0) {
        return this.structureRepository.computeIfAbsent(var0, this::tryLoad);
    }

    public Stream<MinecraftKey> listTemplates() {
        return this.sources.stream().flatMap(var0 -> var0.lister().get()).distinct();
    }

    private Optional<DefinedStructure> tryLoad(MinecraftKey var0) {
        for (b var2 : this.sources) {
            try {
                Optional<DefinedStructure> var3 = var2.loader().apply(var0);
                if (!var3.isPresent()) continue;
                return var3;
            }
            catch (Exception exception) {
            }
        }
        return Optional.empty();
    }

    public void onResourceManagerReload(IResourceManager var0) {
        this.resourceManager = var0;
        this.structureRepository.clear();
    }

    public Optional<DefinedStructure> loadFromResource(MinecraftKey var0) {
        MinecraftKey var12 = LISTER.idToFile(var0);
        return this.load(() -> this.resourceManager.open(var12), var1 -> LOGGER.error("Couldn't load structure {}", (Object)var0, var1));
    }

    private Stream<MinecraftKey> listResources() {
        return LISTER.listMatchingResources(this.resourceManager).keySet().stream().map(LISTER::fileToId);
    }

    private Optional<DefinedStructure> loadFromTestStructures(MinecraftKey var0) {
        return this.loadFromSnbt(var0, Paths.get(TEST_STRUCTURES_DIR, new String[0]));
    }

    private Stream<MinecraftKey> listTestStructures() {
        return this.listFolderContents(Paths.get(TEST_STRUCTURES_DIR, new String[0]), "minecraft", STRUCTURE_TEXT_FILE_EXTENSION);
    }

    public Optional<DefinedStructure> loadFromGenerated(MinecraftKey var0) {
        if (!Files.isDirectory(this.generatedDir, new LinkOption[0])) {
            return Optional.empty();
        }
        Path var12 = StructureTemplateManager.createAndValidatePathToStructure(this.generatedDir, var0, STRUCTURE_FILE_EXTENSION);
        return this.load(() -> new FileInputStream(var12.toFile()), var1 -> LOGGER.error("Couldn't load structure from {}", (Object)var12, var1));
    }

    private Stream<MinecraftKey> listGenerated() {
        if (!Files.isDirectory(this.generatedDir, new LinkOption[0])) {
            return Stream.empty();
        }
        try {
            return Files.list(this.generatedDir).filter(var0 -> Files.isDirectory(var0, new LinkOption[0])).flatMap(var0 -> this.listGeneratedInNamespace((Path)var0));
        }
        catch (IOException var02) {
            return Stream.empty();
        }
    }

    private Stream<MinecraftKey> listGeneratedInNamespace(Path var0) {
        Path var1 = var0.resolve(STRUCTURE_DIRECTORY_NAME);
        return this.listFolderContents(var1, var0.getFileName().toString(), STRUCTURE_FILE_EXTENSION);
    }

    private Stream<MinecraftKey> listFolderContents(Path var0, String var12, String var2) {
        if (!Files.isDirectory(var0, new LinkOption[0])) {
            return Stream.empty();
        }
        int var32 = var2.length();
        Function<String, String> var42 = var1 -> var1.substring(0, var1.length() - var32);
        try {
            return Files.walk(var0, new FileVisitOption[0]).filter(var1 -> var1.toString().endsWith(var2)).mapMulti((var3, var4) -> {
                try {
                    var4.accept(new MinecraftKey(var12, (String)var42.apply(this.relativize(var0, (Path)var3))));
                }
                catch (ResourceKeyInvalidException var5) {
                    LOGGER.error("Invalid location while listing pack contents", (Throwable)var5);
                }
            });
        }
        catch (IOException var5) {
            LOGGER.error("Failed to list folder contents", (Throwable)var5);
            return Stream.empty();
        }
    }

    private String relativize(Path var0, Path var1) {
        return var0.relativize(var1).toString().replace(File.separator, "/");
    }

    private Optional<DefinedStructure> loadFromSnbt(MinecraftKey var0, Path var1) {
        Optional<DefinedStructure> optional;
        block10: {
            if (!Files.isDirectory(var1, new LinkOption[0])) {
                return Optional.empty();
            }
            Path var2 = FileUtils.createPathToResource(var1, var0.getPath(), STRUCTURE_TEXT_FILE_EXTENSION);
            BufferedReader var3 = Files.newBufferedReader(var2);
            try {
                String var4 = IOUtils.toString((Reader)var3);
                optional = Optional.of(this.readStructure(GameProfileSerializer.snbtToStructure(var4)));
                if (var3 == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (var3 != null) {
                        try {
                            var3.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (NoSuchFileException var32) {
                    return Optional.empty();
                }
                catch (CommandSyntaxException | IOException var33) {
                    LOGGER.error("Couldn't load structure from {}", (Object)var2, (Object)var33);
                    return Optional.empty();
                }
            }
            var3.close();
        }
        return optional;
    }

    private Optional<DefinedStructure> load(a var0, Consumer<Throwable> var1) {
        Optional<DefinedStructure> optional;
        block9: {
            InputStream var2 = var0.open();
            try {
                optional = Optional.of(this.readStructure(var2));
                if (var2 == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (var2 != null) {
                        try {
                            var2.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (FileNotFoundException var22) {
                    return Optional.empty();
                }
                catch (Throwable var23) {
                    var1.accept(var23);
                    return Optional.empty();
                }
            }
            var2.close();
        }
        return optional;
    }

    public DefinedStructure readStructure(InputStream var0) throws IOException {
        NBTTagCompound var1 = NBTCompressedStreamTools.readCompressed(var0);
        return this.readStructure(var1);
    }

    public DefinedStructure readStructure(NBTTagCompound var0) {
        DefinedStructure var1 = new DefinedStructure();
        int var2 = GameProfileSerializer.getDataVersion(var0, 500);
        var1.load(this.blockLookup, DataFixTypes.STRUCTURE.updateToCurrentVersion(this.fixerUpper, var0, var2));
        return var1;
    }

    public boolean save(MinecraftKey var0) {
        Optional<DefinedStructure> var1 = this.structureRepository.get(var0);
        if (!var1.isPresent()) {
            return false;
        }
        DefinedStructure var2 = var1.get();
        Path var3 = StructureTemplateManager.createAndValidatePathToStructure(this.generatedDir, var0, STRUCTURE_FILE_EXTENSION);
        Path var4 = var3.getParent();
        if (var4 == null) {
            return false;
        }
        try {
            Files.createDirectories(Files.exists(var4, new LinkOption[0]) ? var4.toRealPath(new LinkOption[0]) : var4, new FileAttribute[0]);
        }
        catch (IOException var5) {
            LOGGER.error("Failed to create parent directory: {}", (Object)var4);
            return false;
        }
        NBTTagCompound var5 = var2.save(new NBTTagCompound());
        try (FileOutputStream var6 = new FileOutputStream(var3.toFile());){
            NBTCompressedStreamTools.writeCompressed(var5, var6);
        }
        catch (Throwable var62) {
            return false;
        }
        return true;
    }

    public Path getPathToGeneratedStructure(MinecraftKey var0, String var1) {
        return StructureTemplateManager.createPathToStructure(this.generatedDir, var0, var1);
    }

    public static Path createPathToStructure(Path var0, MinecraftKey var1, String var2) {
        try {
            Path var3 = var0.resolve(var1.getNamespace());
            Path var4 = var3.resolve(STRUCTURE_DIRECTORY_NAME);
            return FileUtils.createPathToResource(var4, var1.getPath(), var2);
        }
        catch (InvalidPathException var3) {
            throw new ResourceKeyInvalidException("Invalid resource path: " + var1, var3);
        }
    }

    public static Path createAndValidatePathToStructure(Path var0, MinecraftKey var1, String var2) {
        if (var1.getPath().contains("//")) {
            throw new ResourceKeyInvalidException("Invalid resource path: " + var1);
        }
        Path var3 = StructureTemplateManager.createPathToStructure(var0, var1, var2);
        if (!(var3.startsWith(var0) && FileUtils.isPathNormalized(var3) && FileUtils.isPathPortable(var3))) {
            throw new ResourceKeyInvalidException("Invalid resource path: " + var3);
        }
        return var3;
    }

    public void remove(MinecraftKey var0) {
        this.structureRepository.remove(var0);
    }

    record b(Function<MinecraftKey, Optional<DefinedStructure>> loader, Supplier<Stream<MinecraftKey>> lister) {
    }

    @FunctionalInterface
    static interface a {
        public InputStream open() throws IOException;
    }
}

