/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure.templatesystem;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructure;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureInfo;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureStructureProcessorType;

public class DefinedStructureProcessorGravity
extends DefinedStructureProcessor {
    public static final Codec<DefinedStructureProcessorGravity> CODEC = RecordCodecBuilder.create(var02 -> var02.group((App)HeightMap.Type.CODEC.fieldOf("heightmap").orElse((Object)HeightMap.Type.WORLD_SURFACE_WG).forGetter(var0 -> var0.heightmap), (App)Codec.INT.fieldOf("offset").orElse((Object)0).forGetter(var0 -> var0.offset)).apply((Applicative)var02, DefinedStructureProcessorGravity::new));
    private final HeightMap.Type heightmap;
    private final int offset;

    public DefinedStructureProcessorGravity(HeightMap.Type var0, int var1) {
        this.heightmap = var0;
        this.offset = var1;
    }

    @Override
    @Nullable
    public DefinedStructure.BlockInfo processBlock(IWorldReader var0, BlockPosition var1, BlockPosition var2, DefinedStructure.BlockInfo var3, DefinedStructure.BlockInfo var4, DefinedStructureInfo var5) {
        HeightMap.Type var6 = var0 instanceof WorldServer ? (this.heightmap == HeightMap.Type.WORLD_SURFACE_WG ? HeightMap.Type.WORLD_SURFACE : (this.heightmap == HeightMap.Type.OCEAN_FLOOR_WG ? HeightMap.Type.OCEAN_FLOOR : this.heightmap)) : this.heightmap;
        BlockPosition var7 = var4.pos();
        int var8 = var0.getHeight(var6, var7.getX(), var7.getZ()) + this.offset;
        int var9 = var3.pos().getY();
        return new DefinedStructure.BlockInfo(new BlockPosition(var7.getX(), var8 + var9, var7.getZ()), var4.state(), var4.nbt());
    }

    @Override
    protected DefinedStructureStructureProcessorType<?> getType() {
        return DefinedStructureStructureProcessorType.GRAVITY;
    }
}

