/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature.treedecorators;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashSet;
import java.util.List;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.levelgen.feature.stateproviders.WorldGenFeatureStateProvider;
import net.minecraft.world.level.levelgen.feature.treedecorators.WorldGenFeatureTree;
import net.minecraft.world.level.levelgen.feature.treedecorators.WorldGenFeatureTrees;

public class AttachedToLeavesDecorator
extends WorldGenFeatureTree {
    public static final Codec<AttachedToLeavesDecorator> CODEC = RecordCodecBuilder.create(var02 -> var02.group((App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("probability").forGetter(var0 -> Float.valueOf(var0.probability)), (App)Codec.intRange((int)0, (int)16).fieldOf("exclusion_radius_xz").forGetter(var0 -> var0.exclusionRadiusXZ), (App)Codec.intRange((int)0, (int)16).fieldOf("exclusion_radius_y").forGetter(var0 -> var0.exclusionRadiusY), (App)WorldGenFeatureStateProvider.CODEC.fieldOf("block_provider").forGetter(var0 -> var0.blockProvider), (App)Codec.intRange((int)1, (int)16).fieldOf("required_empty_blocks").forGetter(var0 -> var0.requiredEmptyBlocks), (App)ExtraCodecs.nonEmptyList(EnumDirection.CODEC.listOf()).fieldOf("directions").forGetter(var0 -> var0.directions)).apply((Applicative)var02, AttachedToLeavesDecorator::new));
    protected final float probability;
    protected final int exclusionRadiusXZ;
    protected final int exclusionRadiusY;
    protected final WorldGenFeatureStateProvider blockProvider;
    protected final int requiredEmptyBlocks;
    protected final List<EnumDirection> directions;

    public AttachedToLeavesDecorator(float var0, int var1, int var2, WorldGenFeatureStateProvider var3, int var4, List<EnumDirection> var5) {
        this.probability = var0;
        this.exclusionRadiusXZ = var1;
        this.exclusionRadiusY = var2;
        this.blockProvider = var3;
        this.requiredEmptyBlocks = var4;
        this.directions = var5;
    }

    @Override
    public void place(WorldGenFeatureTree.a var0) {
        HashSet<BlockPosition> var1 = new HashSet<BlockPosition>();
        RandomSource var2 = var0.random();
        for (BlockPosition var4 : SystemUtils.shuffledCopy(var0.leaves(), var2)) {
            EnumDirection var5;
            BlockPosition var6 = var4.relative(var5 = SystemUtils.getRandom(this.directions, var2));
            if (var1.contains(var6) || !(var2.nextFloat() < this.probability) || !this.hasRequiredEmptyBlocks(var0, var4, var5)) continue;
            BlockPosition var7 = var6.offset(-this.exclusionRadiusXZ, -this.exclusionRadiusY, -this.exclusionRadiusXZ);
            BlockPosition var8 = var6.offset(this.exclusionRadiusXZ, this.exclusionRadiusY, this.exclusionRadiusXZ);
            for (BlockPosition var10 : BlockPosition.betweenClosed(var7, var8)) {
                var1.add(var10.immutable());
            }
            var0.setBlock(var6, this.blockProvider.getState(var2, var6));
        }
    }

    private boolean hasRequiredEmptyBlocks(WorldGenFeatureTree.a var0, BlockPosition var1, EnumDirection var2) {
        for (int var3 = 1; var3 <= this.requiredEmptyBlocks; ++var3) {
            BlockPosition var4 = var1.relative(var2, var3);
            if (var0.isAir(var4)) continue;
            return false;
        }
        return true;
    }

    @Override
    protected WorldGenFeatureTrees<?> type() {
        return WorldGenFeatureTrees.ATTACHED_TO_LEAVES;
    }
}

