/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature;

import com.mojang.serialization.Codec;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.IRegistry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.tags.TagKey;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.IWorldWriter;
import net.minecraft.world.level.VirtualLevelReadable;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.BlockColumnFeature;
import net.minecraft.world.level.levelgen.feature.DiskFeature;
import net.minecraft.world.level.levelgen.feature.DripstoneClusterFeature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.FossilFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.GeodeFeature;
import net.minecraft.world.level.levelgen.feature.LargeDripstoneFeature;
import net.minecraft.world.level.levelgen.feature.MultifaceGrowthFeature;
import net.minecraft.world.level.levelgen.feature.PointedDripstoneFeature;
import net.minecraft.world.level.levelgen.feature.RootSystemFeature;
import net.minecraft.world.level.levelgen.feature.ScatteredOreFeature;
import net.minecraft.world.level.levelgen.feature.SculkPatchFeature;
import net.minecraft.world.level.levelgen.feature.UnderwaterMagmaFeature;
import net.minecraft.world.level.levelgen.feature.VegetationPatchFeature;
import net.minecraft.world.level.levelgen.feature.WaterloggedVegetationPatchFeature;
import net.minecraft.world.level.levelgen.feature.WorldGenBonusChest;
import net.minecraft.world.level.levelgen.feature.WorldGenDesertWell;
import net.minecraft.world.level.levelgen.feature.WorldGenDungeons;
import net.minecraft.world.level.levelgen.feature.WorldGenEndGateway;
import net.minecraft.world.level.levelgen.feature.WorldGenEndIsland;
import net.minecraft.world.level.levelgen.feature.WorldGenEnder;
import net.minecraft.world.level.levelgen.feature.WorldGenFeatureBamboo;
import net.minecraft.world.level.levelgen.feature.WorldGenFeatureBasaltColumns;
import net.minecraft.world.level.levelgen.feature.WorldGenFeatureBasaltPillar;
import net.minecraft.world.level.levelgen.feature.WorldGenFeatureBlock;
import net.minecraft.world.level.levelgen.feature.WorldGenFeatureBlockPile;
import net.minecraft.world.level.levelgen.feature.WorldGenFeatureBlueIce;
import net.minecraft.world.level.levelgen.feature.WorldGenFeatureChoice;
import net.minecraft.world.level.levelgen.feature.WorldGenFeatureChorusPlant;
import net.minecraft.world.level.levelgen.feature.WorldGenFeatureConfigured;
import net.minecraft.world.level.levelgen.feature.WorldGenFeatureCoralClaw;
import net.minecraft.world.level.levelgen.feature.WorldGenFeatureCoralMushroom;
import net.minecraft.world.level.levelgen.feature.WorldGenFeatureCoralTree;
import net.minecraft.world.level.levelgen.feature.WorldGenFeatureDelta;
import net.minecraft.world.level.levelgen.feature.WorldGenFeatureEmpty;
import net.minecraft.world.level.levelgen.feature.WorldGenFeatureEndPlatform;
import net.minecraft.world.level.levelgen.feature.WorldGenFeatureFill;
import net.minecraft.world.level.levelgen.feature.WorldGenFeatureHugeFungi;
import net.minecraft.world.level.levelgen.feature.WorldGenFeatureHugeFungiConfiguration;
import net.minecraft.world.level.levelgen.feature.WorldGenFeatureIceSnow;
import net.minecraft.world.level.levelgen.feature.WorldGenFeatureIceburg;
import net.minecraft.world.level.levelgen.feature.WorldGenFeatureKelp;
import net.minecraft.world.level.levelgen.feature.WorldGenFeatureNetherForestVegetation;
import net.minecraft.world.level.levelgen.feature.WorldGenFeatureNetherrackReplaceBlobs;
import net.minecraft.world.level.levelgen.feature.WorldGenFeatureRandom2Configuration;
import net.minecraft.world.level.levelgen.feature.WorldGenFeatureRandomChoice;
import net.minecraft.world.level.levelgen.feature.WorldGenFeatureRandomPatch;
import net.minecraft.world.level.levelgen.feature.WorldGenFeatureReplaceBlock;
import net.minecraft.world.level.levelgen.feature.WorldGenFeatureSeaGrass;
import net.minecraft.world.level.levelgen.feature.WorldGenFeatureSeaPickel;
import net.minecraft.world.level.levelgen.feature.WorldGenFeatureTwistingVines;
import net.minecraft.world.level.levelgen.feature.WorldGenFeatureWeepingVines;
import net.minecraft.world.level.levelgen.feature.WorldGenFossils;
import net.minecraft.world.level.levelgen.feature.WorldGenHugeMushroomBrown;
import net.minecraft.world.level.levelgen.feature.WorldGenHugeMushroomRed;
import net.minecraft.world.level.levelgen.feature.WorldGenLakes;
import net.minecraft.world.level.levelgen.feature.WorldGenLightStone1;
import net.minecraft.world.level.levelgen.feature.WorldGenLiquids;
import net.minecraft.world.level.levelgen.feature.WorldGenMinable;
import net.minecraft.world.level.levelgen.feature.WorldGenPackedIce2;
import net.minecraft.world.level.levelgen.feature.WorldGenTaigaStructure;
import net.minecraft.world.level.levelgen.feature.WorldGenTrees;
import net.minecraft.world.level.levelgen.feature.WorldGenVines;
import net.minecraft.world.level.levelgen.feature.configurations.BlockColumnConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.DripstoneClusterConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.GeodeConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.LargeDripstoneConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.MultifaceGrowthConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.NetherForestVegetationConfig;
import net.minecraft.world.level.levelgen.feature.configurations.PointedDripstoneConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.RootSystemConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.SculkPatchConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.TwistingVinesConfig;
import net.minecraft.world.level.levelgen.feature.configurations.UnderwaterMagmaConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.VegetationPatchConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.WorldGenDecoratorFrequencyConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.WorldGenEndGatewayConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.WorldGenFeatureBasaltColumnsConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.WorldGenFeatureBlockConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.WorldGenFeatureBlockPileConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.WorldGenFeatureChoiceConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.WorldGenFeatureCircleConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.WorldGenFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.WorldGenFeatureConfigurationChance;
import net.minecraft.world.level.levelgen.feature.configurations.WorldGenFeatureDeltaConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.WorldGenFeatureEmptyConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.WorldGenFeatureEndSpikeConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.WorldGenFeatureFillConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.WorldGenFeatureHellFlowingLavaConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.WorldGenFeatureLakeConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.WorldGenFeatureMushroomConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.WorldGenFeatureOreConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.WorldGenFeatureRadiusConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.WorldGenFeatureRandom2;
import net.minecraft.world.level.levelgen.feature.configurations.WorldGenFeatureRandomChoiceConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.WorldGenFeatureRandomPatchConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.WorldGenFeatureReplaceBlockConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.WorldGenFeatureTreeConfiguration;

public abstract class WorldGenerator<FC extends WorldGenFeatureConfiguration> {
    public static final WorldGenerator<WorldGenFeatureEmptyConfiguration> NO_OP = WorldGenerator.register("no_op", new WorldGenFeatureEmpty(WorldGenFeatureEmptyConfiguration.CODEC));
    public static final WorldGenerator<WorldGenFeatureTreeConfiguration> TREE = WorldGenerator.register("tree", new WorldGenTrees(WorldGenFeatureTreeConfiguration.CODEC));
    public static final WorldGenerator<WorldGenFeatureRandomPatchConfiguration> FLOWER = WorldGenerator.register("flower", new WorldGenFeatureRandomPatch(WorldGenFeatureRandomPatchConfiguration.CODEC));
    public static final WorldGenerator<WorldGenFeatureRandomPatchConfiguration> NO_BONEMEAL_FLOWER = WorldGenerator.register("no_bonemeal_flower", new WorldGenFeatureRandomPatch(WorldGenFeatureRandomPatchConfiguration.CODEC));
    public static final WorldGenerator<WorldGenFeatureRandomPatchConfiguration> RANDOM_PATCH = WorldGenerator.register("random_patch", new WorldGenFeatureRandomPatch(WorldGenFeatureRandomPatchConfiguration.CODEC));
    public static final WorldGenerator<WorldGenFeatureBlockPileConfiguration> BLOCK_PILE = WorldGenerator.register("block_pile", new WorldGenFeatureBlockPile(WorldGenFeatureBlockPileConfiguration.CODEC));
    public static final WorldGenerator<WorldGenFeatureHellFlowingLavaConfiguration> SPRING = WorldGenerator.register("spring_feature", new WorldGenLiquids(WorldGenFeatureHellFlowingLavaConfiguration.CODEC));
    public static final WorldGenerator<WorldGenFeatureEmptyConfiguration> CHORUS_PLANT = WorldGenerator.register("chorus_plant", new WorldGenFeatureChorusPlant(WorldGenFeatureEmptyConfiguration.CODEC));
    public static final WorldGenerator<WorldGenFeatureReplaceBlockConfiguration> REPLACE_SINGLE_BLOCK = WorldGenerator.register("replace_single_block", new WorldGenFeatureReplaceBlock(WorldGenFeatureReplaceBlockConfiguration.CODEC));
    public static final WorldGenerator<WorldGenFeatureEmptyConfiguration> VOID_START_PLATFORM = WorldGenerator.register("void_start_platform", new WorldGenFeatureEndPlatform(WorldGenFeatureEmptyConfiguration.CODEC));
    public static final WorldGenerator<WorldGenFeatureEmptyConfiguration> DESERT_WELL = WorldGenerator.register("desert_well", new WorldGenDesertWell(WorldGenFeatureEmptyConfiguration.CODEC));
    public static final WorldGenerator<FossilFeatureConfiguration> FOSSIL = WorldGenerator.register("fossil", new WorldGenFossils(FossilFeatureConfiguration.CODEC));
    public static final WorldGenerator<WorldGenFeatureMushroomConfiguration> HUGE_RED_MUSHROOM = WorldGenerator.register("huge_red_mushroom", new WorldGenHugeMushroomRed(WorldGenFeatureMushroomConfiguration.CODEC));
    public static final WorldGenerator<WorldGenFeatureMushroomConfiguration> HUGE_BROWN_MUSHROOM = WorldGenerator.register("huge_brown_mushroom", new WorldGenHugeMushroomBrown(WorldGenFeatureMushroomConfiguration.CODEC));
    public static final WorldGenerator<WorldGenFeatureEmptyConfiguration> ICE_SPIKE = WorldGenerator.register("ice_spike", new WorldGenPackedIce2(WorldGenFeatureEmptyConfiguration.CODEC));
    public static final WorldGenerator<WorldGenFeatureEmptyConfiguration> GLOWSTONE_BLOB = WorldGenerator.register("glowstone_blob", new WorldGenLightStone1(WorldGenFeatureEmptyConfiguration.CODEC));
    public static final WorldGenerator<WorldGenFeatureEmptyConfiguration> FREEZE_TOP_LAYER = WorldGenerator.register("freeze_top_layer", new WorldGenFeatureIceSnow(WorldGenFeatureEmptyConfiguration.CODEC));
    public static final WorldGenerator<WorldGenFeatureEmptyConfiguration> VINES = WorldGenerator.register("vines", new WorldGenVines(WorldGenFeatureEmptyConfiguration.CODEC));
    public static final WorldGenerator<BlockColumnConfiguration> BLOCK_COLUMN = WorldGenerator.register("block_column", new BlockColumnFeature(BlockColumnConfiguration.CODEC));
    public static final WorldGenerator<VegetationPatchConfiguration> VEGETATION_PATCH = WorldGenerator.register("vegetation_patch", new VegetationPatchFeature(VegetationPatchConfiguration.CODEC));
    public static final WorldGenerator<VegetationPatchConfiguration> WATERLOGGED_VEGETATION_PATCH = WorldGenerator.register("waterlogged_vegetation_patch", new WaterloggedVegetationPatchFeature(VegetationPatchConfiguration.CODEC));
    public static final WorldGenerator<RootSystemConfiguration> ROOT_SYSTEM = WorldGenerator.register("root_system", new RootSystemFeature(RootSystemConfiguration.CODEC));
    public static final WorldGenerator<MultifaceGrowthConfiguration> MULTIFACE_GROWTH = WorldGenerator.register("multiface_growth", new MultifaceGrowthFeature(MultifaceGrowthConfiguration.CODEC));
    public static final WorldGenerator<UnderwaterMagmaConfiguration> UNDERWATER_MAGMA = WorldGenerator.register("underwater_magma", new UnderwaterMagmaFeature(UnderwaterMagmaConfiguration.CODEC));
    public static final WorldGenerator<WorldGenFeatureEmptyConfiguration> MONSTER_ROOM = WorldGenerator.register("monster_room", new WorldGenDungeons(WorldGenFeatureEmptyConfiguration.CODEC));
    public static final WorldGenerator<WorldGenFeatureEmptyConfiguration> BLUE_ICE = WorldGenerator.register("blue_ice", new WorldGenFeatureBlueIce(WorldGenFeatureEmptyConfiguration.CODEC));
    public static final WorldGenerator<WorldGenFeatureLakeConfiguration> ICEBERG = WorldGenerator.register("iceberg", new WorldGenFeatureIceburg(WorldGenFeatureLakeConfiguration.CODEC));
    public static final WorldGenerator<WorldGenFeatureLakeConfiguration> FOREST_ROCK = WorldGenerator.register("forest_rock", new WorldGenTaigaStructure(WorldGenFeatureLakeConfiguration.CODEC));
    public static final WorldGenerator<WorldGenFeatureCircleConfiguration> DISK = WorldGenerator.register("disk", new DiskFeature(WorldGenFeatureCircleConfiguration.CODEC));
    public static final WorldGenerator<WorldGenLakes.a> LAKE = WorldGenerator.register("lake", new WorldGenLakes(WorldGenLakes.a.CODEC));
    public static final WorldGenerator<WorldGenFeatureOreConfiguration> ORE = WorldGenerator.register("ore", new WorldGenMinable(WorldGenFeatureOreConfiguration.CODEC));
    public static final WorldGenerator<WorldGenFeatureEndSpikeConfiguration> END_SPIKE = WorldGenerator.register("end_spike", new WorldGenEnder(WorldGenFeatureEndSpikeConfiguration.CODEC));
    public static final WorldGenerator<WorldGenFeatureEmptyConfiguration> END_ISLAND = WorldGenerator.register("end_island", new WorldGenEndIsland(WorldGenFeatureEmptyConfiguration.CODEC));
    public static final WorldGenerator<WorldGenEndGatewayConfiguration> END_GATEWAY = WorldGenerator.register("end_gateway", new WorldGenEndGateway(WorldGenEndGatewayConfiguration.CODEC));
    public static final WorldGenFeatureSeaGrass SEAGRASS = WorldGenerator.register("seagrass", new WorldGenFeatureSeaGrass(WorldGenFeatureConfigurationChance.CODEC));
    public static final WorldGenerator<WorldGenFeatureEmptyConfiguration> KELP = WorldGenerator.register("kelp", new WorldGenFeatureKelp(WorldGenFeatureEmptyConfiguration.CODEC));
    public static final WorldGenerator<WorldGenFeatureEmptyConfiguration> CORAL_TREE = WorldGenerator.register("coral_tree", new WorldGenFeatureCoralTree(WorldGenFeatureEmptyConfiguration.CODEC));
    public static final WorldGenerator<WorldGenFeatureEmptyConfiguration> CORAL_MUSHROOM = WorldGenerator.register("coral_mushroom", new WorldGenFeatureCoralMushroom(WorldGenFeatureEmptyConfiguration.CODEC));
    public static final WorldGenerator<WorldGenFeatureEmptyConfiguration> CORAL_CLAW = WorldGenerator.register("coral_claw", new WorldGenFeatureCoralClaw(WorldGenFeatureEmptyConfiguration.CODEC));
    public static final WorldGenerator<WorldGenDecoratorFrequencyConfiguration> SEA_PICKLE = WorldGenerator.register("sea_pickle", new WorldGenFeatureSeaPickel(WorldGenDecoratorFrequencyConfiguration.CODEC));
    public static final WorldGenerator<WorldGenFeatureBlockConfiguration> SIMPLE_BLOCK = WorldGenerator.register("simple_block", new WorldGenFeatureBlock(WorldGenFeatureBlockConfiguration.CODEC));
    public static final WorldGenerator<WorldGenFeatureConfigurationChance> BAMBOO = WorldGenerator.register("bamboo", new WorldGenFeatureBamboo(WorldGenFeatureConfigurationChance.CODEC));
    public static final WorldGenerator<WorldGenFeatureHugeFungiConfiguration> HUGE_FUNGUS = WorldGenerator.register("huge_fungus", new WorldGenFeatureHugeFungi(WorldGenFeatureHugeFungiConfiguration.CODEC));
    public static final WorldGenerator<NetherForestVegetationConfig> NETHER_FOREST_VEGETATION = WorldGenerator.register("nether_forest_vegetation", new WorldGenFeatureNetherForestVegetation(NetherForestVegetationConfig.CODEC));
    public static final WorldGenerator<WorldGenFeatureEmptyConfiguration> WEEPING_VINES = WorldGenerator.register("weeping_vines", new WorldGenFeatureWeepingVines(WorldGenFeatureEmptyConfiguration.CODEC));
    public static final WorldGenerator<TwistingVinesConfig> TWISTING_VINES = WorldGenerator.register("twisting_vines", new WorldGenFeatureTwistingVines(TwistingVinesConfig.CODEC));
    public static final WorldGenerator<WorldGenFeatureBasaltColumnsConfiguration> BASALT_COLUMNS = WorldGenerator.register("basalt_columns", new WorldGenFeatureBasaltColumns(WorldGenFeatureBasaltColumnsConfiguration.CODEC));
    public static final WorldGenerator<WorldGenFeatureDeltaConfiguration> DELTA_FEATURE = WorldGenerator.register("delta_feature", new WorldGenFeatureDelta(WorldGenFeatureDeltaConfiguration.CODEC));
    public static final WorldGenerator<WorldGenFeatureRadiusConfiguration> REPLACE_BLOBS = WorldGenerator.register("netherrack_replace_blobs", new WorldGenFeatureNetherrackReplaceBlobs(WorldGenFeatureRadiusConfiguration.CODEC));
    public static final WorldGenerator<WorldGenFeatureFillConfiguration> FILL_LAYER = WorldGenerator.register("fill_layer", new WorldGenFeatureFill(WorldGenFeatureFillConfiguration.CODEC));
    public static final WorldGenBonusChest BONUS_CHEST = WorldGenerator.register("bonus_chest", new WorldGenBonusChest(WorldGenFeatureEmptyConfiguration.CODEC));
    public static final WorldGenerator<WorldGenFeatureEmptyConfiguration> BASALT_PILLAR = WorldGenerator.register("basalt_pillar", new WorldGenFeatureBasaltPillar(WorldGenFeatureEmptyConfiguration.CODEC));
    public static final WorldGenerator<WorldGenFeatureOreConfiguration> SCATTERED_ORE = WorldGenerator.register("scattered_ore", new ScatteredOreFeature(WorldGenFeatureOreConfiguration.CODEC));
    public static final WorldGenerator<WorldGenFeatureRandomChoiceConfiguration> RANDOM_SELECTOR = WorldGenerator.register("random_selector", new WorldGenFeatureRandomChoice(WorldGenFeatureRandomChoiceConfiguration.CODEC));
    public static final WorldGenerator<WorldGenFeatureRandom2> SIMPLE_RANDOM_SELECTOR = WorldGenerator.register("simple_random_selector", new WorldGenFeatureRandom2Configuration(WorldGenFeatureRandom2.CODEC));
    public static final WorldGenerator<WorldGenFeatureChoiceConfiguration> RANDOM_BOOLEAN_SELECTOR = WorldGenerator.register("random_boolean_selector", new WorldGenFeatureChoice(WorldGenFeatureChoiceConfiguration.CODEC));
    public static final WorldGenerator<GeodeConfiguration> GEODE = WorldGenerator.register("geode", new GeodeFeature(GeodeConfiguration.CODEC));
    public static final WorldGenerator<DripstoneClusterConfiguration> DRIPSTONE_CLUSTER = WorldGenerator.register("dripstone_cluster", new DripstoneClusterFeature(DripstoneClusterConfiguration.CODEC));
    public static final WorldGenerator<LargeDripstoneConfiguration> LARGE_DRIPSTONE = WorldGenerator.register("large_dripstone", new LargeDripstoneFeature(LargeDripstoneConfiguration.CODEC));
    public static final WorldGenerator<PointedDripstoneConfiguration> POINTED_DRIPSTONE = WorldGenerator.register("pointed_dripstone", new PointedDripstoneFeature(PointedDripstoneConfiguration.CODEC));
    public static final WorldGenerator<SculkPatchConfiguration> SCULK_PATCH = WorldGenerator.register("sculk_patch", new SculkPatchFeature(SculkPatchConfiguration.CODEC));
    private final Codec<WorldGenFeatureConfigured<FC, WorldGenerator<FC>>> configuredCodec;

    private static <C extends WorldGenFeatureConfiguration, F extends WorldGenerator<C>> F register(String var0, F var1) {
        return (F)IRegistry.register(BuiltInRegistries.FEATURE, var0, var1);
    }

    public WorldGenerator(Codec<FC> var02) {
        this.configuredCodec = var02.fieldOf("config").xmap(var0 -> new WorldGenFeatureConfigured<WorldGenFeatureConfiguration, WorldGenerator>(this, (WorldGenFeatureConfiguration)var0), WorldGenFeatureConfigured::config).codec();
    }

    public Codec<WorldGenFeatureConfigured<FC, WorldGenerator<FC>>> configuredCodec() {
        return this.configuredCodec;
    }

    protected void setBlock(IWorldWriter var0, BlockPosition var1, IBlockData var2) {
        var0.setBlock(var1, var2, 3);
    }

    public static Predicate<IBlockData> isReplaceable(TagKey<Block> var0) {
        return var1 -> !var1.is(var0);
    }

    protected void safeSetBlock(GeneratorAccessSeed var0, BlockPosition var1, IBlockData var2, Predicate<IBlockData> var3) {
        if (var3.test(var0.getBlockState(var1))) {
            var0.setBlock(var1, var2, 2);
        }
    }

    public abstract boolean place(FeaturePlaceContext<FC> var1);

    public boolean place(FC var0, GeneratorAccessSeed var1, ChunkGenerator var2, RandomSource var3, BlockPosition var4) {
        if (var1.ensureCanWrite(var4)) {
            return this.place(new FeaturePlaceContext<FC>(Optional.empty(), var1, var2, var3, var4, var0));
        }
        return false;
    }

    protected static boolean isStone(IBlockData var0) {
        return var0.is(TagsBlock.BASE_STONE_OVERWORLD);
    }

    public static boolean isDirt(IBlockData var0) {
        return var0.is(TagsBlock.DIRT);
    }

    public static boolean isGrassOrDirt(VirtualLevelReadable var0, BlockPosition var1) {
        return var0.isStateAtPosition(var1, WorldGenerator::isDirt);
    }

    public static boolean checkNeighbors(Function<BlockPosition, IBlockData> var0, BlockPosition var1, Predicate<IBlockData> var2) {
        BlockPosition.MutableBlockPosition var3 = new BlockPosition.MutableBlockPosition();
        for (EnumDirection var7 : EnumDirection.values()) {
            var3.setWithOffset((BaseBlockPosition)var1, var7);
            if (!var2.test(var0.apply(var3))) continue;
            return true;
        }
        return false;
    }

    public static boolean isAdjacentToAir(Function<BlockPosition, IBlockData> var0, BlockPosition var1) {
        return WorldGenerator.checkNeighbors(var0, var1, BlockBase.BlockData::isAir);
    }

    protected void markAboveForPostProcessing(GeneratorAccessSeed var0, BlockPosition var1) {
        BlockPosition.MutableBlockPosition var2 = var1.mutable();
        for (int var3 = 0; var3 < 2; ++var3) {
            var2.move(EnumDirection.UP);
            if (var0.getBlockState(var2).isAir()) {
                return;
            }
            var0.getChunk(var2).markPosForPostprocessing(var2);
        }
    }
}

