/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature;

import com.mojang.serialization.Codec;
import java.util.Optional;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockCoralFanWallAbstract;
import net.minecraft.world.level.block.BlockSeaPickle;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.WorldGenerator;
import net.minecraft.world.level.levelgen.feature.configurations.WorldGenFeatureEmptyConfiguration;

public abstract class WorldGenFeatureCoral
extends WorldGenerator<WorldGenFeatureEmptyConfiguration> {
    public WorldGenFeatureCoral(Codec<WorldGenFeatureEmptyConfiguration> var0) {
        super(var0);
    }

    @Override
    public boolean place(FeaturePlaceContext<WorldGenFeatureEmptyConfiguration> var0) {
        RandomSource var12 = var0.random();
        GeneratorAccessSeed var2 = var0.level();
        BlockPosition var3 = var0.origin();
        Optional<Block> var4 = BuiltInRegistries.BLOCK.getTag(TagsBlock.CORAL_BLOCKS).flatMap(var1 -> var1.getRandomElement(var12)).map(Holder::value);
        if (var4.isEmpty()) {
            return false;
        }
        return this.placeFeature(var2, var12, var3, var4.get().defaultBlockState());
    }

    protected abstract boolean placeFeature(GeneratorAccess var1, RandomSource var2, BlockPosition var3, IBlockData var4);

    protected boolean placeCoralBlock(GeneratorAccess var0, RandomSource var12, BlockPosition var22, IBlockData var32) {
        BlockPosition var4 = var22.above();
        IBlockData var5 = var0.getBlockState(var22);
        if (!var5.is(Blocks.WATER) && !var5.is(TagsBlock.CORALS) || !var0.getBlockState(var4).is(Blocks.WATER)) {
            return false;
        }
        var0.setBlock(var22, var32, 3);
        if (var12.nextFloat() < 0.25f) {
            BuiltInRegistries.BLOCK.getTag(TagsBlock.CORALS).flatMap(var1 -> var1.getRandomElement(var12)).map(Holder::value).ifPresent(var2 -> var0.setBlock(var4, var2.defaultBlockState(), 2));
        } else if (var12.nextFloat() < 0.05f) {
            var0.setBlock(var4, (IBlockData)Blocks.SEA_PICKLE.defaultBlockState().setValue(BlockSeaPickle.PICKLES, var12.nextInt(4) + 1), 2);
        }
        for (EnumDirection var7 : EnumDirection.EnumDirectionLimit.HORIZONTAL) {
            BlockPosition var8;
            if (!(var12.nextFloat() < 0.2f) || !var0.getBlockState(var8 = var22.relative(var7)).is(Blocks.WATER)) continue;
            BuiltInRegistries.BLOCK.getTag(TagsBlock.WALL_CORALS).flatMap(var1 -> var1.getRandomElement(var12)).map(Holder::value).ifPresent(var3 -> {
                IBlockData var4 = var3.defaultBlockState();
                if (var4.hasProperty(BlockCoralFanWallAbstract.FACING)) {
                    var4 = (IBlockData)var4.setValue(BlockCoralFanWallAbstract.FACING, var7);
                }
                var0.setBlock(var8, var4, 2);
            });
        }
        return true;
    }
}

