/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.gameevent.vibrations;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.world.level.gameevent.vibrations.VibrationInfo;
import net.minecraft.world.level.gameevent.vibrations.VibrationSystem;
import org.apache.commons.lang3.tuple.Pair;

public class VibrationSelector {
    public static final Codec<VibrationSelector> CODEC = RecordCodecBuilder.create(var02 -> var02.group((App)VibrationInfo.CODEC.optionalFieldOf("event").forGetter(var0 -> var0.currentVibrationData.map(Pair::getLeft)), (App)Codec.LONG.fieldOf("tick").forGetter(var0 -> var0.currentVibrationData.map(Pair::getRight).orElse(-1L))).apply((Applicative)var02, VibrationSelector::new));
    private Optional<Pair<VibrationInfo, Long>> currentVibrationData;

    public VibrationSelector(Optional<VibrationInfo> var0, long var1) {
        this.currentVibrationData = var0.map(var2 -> Pair.of((Object)var2, (Object)var1));
    }

    public VibrationSelector() {
        this.currentVibrationData = Optional.empty();
    }

    public void addCandidate(VibrationInfo var0, long var1) {
        if (this.shouldReplaceVibration(var0, var1)) {
            this.currentVibrationData = Optional.of(Pair.of((Object)var0, (Object)var1));
        }
    }

    private boolean shouldReplaceVibration(VibrationInfo var0, long var1) {
        if (this.currentVibrationData.isEmpty()) {
            return true;
        }
        Pair<VibrationInfo, Long> var3 = this.currentVibrationData.get();
        long var4 = (Long)var3.getRight();
        if (var1 != var4) {
            return false;
        }
        VibrationInfo var6 = (VibrationInfo)var3.getLeft();
        if (var0.distance() < var6.distance()) {
            return true;
        }
        if (var0.distance() > var6.distance()) {
            return false;
        }
        return VibrationSystem.getGameEventFrequency(var0.gameEvent()) > VibrationSystem.getGameEventFrequency(var6.gameEvent());
    }

    public Optional<VibrationInfo> chosenCandidate(long var0) {
        if (this.currentVibrationData.isEmpty()) {
            return Optional.empty();
        }
        if ((Long)this.currentVibrationData.get().getRight() < var0) {
            return Optional.of((VibrationInfo)this.currentVibrationData.get().getLeft());
        }
        return Optional.empty();
    }

    public void startOver() {
        this.currentVibrationData = Optional.empty();
    }
}

